/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.world.capabilities.entitypatch.mob;

import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.animation.ClientAnimator;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.MobCombatBehaviors;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPChangeLivingMotion;
import yesman.epicfight.network.server.SPSpawnData;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.effect.EpicFightMobEffects;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.ai.goal.AnimatedAttackGoal;
import yesman.epicfight.world.entity.ai.goal.CombatBehaviorGoal;
import yesman.epicfight.world.entity.ai.goal.CombatBehaviors;
import yesman.epicfight.world.entity.ai.goal.TargetChasingGoal;

public class EndermanPatch
extends MobPatch<EnderMan> {
    private static final UUID SPEED_MODIFIER_RAGE_UUID = UUID.fromString("dc362d1a-8424-11ec-a8a3-0242ac120002");
    private static final AttributeModifier SPEED_MODIFIER_RAGE = new AttributeModifier(SPEED_MODIFIER_RAGE_UUID, "Rage speed bonus", 0.1, AttributeModifier.Operation.ADDITION);
    private int deathTimerExt = 0;
    private boolean onRage;
    private Goal normalAttacks;
    private Goal teleportAttacks;
    private Goal rageAttacks;
    private Goal rageTargeting;

    public EndermanPatch() {
        super(Faction.ENDERMAN);
    }

    @Override
    public void onJoinWorld(EnderMan enderman, EntityJoinLevelEvent event) {
        if (enderman.f_19853_.m_46472_() == Level.f_46430_ && enderman.m_20182_().m_165925_() < 40000.0) {
            event.setCanceled(true);
        }
        super.onJoinWorld(enderman, event);
    }

    @Override
    public void onStartTracking(ServerPlayer trackingPlayer) {
        if (this.isRaging()) {
            SPSpawnData packet = new SPSpawnData(((EnderMan)this.original).m_19879_());
            EpicFightNetworkManager.sendToPlayer(packet, trackingPlayer);
        }
    }

    @Override
    public void processSpawnData(ByteBuf buf) {
        ClientAnimator animator = this.getClientAnimator();
        animator.addLivingAnimation(LivingMotions.IDLE, Animations.ENDERMAN_RAGE_IDLE);
        animator.addLivingAnimation(LivingMotions.WALK, Animations.ENDERMAN_RAGE_WALK);
        animator.setCurrentMotionsAsDefault();
    }

    @Override
    protected void initAttributes() {
        super.initAttributes();
        ((EnderMan)this.original).m_21051_((Attribute)EpicFightAttributes.STUN_ARMOR.get()).m_22100_(8.0);
        ((EnderMan)this.original).m_21051_((Attribute)EpicFightAttributes.IMPACT.get()).m_22100_((double)1.8f);
    }

    @Override
    protected void initAI() {
        super.initAI();
        this.normalAttacks = new AnimatedAttackGoal<EndermanPatch>(this, MobCombatBehaviors.ENDERMAN.build(this));
        this.teleportAttacks = new EndermanTeleportMove(this, MobCombatBehaviors.ENDERMAN_TELEPORT.build(this));
        this.rageAttacks = new AnimatedAttackGoal<EndermanPatch>(this, MobCombatBehaviors.ENDERMAN_RAGE.build(this));
        this.rageTargeting = new NearestAttackableTargetGoal((Mob)this.original, Player.class, true);
        ((EnderMan)this.original).f_21345_.m_25352_(1, (Goal)new TargetChasingGoal(this, (PathfinderMob)this.getOriginal(), 0.75, false));
        if (this.isRaging()) {
            ((EnderMan)this.original).f_21346_.m_25352_(3, this.rageTargeting);
            ((EnderMan)this.original).f_21345_.m_25352_(1, this.rageAttacks);
        } else {
            ((EnderMan)this.original).f_21345_.m_25352_(1, this.normalAttacks);
            ((EnderMan)this.original).f_21345_.m_25352_(0, this.teleportAttacks);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initAnimator(ClientAnimator clientAnimator) {
        clientAnimator.addLivingAnimation(LivingMotions.DEATH, Animations.ENDERMAN_DEATH);
        clientAnimator.addLivingAnimation(LivingMotions.WALK, Animations.ENDERMAN_WALK);
        clientAnimator.addLivingAnimation(LivingMotions.IDLE, Animations.ENDERMAN_IDLE);
        clientAnimator.setCurrentMotionsAsDefault();
    }

    @Override
    public void updateMotion(boolean considerInaction) {
        super.commonMobUpdateMotion(considerInaction);
    }

    @Override
    public void serverTick(LivingEvent.LivingTickEvent event) {
        super.serverTick(event);
        if (this.isRaging() && !this.onRage && ((EnderMan)this.original).f_19797_ > 5) {
            this.toRaging();
        } else if (this.onRage && !this.isRaging()) {
            this.toNormal();
        }
    }

    @Override
    public void tick(LivingEvent.LivingTickEvent event) {
        if (((EnderMan)this.original).m_21223_() <= 0.0f) {
            ((EnderMan)this.original).m_146926_(0.0f);
            if (((EnderMan)this.original).f_20919_ > 1 && this.deathTimerExt < 20) {
                ++this.deathTimerExt;
                --((EnderMan)this.original).f_20919_;
            }
        }
        super.tick(event);
    }

    @Override
    public AttackResult tryHurt(DamageSource damageSource, float amount) {
        if (!((EnderMan)this.original).f_19853_.m_5776_() && damageSource instanceof EntityDamageSource && !this.isRaging()) {
            EpicFightDamageSource extDamageSource = null;
            if (damageSource instanceof EpicFightDamageSource) {
                extDamageSource = (EpicFightDamageSource)damageSource;
            }
            if (extDamageSource == null || extDamageSource.getStunType() != StunType.HOLD) {
                int percentage;
                int n = percentage = this.getServerAnimator().getPlayerFor(null).getAnimation() instanceof AttackAnimation ? 10 : 3;
                if (((EnderMan)this.original).m_217043_().m_188503_(percentage) == 0) {
                    for (int i = 0; i < 9; ++i) {
                        if (!((EnderMan)this.original).m_32529_()) continue;
                        if (damageSource.m_7639_() instanceof LivingEntity) {
                            ((EnderMan)this.original).m_6703_((LivingEntity)damageSource.m_7639_());
                        }
                        if (this.state.inaction()) {
                            this.playAnimationSynchronized(Animations.ENDERMAN_TP_EMERGENCE, 0.0f);
                        }
                        return AttackResult.blocked(amount);
                    }
                }
            }
        }
        return super.tryHurt(damageSource, amount);
    }

    public boolean isRaging() {
        return ((EnderMan)this.original).m_21223_() / ((EnderMan)this.original).m_21233_() < 0.33f;
    }

    protected void toRaging() {
        this.onRage = true;
        this.playAnimationSynchronized(Animations.ENDERMAN_CONVERT_RAGE, 0.0f);
        if (!((EnderMan)this.original).m_21525_()) {
            ((EnderMan)this.original).f_21345_.m_25363_(this.normalAttacks);
            ((EnderMan)this.original).f_21345_.m_25363_(this.teleportAttacks);
            ((EnderMan)this.original).f_21345_.m_25352_(1, this.rageAttacks);
            ((EnderMan)this.original).f_21346_.m_25352_(3, this.rageTargeting);
            ((EnderMan)this.original).m_20088_().m_135381_(EnderMan.f_32473_, (Object)true);
            ((EnderMan)this.original).m_7292_(new MobEffectInstance((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get(), 120000));
            ((EnderMan)this.original).m_21051_(Attributes.f_22279_).m_22118_(SPEED_MODIFIER_RAGE);
            SPChangeLivingMotion msg = new SPChangeLivingMotion(((EnderMan)this.original).m_19879_(), true).putPair(LivingMotions.IDLE, Animations.ENDERMAN_RAGE_IDLE).putPair(LivingMotions.WALK, Animations.ENDERMAN_RAGE_WALK);
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(msg, this.original);
        }
    }

    protected void toNormal() {
        this.onRage = false;
        if (!((EnderMan)this.original).m_21525_()) {
            ((EnderMan)this.original).f_21345_.m_25352_(1, this.normalAttacks);
            ((EnderMan)this.original).f_21345_.m_25352_(0, this.teleportAttacks);
            ((EnderMan)this.original).f_21345_.m_25363_(this.rageAttacks);
            ((EnderMan)this.original).f_21346_.m_25363_(this.rageTargeting);
            if (((EnderMan)this.original).m_5448_() == null) {
                ((EnderMan)this.original).m_20088_().m_135381_(EnderMan.f_32473_, (Object)false);
            }
            ((EnderMan)this.original).m_21195_((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get());
            ((EnderMan)this.original).m_21051_(Attributes.f_22279_).m_22130_(SPEED_MODIFIER_RAGE);
            SPChangeLivingMotion msg = new SPChangeLivingMotion(((EnderMan)this.original).m_19879_(), true).putPair(LivingMotions.IDLE, Animations.ENDERMAN_IDLE).putPair(LivingMotions.WALK, Animations.ENDERMAN_WALK);
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(msg, this.original);
        }
    }

    @Override
    public void aboutToDeath() {
        ((EnderMan)this.original).m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
        if (this.isLogicalClient()) {
            for (int i = 0; i < 100; ++i) {
                RandomSource rand = ((EnderMan)this.original).m_217043_();
                Vec3f vec = new Vec3f(rand.m_188502_(), rand.m_188502_(), rand.m_188502_());
                vec.normalise().scale(0.5f);
                Minecraft minecraft = Minecraft.m_91087_();
                minecraft.f_91061_.m_107370_((ParticleOptions)EpicFightParticles.ENDERMAN_DEATH_EMIT.get(), ((EnderMan)this.original).m_20185_(), ((EnderMan)this.original).m_20186_() + (double)(((EnderMan)this.original).m_6972_((Pose)Pose.STANDING).f_20378_ / 2.0f), ((EnderMan)this.original).m_20189_(), (double)vec.x, (double)vec.y, (double)vec.z);
            }
        }
        super.aboutToDeath();
    }

    @Override
    public StaticAnimation getHitAnimation(StunType stunType) {
        switch (stunType) {
            case SHORT: {
                return Animations.ENDERMAN_HIT_SHORT;
            }
            case LONG: {
                return Animations.ENDERMAN_HIT_LONG;
            }
            case HOLD: {
                return Animations.ENDERMAN_HIT_SHORT;
            }
            case KNOCKDOWN: {
                return Animations.ENDERMAN_NEUTRALIZED;
            }
            case NEUTRALIZE: {
                return Animations.ENDERMAN_NEUTRALIZED;
            }
        }
        return null;
    }

    static class EndermanTeleportMove
    extends CombatBehaviorGoal<EndermanPatch> {
        private int waitingCounter;
        private int delayCounter;
        private CombatBehaviors.Behavior<EndermanPatch> move;

        public EndermanTeleportMove(EndermanPatch mobpatch, CombatBehaviors<EndermanPatch> mobAttacks) {
            super(mobpatch, mobAttacks);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        public boolean m_8036_() {
            this.combatBehaviors.tick();
            if (super.m_8036_()) {
                this.move = this.combatBehaviors.selectRandomBehaviorSeries();
                return this.move != null;
            }
            return false;
        }

        @Override
        public boolean m_8045_() {
            boolean waitExpired;
            boolean bl = waitExpired = this.waitingCounter <= 100;
            if (!waitExpired) {
                this.waitingCounter = 500;
            }
            return this.isValidTarget(this.mob.m_5448_()) && !((EndermanPatch)this.mobpatch).getEntityState().hurt() && !((EndermanPatch)this.mobpatch).getEntityState().inaction() && waitExpired;
        }

        public void m_8056_() {
            this.delayCounter = 20 + this.mob.m_217043_().m_188503_(5);
            this.waitingCounter = 0;
        }

        public void m_8041_() {
            this.move = null;
        }

        @Override
        public void m_8037_() {
            LivingEntity target = this.mob.m_5448_();
            this.mob.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            if (this.delayCounter-- < 0 && !((EndermanPatch)this.mobpatch).getEntityState().inaction()) {
                Vec3f vec = new Vec3f((float)(this.mob.m_20185_() - target.m_20185_()), 0.0f, (float)(this.mob.m_20189_() - target.m_20189_()));
                vec.normalise().scale(1.414f);
                boolean flag = this.mob.m_20984_(target.m_20185_() + (double)vec.x, target.m_20186_(), target.m_20189_() + (double)vec.z, true);
                if (flag) {
                    ((EndermanPatch)this.mobpatch).rotateTo((Entity)target, 360.0f, true);
                    this.move.execute((EndermanPatch)this.mobpatch);
                    this.mob.f_19853_.m_6263_(null, this.mob.f_19854_, this.mob.f_19855_, this.mob.f_19856_, SoundEvents.f_11852_, this.mob.m_5720_(), 1.0f, 1.0f);
                    this.mob.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
                    this.waitingCounter = 0;
                } else {
                    ++this.waitingCounter;
                }
            }
        }
    }
}

