/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.passive;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPSkillExecutionFeedback;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillCategories;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class HyperVitalitySkill
extends PassiveSkill {
    private static final UUID EVENT_UUID = UUID.fromString("06fb3f66-b900-11ed-afa1-0242ac120002");

    public HyperVitalitySkill(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    @Override
    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.SKILL_CONSUME_EVENT, EVENT_UUID, event -> {
            float consumption;
            Object playerpatch;
            if (!container.getExecuter().getSkill(event.getSkill()).isDisabled() && event.getSkill().getCategory() == SkillCategories.WEAPON_INNATE && ((PlayerPatch)(playerpatch = event.getPlayerPatch())).getSkill(SkillSlots.WEAPON_INNATE).getStack() < 1 && container.getStack() > 0 && !((Player)((EntityPatch)playerpatch).getOriginal()).m_7500_() && ((PlayerPatch)playerpatch).hasStamina((consumption = event.getSkill().getConsumption()) * 0.1f)) {
                event.setResourceType(Skill.Resource.NONE);
                container.setMaxResource(consumption * 0.2f);
                if (event.shouldConsume()) {
                    container.getExecuter().consumeStamina(consumption * 0.1f);
                    container.setMaxDuration(event.getSkill().getMaxDuration());
                    container.activate();
                    EpicFightNetworkManager.sendToPlayer(SPSkillExecutionFeedback.executed(container.getSlotId()), (ServerPlayer)((EntityPatch)playerpatch).getOriginal());
                }
            }
        }, 1);
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.SKILL_CANCEL_EVENT, EVENT_UUID, event -> {
            if (!container.getExecuter().isLogicalClient() && !((Player)container.getExecuter().getOriginal()).m_7500_() && event.getSkillContainer().getSkill().getCategory() == SkillCategories.WEAPON_INNATE && container.isActivated()) {
                container.setResource(0.0f);
                container.deactivate();
                ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)container.getExecuter();
                this.setStackSynchronize(serverPlayerPatch, container.getStack() - 1);
                EpicFightNetworkManager.sendToPlayer(SPSkillExecutionFeedback.executed(container.getSlotId()), (ServerPlayer)serverPlayerPatch.getOriginal());
            }
        });
    }

    @Override
    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.SKILL_CONSUME_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.SKILL_CANCEL_EVENT, EVENT_UUID);
    }

    @Override
    public void executeOnClient(LocalPlayerPatch executer, FriendlyByteBuf args) {
        super.executeOnClient(executer, args);
        executer.getSkill(this).activate();
    }

    @Override
    public void cancelOnClient(LocalPlayerPatch executer, FriendlyByteBuf args) {
        super.cancelOnClient(executer, args);
        executer.getSkill(this).deactivate();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        return container.isActivated() || container.getStack() == 0;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, PoseStack poseStack, float x, float y) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, (double)gui.getSlidingProgression(), 0.0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getSkillTexture());
        GuiComponent.m_93160_((PoseStack)poseStack, (int)((int)x), (int)((int)y), (int)24, (int)24, (float)0.0f, (float)0.0f, (int)1, (int)1, (int)1, (int)1);
        if (!container.isActivated()) {
            String remainTime = String.format("%.0f", Float.valueOf(container.getMaxResource() - container.getResource()));
            gui.font.m_92750_(poseStack, remainTime, x + 12.0f - (float)(4 * remainTime.length()), y + 6.0f, 0xFFFFFF);
            poseStack.m_85849_();
        }
    }
}

