/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.passive;

import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class ForbiddenStrengthSkill
extends PassiveSkill {
    private static final UUID EVENT_UUID = UUID.fromString("0cfd60ba-b900-11ed-afa1-0242ac120002");

    public ForbiddenStrengthSkill(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    @Override
    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.SKILL_CONSUME_EVENT, EVENT_UUID, event -> {
            if (event.getResourceType() == Skill.Resource.STAMINA) {
                float staminaConsume = event.getAmount();
                if (!container.getExecuter().hasStamina(staminaConsume) && !((Player)container.getExecuter().getOriginal()).m_7500_()) {
                    event.setResourceType(Skill.Resource.HEALTH);
                    event.setAmount(staminaConsume);
                    if (event.shouldConsume()) {
                        Player player = (Player)container.getExecuter().getOriginal();
                        player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)EpicFightSounds.FORBIDDEN_STRENGTH.get(), player.m_5720_(), 1.0f, 1.0f);
                        ((ServerLevel)player.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123798_, player.m_20185_(), player.m_20227_(0.5), player.m_20189_(), (int)staminaConsume, 0.1, 0.0, 0.1, 0.2);
                    }
                }
            }
        });
    }

    @Override
    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.SKILL_CONSUME_EVENT, EVENT_UUID);
    }
}

