/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill.mover;

import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class PhantomAscentSkill
extends Skill {
    private static final UUID EVENT_UUID = UUID.fromString("051a9bb2-7541-11ee-b962-0242ac120002");
    private static final SkillDataManager.SkillDataKey<Boolean> JUMP_KEY_PRESSED_LAST_TIME = SkillDataManager.SkillDataKey.createDataKey(SkillDataManager.ValueType.BOOLEAN);
    private static final SkillDataManager.SkillDataKey<Boolean> PROTECT_NEXT_FALL = SkillDataManager.SkillDataKey.createDataKey(SkillDataManager.ValueType.BOOLEAN);
    private static final SkillDataManager.SkillDataKey<Integer> JUMP_COUNT = SkillDataManager.SkillDataKey.createDataKey(SkillDataManager.ValueType.INTEGER);
    private final StaticAnimation[] animations = new StaticAnimation[2];
    private int extraJumps;

    public PhantomAscentSkill(Skill.Builder<? extends Skill> builder) {
        super(builder);
        this.animations[0] = EpicFightMod.getInstance().animationManager.findAnimationByPath("epicfight:biped/skill/phantom_ascent_forward");
        this.animations[1] = EpicFightMod.getInstance().animationManager.findAnimationByPath("epicfight:biped/skill/phantom_ascent_backward");
    }

    @Override
    public void setParams(CompoundTag parameters) {
        super.setParams(parameters);
        this.extraJumps = parameters.m_128451_("extra_jumps");
        this.consumption = 0.2f;
    }

    @Override
    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        PlayerEventListener listener = container.getExecuter().getEventListener();
        container.getDataManager().registerData(JUMP_KEY_PRESSED_LAST_TIME);
        container.getDataManager().registerData(PROTECT_NEXT_FALL);
        container.getDataManager().registerData(JUMP_COUNT);
        listener.addEventListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID, event -> {
            if (((LocalPlayer)((LocalPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20202_() != null || !((LocalPlayerPatch)event.getPlayerPatch()).isBattleMode() || ((LocalPlayer)((LocalPlayerPatch)event.getPlayerPatch()).getOriginal()).m_150110_().f_35935_ || ((LocalPlayerPatch)event.getPlayerPatch()).isChargingSkill() || ((LocalPlayerPatch)event.getPlayerPatch()).getEntityState().inaction()) {
                return;
            }
            boolean jumpPressed = Minecraft.m_91087_().f_91066_.f_92089_.m_90857_();
            boolean jumpPressedPrev = container.getDataManager().getDataValue(JUMP_KEY_PRESSED_LAST_TIME);
            if (jumpPressed && !jumpPressedPrev) {
                if (container.getStack() < 1) {
                    return;
                }
                int jumpCounter = container.getDataManager().getDataValue(JUMP_COUNT);
                if (jumpCounter > 0 || ((LocalPlayerPatch)event.getPlayerPatch()).currentLivingMotion == LivingMotions.FALL) {
                    if (jumpCounter < this.extraJumps + 1) {
                        container.setResource(0.0f);
                        if (jumpCounter == 0 && ((LocalPlayerPatch)event.getPlayerPatch()).currentLivingMotion == LivingMotions.FALL) {
                            container.getDataManager().setData(JUMP_COUNT, 2);
                        } else {
                            container.getDataManager().setDataF(JUMP_COUNT, v -> v + 1);
                        }
                        container.getDataManager().setDataSync(PROTECT_NEXT_FALL, Boolean.valueOf(true), (LocalPlayer)((LocalPlayerPatch)event.getPlayerPatch()).getOriginal());
                        Input input = event.getMovementInput();
                        float f = Mth.m_14036_((float)(0.3f + EnchantmentHelper.m_220302_((LivingEntity)((LivingEntity)container.getExecuter().getOriginal()))), (float)0.0f, (float)1.0f);
                        input.m_214106_(false, f);
                        int forward = event.getMovementInput().f_108568_ ? 1 : 0;
                        int backward = event.getMovementInput().f_108569_ ? -1 : 0;
                        int left = event.getMovementInput().f_108570_ ? 1 : 0;
                        int right = event.getMovementInput().f_108571_ ? -1 : 0;
                        int vertic = forward + backward;
                        int horizon = left + right;
                        int degree = -(90 * horizon * (1 - Math.abs(vertic)) + 45 * vertic * horizon);
                        int scale = forward == 0 && backward == 0 && left == 0 && right == 0 ? 0 : (vertic < 0 ? -1 : 1);
                        Vec3 forwardHorizontal = Vec3.m_82503_((Vec2)new Vec2(0.0f, ((Player)container.getExecuter().getOriginal()).m_5675_(1.0f)));
                        Vec3 jumpDir = OpenMatrix4f.transform(OpenMatrix4f.createRotatorDeg(-degree, Vec3f.Y_AXIS), forwardHorizontal.m_82490_(0.15 * (double)scale));
                        Vec3 deltaMove = ((Player)container.getExecuter().getOriginal()).m_20184_();
                        ((Player)container.getExecuter().getOriginal()).m_20334_(deltaMove.f_82479_ + jumpDir.f_82479_, 0.6 + ((Player)container.getExecuter().getOriginal()).m_182332_(), deltaMove.f_82481_ + jumpDir.f_82481_);
                        ((LocalPlayerPatch)event.getPlayerPatch()).playAnimationClientPreemptive(this.animations[vertic < 0 ? 1 : 0], 0.0f);
                        ((LocalPlayerPatch)event.getPlayerPatch()).changeModelYRot(degree);
                    }
                } else {
                    container.getDataManager().setData(JUMP_COUNT, 1);
                }
            }
            container.getDataManager().setData(JUMP_KEY_PRESSED_LAST_TIME, jumpPressed);
        });
        listener.addEventListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID, event -> {
            if (((DamageSource)event.getDamageSource()).m_146707_() && container.getDataManager().getDataValue(PROTECT_NEXT_FALL).booleanValue()) {
                float damage = event.getAmount();
                if (damage < 2.5f) {
                    event.setAmount(0.0f);
                    event.setCanceled(true);
                }
                container.getDataManager().setData(PROTECT_NEXT_FALL, false);
            }
        }, 1);
        listener.addEventListener(PlayerEventListener.EventType.FALL_EVENT, EVENT_UUID, event -> {
            container.getDataManager().setData(JUMP_COUNT, 0);
            if (((EntityPatch)event.getPlayerPatch()).isLogicalClient()) {
                container.getDataManager().setData(JUMP_KEY_PRESSED_LAST_TIME, false);
            }
        });
    }

    @Override
    public void onRemoved(SkillContainer container) {
        PlayerEventListener listener = container.getExecuter().getEventListener();
        listener.removeListener(PlayerEventListener.EventType.MOVEMENT_INPUT_EVENT, EVENT_UUID);
        listener.removeListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID);
        listener.removeListener(PlayerEventListener.EventType.FALL_EVENT, EVENT_UUID);
    }

    @Override
    public boolean canExecute(PlayerPatch<?> executer) {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgsOfScreen(List<Object> list) {
        list.add(this.extraJumps);
        return list;
    }
}

