/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.skill;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.client.CPModifySkillData;
import yesman.epicfight.network.server.SPAddOrRemoveSkillData;
import yesman.epicfight.network.server.SPModifySkillData;
import yesman.epicfight.skill.SkillContainer;

public class SkillDataManager {
    private final Map<SkillDataKey<?>, Data> data = Maps.newHashMap();
    private final int slotIndex;
    private final SkillContainer container;

    public SkillDataManager(int slotIndex, SkillContainer container) {
        this.slotIndex = slotIndex;
        this.container = container;
    }

    public <T> void registerData(SkillDataKey<T> key) {
        this.data.put(key, key.valueType.create());
        if (key.shouldSyncAllClients() && !this.container.getExecuter().isLogicalClient()) {
            Player owner = (Player)this.container.getExecuter().getOriginal();
            Object initialValue = key.valueType.get(this.data.get(key));
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(new SPAddOrRemoveSkillData(key, this.container.getSlot().universalOrdinal(), initialValue, SPAddOrRemoveSkillData.AddRemove.ADD, owner.m_19879_()), (Entity)owner);
        }
    }

    public <T> void removeData(SkillDataKey<T> key) {
        this.data.remove(key);
        if (key.shouldSyncAllClients() && !this.container.getExecuter().isLogicalClient()) {
            Player owner = (Player)this.container.getExecuter().getOriginal();
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(new SPAddOrRemoveSkillData(key, this.container.getSlot().universalOrdinal(), null, SPAddOrRemoveSkillData.AddRemove.REMOVE, owner.m_19879_()), (Entity)owner);
        }
    }

    public Set<SkillDataKey<?>> keySet() {
        return this.data.keySet();
    }

    @Deprecated
    public void setDataRawtype(SkillDataKey<?> key, Object data) {
        if (this.hasData(key)) {
            key.valueType.set(this.data.get(key), data);
        }
    }

    public <T> void setData(SkillDataKey<T> key, T data) {
        this.setDataRawtype(key, data);
    }

    public <T> void setDataF(SkillDataKey<T> key, Function<T, T> dataManipulator) {
        this.setDataRawtype(key, dataManipulator.apply(this.getDataValue(key)));
    }

    public <T> void setDataSync(SkillDataKey<T> key, T data, ServerPlayer player) {
        this.setData(key, data);
        this.syncData(key, player);
    }

    public <T> void setDataSyncF(SkillDataKey<T> key, Function<T, T> dataManipulator, ServerPlayer player) {
        this.setDataF(key, dataManipulator);
        SPModifySkillData msg = new SPModifySkillData(key, this.slotIndex, this.getDataValue(key), player.m_19879_());
        EpicFightNetworkManager.sendToPlayer(msg, player);
        if (key.shouldSyncAllClients()) {
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(msg, (Entity)player);
        }
    }

    public <T> void syncData(SkillDataKey<T> key, ServerPlayer player) {
        SPModifySkillData msg = new SPModifySkillData(key, this.slotIndex, this.getDataValue(key), player.m_19879_());
        EpicFightNetworkManager.sendToPlayer(msg, player);
        if (key.shouldSyncAllClients()) {
            EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity(msg, (Entity)player);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public <T> void syncData(SkillDataKey<T> key, LocalPlayer player) {
        CPModifySkillData msg = new CPModifySkillData(key, this.slotIndex, this.getDataValue(key));
        EpicFightNetworkManager.sendToServer(msg);
    }

    @OnlyIn(value=Dist.CLIENT)
    public <T> void setDataSync(SkillDataKey<T> key, T data, LocalPlayer player) {
        this.setData(key, data);
        this.syncData(key, player);
    }

    public <T> T getDataValue(SkillDataKey<T> key) {
        if (this.hasData(key)) {
            return key.valueType.get(this.data.get(key));
        }
        return null;
    }

    public boolean hasData(SkillDataKey<?> key) {
        return this.data.containsKey(key);
    }

    public void reset() {
        this.data.clear();
    }

    public static class SkillDataKey<T> {
        private static int NEXT_ID;
        private static final Map<Integer, SkillDataKey<?>> KEYS;
        private final ValueType<T> valueType;
        private final int id;
        private final boolean syncAllClients;

        public static <V> SkillDataKey<V> createDataKey(ValueType<V> valueType) {
            return SkillDataKey.createDataKey(valueType, false);
        }

        public static <V> SkillDataKey<V> createDataKey(ValueType<V> valueType, boolean syncAllClients) {
            int id = NEXT_ID++;
            SkillDataKey<V> key = new SkillDataKey<V>(valueType, id, syncAllClients);
            KEYS.put(id, key);
            return key;
        }

        public static SkillDataKey<?> findById(int id) {
            return KEYS.get(id);
        }

        private SkillDataKey(ValueType<T> valueType, int id, boolean syncAllClients) {
            this.valueType = valueType;
            this.id = id;
            this.syncAllClients = syncAllClients;
        }

        public int getId() {
            return this.id;
        }

        public ValueType<T> getValueType() {
            return this.valueType;
        }

        public boolean shouldSyncAllClients() {
            return this.syncAllClients;
        }

        static {
            KEYS = Maps.newHashMap();
        }
    }

    public static abstract class ValueType<T> {
        public static final IntegerType INTEGER = new IntegerType();
        public static final FloatType FLOAT = new FloatType();
        public static final BooleanType BOOLEAN = new BooleanType();

        public abstract Data create();

        public abstract void set(Data var1, Object var2);

        public abstract T get(Data var1);

        public abstract void writeToBuffer(FriendlyByteBuf var1, Object var2);

        public abstract T readFromBuffer(FriendlyByteBuf var1);

        private static class IntegerType
        extends ValueType<Integer> {
            private IntegerType() {
            }

            @Override
            public Data.IntegerData create() {
                return new Data.IntegerData();
            }

            @Override
            public void set(Data data, Object value) {
                ((Data.IntegerData)data).data = (Integer)value;
            }

            @Override
            public Integer get(Data data) {
                return data != null ? ((Data.IntegerData)data).data : 0;
            }

            @Override
            public void writeToBuffer(FriendlyByteBuf buf, Object data) {
                buf.writeInt(((Integer)data).intValue());
            }

            @Override
            public Integer readFromBuffer(FriendlyByteBuf buf) {
                return buf.readInt();
            }
        }

        private static class FloatType
        extends ValueType<Float> {
            private FloatType() {
            }

            @Override
            public Data.FloatData create() {
                return new Data.FloatData();
            }

            @Override
            public void set(Data data, Object value) {
                ((Data.FloatData)data).data = ((Float)value).floatValue();
            }

            @Override
            public Float get(Data data) {
                return Float.valueOf(data != null ? ((Data.FloatData)data).data : 0.0f);
            }

            @Override
            public void writeToBuffer(FriendlyByteBuf buf, Object data) {
                buf.writeFloat(((Float)data).floatValue());
            }

            @Override
            public Float readFromBuffer(FriendlyByteBuf buf) {
                return Float.valueOf(buf.readFloat());
            }
        }

        private static class BooleanType
        extends ValueType<Boolean> {
            private BooleanType() {
            }

            @Override
            public Data.BooleanData create() {
                return new Data.BooleanData();
            }

            @Override
            public void set(Data data, Object value) {
                ((Data.BooleanData)data).data = (Boolean)value;
            }

            @Override
            public Boolean get(Data data) {
                return data != null && ((Data.BooleanData)data).data;
            }

            @Override
            public void writeToBuffer(FriendlyByteBuf buf, Object data) {
                buf.writeBoolean(((Boolean)data).booleanValue());
            }

            @Override
            public Boolean readFromBuffer(FriendlyByteBuf buf) {
                return buf.readBoolean();
            }
        }
    }

    static abstract class Data {
        Data() {
        }

        static class FloatData
        extends Data {
            float data;

            FloatData() {
            }
        }

        static class BooleanData
        extends Data {
            boolean data;

            BooleanData() {
            }
        }

        static class IntegerData
        extends Data {
            int data;

            IntegerData() {
            }
        }
    }
}

