/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.network.server;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

public class SPAddOrRemoveSkillData {
    private AddRemove type;
    private Object value;
    private int slot;
    private int keyId;
    private int entityId;

    public SPAddOrRemoveSkillData() {
        this.type = null;
    }

    public SPAddOrRemoveSkillData(SkillDataManager.SkillDataKey<?> key, int slot, Object value, AddRemove type, int entityId) {
        this.keyId = key.getId();
        this.slot = slot;
        this.type = type;
        this.value = value;
        this.entityId = entityId;
    }

    public static SPAddOrRemoveSkillData fromBytes(FriendlyByteBuf buf) {
        int id = buf.readInt();
        int slot = buf.readInt();
        Object value = SkillDataManager.SkillDataKey.findById(id).getValueType().readFromBuffer(buf);
        return new SPAddOrRemoveSkillData(SkillDataManager.SkillDataKey.findById(id), slot, value, AddRemove.values()[buf.readInt()], buf.readInt());
    }

    public static void toBytes(SPAddOrRemoveSkillData msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.keyId);
        buf.writeInt(msg.slot);
        SkillDataManager.SkillDataKey.findById(msg.keyId).getValueType().writeToBuffer(buf, msg.value);
        buf.writeInt(msg.type.ordinal());
        buf.writeInt(msg.entityId);
    }

    public static void handle(SPAddOrRemoveSkillData msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Minecraft mc = Minecraft.m_91087_();
            Entity entity = mc.f_91073_.m_6815_(msg.entityId);
            Object patt1964$temp = entity.getCapability(EpicFightCapabilities.CAPABILITY_ENTITY).orElse(null);
            if (patt1964$temp instanceof PlayerPatch) {
                PlayerPatch playerpatch = (PlayerPatch)patt1964$temp;
                SkillDataManager dataManager = playerpatch.getSkill(msg.slot).getDataManager();
                SkillDataManager.SkillDataKey<?> dataKey = SkillDataManager.SkillDataKey.findById(msg.keyId);
                if (msg.type == AddRemove.ADD) {
                    dataManager.registerData(dataKey);
                    dataManager.setDataRawtype(dataKey, msg.value);
                } else {
                    dataManager.removeData(dataKey);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static enum AddRemove {
        ADD,
        REMOVE;

    }
}

