/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.client.world.capabilites.entitypatch.player;

import javax.annotation.Nonnull;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.Event;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.animation.ClientAnimator;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.client.forgeevent.RenderEpicFightPlayerEvent;
import yesman.epicfight.api.client.forgeevent.UpdatePlayerMotionEvent;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.RangedWeaponCapability;

@OnlyIn(value=Dist.CLIENT)
public class AbstractClientPlayerPatch<T extends AbstractClientPlayer>
extends PlayerPatch<T> {
    protected float prevYaw;
    protected float bodyYaw;
    public float prevBodyYaw;
    private Item prevHeldItem;
    private Item prevHeldItemOffHand;

    @Override
    public void onJoinWorld(T entityIn, EntityJoinLevelEvent event) {
        super.onJoinWorld(entityIn, event);
        this.prevHeldItem = Items.f_41852_;
        this.prevHeldItemOffHand = Items.f_41852_;
    }

    @Override
    public void updateMotion(boolean considerInaction) {
        if (((AbstractClientPlayer)this.original).m_21223_() <= 0.0f) {
            this.currentLivingMotion = LivingMotions.DEATH;
        } else if (!this.state.updateLivingMotion() && considerInaction) {
            this.currentLivingMotion = LivingMotions.INACTION;
        } else {
            ClientAnimator animator = this.getClientAnimator();
            if (((AbstractClientPlayer)this.original).m_21255_() || ((AbstractClientPlayer)this.original).m_21209_()) {
                this.currentLivingMotion = LivingMotions.FLY;
            } else if (((AbstractClientPlayer)this.original).m_20202_() != null) {
                this.currentLivingMotion = ((AbstractClientPlayer)this.original).m_20202_() instanceof PlayerRideableJumping ? LivingMotions.MOUNT : LivingMotions.SIT;
            } else if (((AbstractClientPlayer)this.original).m_6067_()) {
                this.currentLivingMotion = LivingMotions.SWIM;
            } else if (((AbstractClientPlayer)this.original).m_5803_()) {
                this.currentLivingMotion = LivingMotions.SLEEP;
            } else if (!((AbstractClientPlayer)this.original).m_20096_() && ((AbstractClientPlayer)this.original).m_6147_()) {
                this.currentLivingMotion = LivingMotions.CLIMB;
                double y = ((AbstractClientPlayer)this.original).f_36106_ - ((AbstractClientPlayer)this.original).f_36103_;
                if (Math.abs(y) < 0.04) {
                    animator.baseLayer.pause();
                } else {
                    animator.baseLayer.resume();
                    animator.baseLayer.animationPlayer.setReversed(y < 0.0);
                }
            } else if (!((AbstractClientPlayer)this.original).m_150110_().f_35935_) {
                if (((AbstractClientPlayer)this.original).m_5842_() && ((AbstractClientPlayer)this.original).f_36106_ - ((AbstractClientPlayer)this.original).f_36103_ < -0.005) {
                    this.currentLivingMotion = LivingMotions.FLOAT;
                } else if (((AbstractClientPlayer)this.original).f_36106_ - ((AbstractClientPlayer)this.original).f_36103_ < (double)-0.4f || this.isAirborneState()) {
                    this.currentLivingMotion = LivingMotions.FALL;
                } else if (this.isMoving()) {
                    this.currentLivingMotion = ((AbstractClientPlayer)this.original).m_6047_() ? LivingMotions.SNEAK : (((AbstractClientPlayer)this.original).m_20142_() ? LivingMotions.RUN : LivingMotions.WALK);
                    animator.baseLayer.animationPlayer.setReversed(((AbstractClientPlayer)this.original).f_20902_ < 0.0f);
                } else {
                    animator.baseLayer.animationPlayer.setReversed(false);
                    this.currentLivingMotion = ((AbstractClientPlayer)this.original).m_6047_() ? LivingMotions.KNEEL : LivingMotions.IDLE;
                }
            } else {
                this.currentLivingMotion = this.isMoving() ? LivingMotions.CREATIVE_FLY : LivingMotions.CREATIVE_IDLE;
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new UpdatePlayerMotionEvent.BaseLayer(this, this.currentLivingMotion));
        CapabilityItem activeItemCap = this.getHoldingItemCapability(((AbstractClientPlayer)this.original).m_7655_());
        if (((AbstractClientPlayer)this.original).m_6117_()) {
            UseAnim useAnim = ((AbstractClientPlayer)this.original).m_21211_().m_41780_();
            UseAnim capUseAnim = activeItemCap.getUseAnimation(this);
            this.currentCompositeMotion = useAnim == UseAnim.BLOCK || capUseAnim == UseAnim.BLOCK ? (activeItemCap.getWeaponCategory() == CapabilityItem.WeaponCategories.SHIELD ? LivingMotions.BLOCK_SHIELD : LivingMotions.BLOCK) : (useAnim == UseAnim.BOW || useAnim == UseAnim.SPEAR ? LivingMotions.AIM : (useAnim == UseAnim.CROSSBOW ? LivingMotions.RELOAD : (useAnim == UseAnim.DRINK ? LivingMotions.DRINK : (useAnim == UseAnim.EAT ? LivingMotions.EAT : (useAnim == UseAnim.SPYGLASS ? LivingMotions.SPECTATE : this.currentLivingMotion)))));
        } else {
            this.currentCompositeMotion = ((AbstractClientPlayer)this.original).m_21205_().m_41720_() instanceof ProjectileWeaponItem && CrossbowItem.m_40932_((ItemStack)((AbstractClientPlayer)this.original).m_21205_()) ? LivingMotions.AIM : (this.getClientAnimator().getCompositeLayer((Layer.Priority)Layer.Priority.MIDDLE).animationPlayer.getAnimation().isReboundAnimation() ? LivingMotions.NONE : (((AbstractClientPlayer)this.original).f_20911_ && ((AbstractClientPlayer)this.original).m_21257_().isEmpty() ? LivingMotions.DIGGING : this.currentLivingMotion));
            if (this.getClientAnimator().isAiming() && this.currentCompositeMotion != LivingMotions.AIM && activeItemCap instanceof RangedWeaponCapability) {
                this.playReboundAnimation();
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new UpdatePlayerMotionEvent.CompositeLayer(this, this.currentCompositeMotion));
    }

    @Override
    protected void clientTick(LivingEvent.LivingTickEvent event) {
        boolean isOffHandChanged;
        this.prevYaw = this.modelYRot;
        this.prevBodyYaw = this.bodyYaw;
        if (!this.getEntityState().updateLivingMotion()) {
            ((AbstractClientPlayer)this.original).f_20883_ = ((AbstractClientPlayer)this.original).m_146908_();
        }
        this.bodyYaw = ((AbstractClientPlayer)this.original).f_20883_;
        boolean isMainHandChanged = this.prevHeldItem != ((AbstractClientPlayer)this.original).m_150109_().m_36056_().m_41720_();
        boolean bl = isOffHandChanged = this.prevHeldItemOffHand != ((ItemStack)((AbstractClientPlayer)this.original).m_150109_().f_35976_.get(0)).m_41720_();
        if (isMainHandChanged || isOffHandChanged) {
            this.updateHeldItem(this.getHoldingItemCapability(InteractionHand.MAIN_HAND), this.getHoldingItemCapability(InteractionHand.OFF_HAND));
            if (isMainHandChanged) {
                this.prevHeldItem = ((AbstractClientPlayer)this.original).m_150109_().m_36056_().m_41720_();
            }
            if (isOffHandChanged) {
                this.prevHeldItemOffHand = ((ItemStack)((AbstractClientPlayer)this.original).m_150109_().f_35976_.get(0)).m_41720_();
            }
        }
        if (((AbstractClientPlayer)this.original).f_20919_ == 1) {
            this.getClientAnimator().playDeathAnimation();
        }
    }

    protected boolean isMoving() {
        return Math.abs(((AbstractClientPlayer)this.original).f_20900_) > 0.01f || Math.abs(((AbstractClientPlayer)this.original).f_20902_) > 0.01f;
    }

    public void updateHeldItem(CapabilityItem mainHandCap, CapabilityItem offHandCap) {
        this.cancelAnyAction();
    }

    @Override
    public void reserveAnimation(StaticAnimation animation) {
        this.animator.reserveAnimation(animation);
    }

    @Override
    public void playAnimationSynchronized(StaticAnimation animation, float convertTimeModifier, LivingEntityPatch.AnimationPacketProvider packetProvider) {
    }

    @Override
    public boolean overrideRender() {
        boolean originalShouldRender = this.isBattleMode() || EpicFightMod.CLIENT_INGAME_CONFIG.filterAnimation.getValue() == false;
        RenderEpicFightPlayerEvent renderepicfightplayerevent = new RenderEpicFightPlayerEvent(this, originalShouldRender);
        MinecraftForge.EVENT_BUS.post((Event)renderepicfightplayerevent);
        return renderepicfightplayerevent.getShouldRender();
    }

    @Override
    public boolean consumeStamina(float amount) {
        return true;
    }

    @Override
    public boolean shouldMoveOnCurrentSide(ActionAnimation actionAnimation) {
        return false;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public OpenMatrix4f getHeadMatrix(float partialTick) {
        float yaw = 0.0f;
        float pitch = 0.0f;
        float prvePitch = 0.0f;
        UseAnim useAnim = ((AbstractClientPlayer)this.original).m_21211_().m_41780_();
        if (!((AbstractClientPlayer)this.getOriginal()).m_6117_() || useAnim != UseAnim.DRINK && useAnim != UseAnim.EAT && useAnim != UseAnim.SPYGLASS) {
            if (this.getEntityState().inaction() || ((AbstractClientPlayer)this.original).m_20202_() != null && ((AbstractClientPlayer)this.original).m_20202_() instanceof LivingEntity || !((AbstractClientPlayer)this.original).m_20096_() && ((AbstractClientPlayer)this.original).m_6147_()) {
                yaw = 0.0f;
            } else {
                float f = MathUtils.lerpBetween(this.prevBodyYaw, this.bodyYaw, partialTick);
                float f1 = MathUtils.lerpBetween(((AbstractClientPlayer)this.original).f_20886_, ((AbstractClientPlayer)this.original).f_20885_, partialTick);
                yaw = f1 - f;
            }
            if (!((AbstractClientPlayer)this.original).m_21255_() && !((AbstractClientPlayer)this.original).m_6067_()) {
                prvePitch = ((AbstractClientPlayer)this.original).f_19860_;
                pitch = ((AbstractClientPlayer)this.original).m_146909_();
            }
        }
        return MathUtils.getModelMatrixIntegral(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, prvePitch, pitch, yaw, yaw, partialTick, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public OpenMatrix4f getModelMatrix(float partialTick) {
        float rotyaw;
        float prevRotYaw;
        if (((AbstractClientPlayer)this.original).m_21209_()) {
            OpenMatrix4f mat = MathUtils.getModelMatrixIntegral(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, partialTick, 0.9375f, 0.9375f, 0.9375f);
            float yawDegree = MathUtils.lerpBetween(((AbstractClientPlayer)this.original).f_19859_, ((AbstractClientPlayer)this.original).m_146908_(), partialTick);
            float pitchDegree = MathUtils.lerpBetween(((AbstractClientPlayer)this.original).f_19860_, ((AbstractClientPlayer)this.original).m_146909_(), partialTick);
            mat.rotateDeg(-yawDegree, Vec3f.Y_AXIS).rotateDeg(-pitchDegree, Vec3f.X_AXIS).rotateDeg(((float)((AbstractClientPlayer)this.original).f_19797_ + partialTick) * -55.0f, Vec3f.Z_AXIS).translate(0.0f, -0.39f, 0.0f);
            return mat;
        }
        if (((AbstractClientPlayer)this.original).m_21255_()) {
            OpenMatrix4f mat = MathUtils.getModelMatrixIntegral(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, partialTick, 0.9375f, 0.9375f, 0.9375f);
            float f1 = (float)((AbstractClientPlayer)this.original).m_21256_() + partialTick;
            float f2 = Mth.m_14036_((float)(f1 * f1 / 100.0f), (float)0.0f, (float)1.0f);
            mat.rotateDeg(-Mth.m_14189_((float)partialTick, (float)((AbstractClientPlayer)this.original).f_20884_, (float)((AbstractClientPlayer)this.original).f_20883_), Vec3f.Y_AXIS).rotateDeg(f2 * -((AbstractClientPlayer)this.original).m_146909_(), Vec3f.X_AXIS);
            Vec3 vec3d = ((AbstractClientPlayer)this.original).m_20252_(partialTick);
            Vec3 vec3d1 = ((AbstractClientPlayer)this.original).m_20184_();
            double d0 = vec3d1.m_165925_();
            double d1 = vec3d.m_165925_();
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (vec3d1.f_82479_ * vec3d.f_82479_ + vec3d1.f_82481_ * vec3d.f_82481_) / (Math.sqrt(d0) * Math.sqrt(d1));
                double d3 = vec3d1.f_82479_ * vec3d.f_82481_ - vec3d1.f_82481_ * vec3d.f_82479_;
                mat.rotate((float)(-(Math.signum(d3) * Math.acos(d2))), Vec3f.Z_AXIS);
            }
            return mat;
        }
        if (((AbstractClientPlayer)this.original).m_5803_()) {
            BlockState blockstate = ((AbstractClientPlayer)this.original).m_146900_();
            float yaw = 0.0f;
            if (blockstate.isBed((BlockGetter)((AbstractClientPlayer)this.original).f_19853_, (BlockPos)((AbstractClientPlayer)this.original).m_21257_().orElse(null), (LivingEntity)this.original) && blockstate.m_61138_((Property)BlockStateProperties.f_61374_)) {
                switch ((Direction)blockstate.m_61143_((Property)BlockStateProperties.f_61374_)) {
                    case EAST: {
                        yaw = 90.0f;
                        break;
                    }
                    case WEST: {
                        yaw = -90.0f;
                        break;
                    }
                    case SOUTH: {
                        yaw = 180.0f;
                        break;
                    }
                }
            }
            return MathUtils.getModelMatrixIntegral(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, yaw, yaw, 0.0f, 0.9375f, 0.9375f, 0.9375f);
        }
        Direction direction = this.getLadderDirection(((AbstractClientPlayer)this.original).m_146900_(), ((AbstractClientPlayer)this.original).f_19853_, ((AbstractClientPlayer)this.original).m_20183_(), (LivingEntity)this.original);
        if (direction != Direction.UP) {
            float yaw = 0.0f;
            switch (direction) {
                case EAST: {
                    yaw = 90.0f;
                    break;
                }
                case WEST: {
                    yaw = -90.0f;
                    break;
                }
                case SOUTH: {
                    yaw = 180.0f;
                    break;
                }
            }
            return MathUtils.getModelMatrixIntegral(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, yaw, yaw, 0.0f, 0.9375f, 0.9375f, 0.9375f);
        }
        float prevPitch = 0.0f;
        float pitch = 0.0f;
        Entity entity = ((AbstractClientPlayer)this.original).m_20202_();
        if (entity instanceof LivingEntity) {
            LivingEntity ridingEntity = (LivingEntity)entity;
            prevRotYaw = ridingEntity.f_20884_;
            rotyaw = ridingEntity.f_20883_;
        } else {
            float yaw = MathUtils.lerpBetween(this.prevYaw, this.modelYRot, partialTick);
            prevRotYaw = this.prevBodyYaw + yaw;
            rotyaw = this.bodyYaw + yaw;
        }
        if (!this.getEntityState().inaction() && ((AbstractClientPlayer)this.original).m_20089_() == Pose.SWIMMING) {
            float f4;
            float f = ((AbstractClientPlayer)this.original).m_20998_(partialTick);
            float f3 = ((AbstractClientPlayer)this.original).m_20069_() ? ((AbstractClientPlayer)this.original).m_146909_() : 0.0f;
            prevPitch = f4 = Mth.m_14179_((float)f, (float)0.0f, (float)f3);
            pitch = f4;
        }
        return MathUtils.getModelMatrixIntegral(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, prevPitch, pitch, prevRotYaw, rotyaw, partialTick, 0.9375f, 0.9375f, 0.9375f);
    }

    public void setYaw(float bodyYaw) {
        this.bodyYaw = bodyYaw;
    }

    public float getBodyYaw() {
        return this.bodyYaw;
    }

    public Direction getLadderDirection(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull LivingEntity entity) {
        boolean isSpectator;
        boolean bl = isSpectator = entity instanceof Player && entity.m_5833_();
        if (isSpectator || ((AbstractClientPlayer)this.original).m_20096_() || !((AbstractClientPlayer)this.original).m_6084_()) {
            return Direction.UP;
        }
        if (((Boolean)ForgeConfig.SERVER.fullBoundingBoxLadders.get()).booleanValue()) {
            if (state.isLadder((LevelReader)world, pos, entity)) {
                if (state.m_61138_((Property)BlockStateProperties.f_61374_)) {
                    return (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
                }
                if (state.m_61138_((Property)BlockStateProperties.f_61366_) && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61366_)).booleanValue()) {
                    return Direction.UP;
                }
                if (state.m_61138_((Property)BlockStateProperties.f_61368_) && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61368_)).booleanValue()) {
                    return Direction.SOUTH;
                }
                if (state.m_61138_((Property)BlockStateProperties.f_61371_) && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61371_)).booleanValue()) {
                    return Direction.EAST;
                }
                if (state.m_61138_((Property)BlockStateProperties.f_61370_) && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61370_)).booleanValue()) {
                    return Direction.NORTH;
                }
                if (state.m_61138_((Property)BlockStateProperties.f_61369_) && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61369_)).booleanValue()) {
                    return Direction.WEST;
                }
            }
        } else {
            AABB bb = entity.m_20191_();
            int mX = Mth.m_14107_((double)bb.f_82288_);
            int mY = Mth.m_14107_((double)bb.f_82289_);
            int mZ = Mth.m_14107_((double)bb.f_82290_);
            int y2 = mY;
            while ((double)y2 < bb.f_82292_) {
                int x2 = mX;
                while ((double)x2 < bb.f_82291_) {
                    int z2 = mZ;
                    while ((double)z2 < bb.f_82293_) {
                        BlockPos tmp = new BlockPos(x2, y2, z2);
                        state = world.m_8055_(tmp);
                        if (state.isLadder((LevelReader)world, tmp, entity)) {
                            if (state.m_61138_((Property)BlockStateProperties.f_61374_)) {
                                return (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
                            }
                            if (state.m_61138_((Property)BlockStateProperties.f_61366_) && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61366_)).booleanValue()) {
                                return Direction.UP;
                            }
                            if (state.m_61138_((Property)BlockStateProperties.f_61368_) && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61368_)).booleanValue()) {
                                return Direction.SOUTH;
                            }
                            if (state.m_61138_((Property)BlockStateProperties.f_61371_) && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61371_)).booleanValue()) {
                                return Direction.EAST;
                            }
                            if (state.m_61138_((Property)BlockStateProperties.f_61370_) && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61370_)).booleanValue()) {
                                return Direction.NORTH;
                            }
                            if (state.m_61138_((Property)BlockStateProperties.f_61369_) && ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61369_)).booleanValue()) {
                                return Direction.WEST;
                            }
                        }
                        ++z2;
                    }
                    ++x2;
                }
                ++y2;
            }
        }
        return Direction.UP;
    }
}

