/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.collider;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.collider.LineCollider;
import yesman.epicfight.api.collider.MultiCollider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class MultiLineCollider
extends MultiCollider<LineCollider> {
    public MultiLineCollider(int arrayLength, double posX, double posY, double posZ, double vecX, double vecY, double vecZ) {
        super(arrayLength, posX, posY, posZ, LineCollider.getInitialAABB(posX, posY, posZ, vecX, vecY, vecZ));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void draw(PoseStack matrixStackIn, MultiBufferSource buffer, LivingEntityPatch<?> entitypatch, AttackAnimation animation, Joint joint, float prevElapsedTime, float elapsedTime, float partialTicks, float attackSpeed) {
        float partialScale;
        int numberOf = Math.max(Math.round((float)this.numberOfColliders * attackSpeed), 1);
        float interpolation = partialScale = 1.0f / (float)numberOf;
        Armature armature = entitypatch.getArmature();
        int pathIndex = armature.searchPathIndex(joint.getName());
        boolean red = entitypatch.getEntityState().attacking();
        ArrayList colliders = Lists.newArrayList();
        for (int i = 0; i < numberOf; ++i) {
            colliders.add(((LineCollider)this.colliders.get(i)).deepCopy());
        }
        for (LineCollider lineCollider : colliders) {
            matrixStackIn.m_85836_();
            OpenMatrix4f mat = null;
            float partialTime = Mth.m_14179_((float)interpolation, (float)prevElapsedTime, (float)elapsedTime);
            mat = pathIndex == -1 ? new OpenMatrix4f() : armature.getBindedTransformByJointIndex(animation.getPoseByTime(entitypatch, partialTime, 0.0f), pathIndex);
            lineCollider.drawInternal(matrixStackIn, buffer, mat, red);
            interpolation += partialScale;
            matrixStackIn.m_85849_();
        }
    }
}

