/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.client.model.armor;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.geo.render.built.GeoBone;
import software.bernie.geckolib3.geo.render.built.GeoCube;
import software.bernie.geckolib3.geo.render.built.GeoQuad;
import software.bernie.geckolib3.geo.render.built.GeoVertex;
import software.bernie.geckolib3.renderers.geo.GeoArmorRenderer;
import software.bernie.geckolib3.util.RenderUtils;
import yesman.epicfight.api.client.model.AnimatedMesh;
import yesman.epicfight.api.client.model.Mesh;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.api.client.model.SingleVertex;
import yesman.epicfight.api.client.model.armor.ArmorModelTransformer;
import yesman.epicfight.api.utils.math.Vec2f;
import yesman.epicfight.api.utils.math.Vec3f;

@OnlyIn(value=Dist.CLIENT)
public class GeoArmor
extends ArmorModelTransformer {
    static final ArmorModelTransformer.PartTransformer<GeoCube> HEAD = new SimpleTransformer(9);
    static final ArmorModelTransformer.PartTransformer<GeoCube> LEFT_FEET = new SimpleTransformer(5);
    static final ArmorModelTransformer.PartTransformer<GeoCube> RIGHT_FEET = new SimpleTransformer(2);
    static final ArmorModelTransformer.PartTransformer<GeoCube> LEFT_ARM = new LimbPartTransformer(16, 17, 19, 1.125f, false, AABB.m_165882_((Vec3)new Vec3(-0.375, 1.125, 0.0), (double)0.5, (double)0.85, (double)0.5));
    static final ArmorModelTransformer.PartTransformer<GeoCube> RIGHT_ARM = new LimbPartTransformer(11, 12, 14, 1.125f, false, AABB.m_165882_((Vec3)new Vec3(0.375, 1.125, 0.0), (double)0.5, (double)0.85, (double)0.5));
    static final ArmorModelTransformer.PartTransformer<GeoCube> LEFT_LEG = new LimbPartTransformer(4, 5, 6, 0.375f, true, AABB.m_165882_((Vec3)new Vec3(-0.15, 0.375, 0.0), (double)0.5, (double)0.85, (double)0.5));
    static final ArmorModelTransformer.PartTransformer<GeoCube> RIGHT_LEG = new LimbPartTransformer(1, 2, 3, 0.375f, true, AABB.m_165882_((Vec3)new Vec3(0.15, 0.375, 0.0), (double)0.5, (double)0.85, (double)0.5));
    static final ArmorModelTransformer.PartTransformer<GeoCube> CHEST = new ChestPartTransformer(8, 7, 1.125f, AABB.m_165882_((Vec3)new Vec3(0.0, 1.125, 0.0), (double)0.9, (double)0.85, (double)0.45));
    static int indexCount = 0;

    @Override
    public AnimatedMesh transformModel(HumanoidModel<?> model, ArmorItem armorItem, EquipmentSlot slot, boolean debuggingMode) {
        if (!(armorItem instanceof IAnimatable) || !(model instanceof GeoArmorRenderer)) {
            return null;
        }
        GeoArmorRenderer geoModel = (GeoArmorRenderer)model;
        ArrayList boxes = Lists.newArrayList();
        IBone headBone = geoModel.getGeoModelProvider().getBone(geoModel.headBone);
        IBone bodyBone = geoModel.getGeoModelProvider().getBone(geoModel.bodyBone);
        IBone rightArmBone = geoModel.getGeoModelProvider().getBone(geoModel.rightArmBone);
        IBone leftArmBone = geoModel.getGeoModelProvider().getBone(geoModel.leftArmBone);
        IBone rightLegBone = geoModel.getGeoModelProvider().getBone(geoModel.rightLegBone);
        IBone leftLegBone = geoModel.getGeoModelProvider().getBone(geoModel.leftLegBone);
        IBone rightBootBone = geoModel.getGeoModelProvider().getBone(geoModel.rightBootBone);
        IBone leftBootBone = geoModel.getGeoModelProvider().getBone(geoModel.leftBootBone);
        headBone.setRotationX(0.0f);
        headBone.setRotationY(0.0f);
        headBone.setRotationZ(0.0f);
        bodyBone.setRotationX(0.0f);
        bodyBone.setRotationY(0.0f);
        bodyBone.setRotationZ(0.0f);
        rightArmBone.setRotationX(0.0f);
        rightArmBone.setRotationY(0.0f);
        rightArmBone.setRotationZ(0.0f);
        leftArmBone.setRotationX(0.0f);
        leftArmBone.setRotationY(0.0f);
        leftArmBone.setRotationZ(0.0f);
        rightLegBone.setRotationX(0.0f);
        rightLegBone.setRotationY(0.0f);
        rightLegBone.setRotationZ(0.0f);
        leftLegBone.setRotationX(0.0f);
        leftLegBone.setRotationY(0.0f);
        leftLegBone.setRotationZ(0.0f);
        rightBootBone.setRotationX(0.0f);
        rightBootBone.setRotationY(0.0f);
        rightBootBone.setRotationZ(0.0f);
        leftBootBone.setRotationX(0.0f);
        leftBootBone.setRotationY(0.0f);
        leftBootBone.setRotationZ(0.0f);
        switch (slot) {
            case HEAD: {
                boxes.add(new GeoModelPartition(HEAD, headBone));
                break;
            }
            case CHEST: {
                boxes.add(new GeoModelPartition(CHEST, bodyBone));
                boxes.add(new GeoModelPartition(RIGHT_ARM, rightArmBone));
                boxes.add(new GeoModelPartition(LEFT_ARM, leftArmBone));
                break;
            }
            case LEGS: {
                boxes.add(new GeoModelPartition(CHEST, bodyBone));
                boxes.add(new GeoModelPartition(LEFT_LEG, leftLegBone));
                boxes.add(new GeoModelPartition(RIGHT_LEG, rightLegBone));
                break;
            }
            case FEET: {
                boxes.add(new GeoModelPartition(LEFT_FEET, leftBootBone));
                boxes.add(new GeoModelPartition(RIGHT_FEET, rightBootBone));
                break;
            }
            default: {
                return null;
            }
        }
        Mesh.RenderProperties.Builder propertyBuilder = Mesh.RenderProperties.builder();
        propertyBuilder.customTexturePath(geoModel.getTextureLocation((ArmorItem)((IAnimatable)armorItem)).toString());
        ResourceLocation rl = new ResourceLocation(ForgeRegistries.ITEMS.getKey((Object)armorItem).m_135827_(), "armor/" + ForgeRegistries.ITEMS.getKey((Object)armorItem).m_135815_());
        AnimatedMesh armorModelMesh = GeoArmor.bakeMeshFromCubes(boxes, propertyBuilder, debuggingMode);
        Meshes.addMesh(rl, armorModelMesh);
        return armorModelMesh;
    }

    private static AnimatedMesh bakeMeshFromCubes(List<GeoModelPartition> partitions, Mesh.RenderProperties.Builder propertyBuilder, boolean debuggingMode) {
        ArrayList vertices = Lists.newArrayList();
        HashMap indices = Maps.newHashMap();
        PoseStack poseStack = new PoseStack();
        indexCount = 0;
        for (GeoModelPartition modelpartition : partitions) {
            IBone iBone = modelpartition.geoBone;
            if (!(iBone instanceof GeoBone)) continue;
            GeoBone geoBone = (GeoBone)iBone;
            GeoArmor.bake(poseStack, modelpartition, geoBone, vertices, indices, debuggingMode);
        }
        return SingleVertex.loadVertexInformationWithRenderProperty(vertices, indices, propertyBuilder);
    }

    private static void bake(PoseStack poseStack, GeoModelPartition modelpartition, GeoBone geoBone, List<SingleVertex> vertices, Map<String, List<Integer>> indices, boolean debuggingMode) {
        if (geoBone == null) {
            return;
        }
        if (!geoBone.isHidden()) {
            poseStack.m_85836_();
            RenderUtils.prepMatrixForBone((PoseStack)poseStack, (GeoBone)geoBone);
            for (GeoCube cube : geoBone.childCubes) {
                poseStack.m_85836_();
                RenderUtils.translateToPivotPoint((PoseStack)poseStack, (GeoCube)cube);
                RenderUtils.rotateMatrixAroundCube((PoseStack)poseStack, (GeoCube)cube);
                RenderUtils.translateAwayFromPivotPoint((PoseStack)poseStack, (GeoCube)cube);
                modelpartition.partTransformer.bakeCube(poseStack, geoBone.name, cube, vertices, indices);
                poseStack.m_85849_();
            }
            poseStack.m_85849_();
        }
        if (!geoBone.childBonesAreHiddenToo()) {
            for (GeoBone childBone : geoBone.childBones) {
                GeoArmor.bake(poseStack, modelpartition, childBone, vertices, indices, debuggingMode);
            }
        }
    }

    static Direction getDirectionFromVector(Vector3f directionVec) {
        for (Direction direction : Direction.values()) {
            Vector3f direcVec = new Vector3f(Float.compare(directionVec.m_122239_(), -0.0f) == 0 ? 0.0f : directionVec.m_122239_(), directionVec.m_122260_(), directionVec.m_122269_());
            if (!direcVec.equals((Object)direction.m_122432_())) continue;
            return direction;
        }
        return null;
    }

    static Vec3 getCenterOfCube(PoseStack poseStack, GeoCube cube) {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double minZ = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double maxY = Double.MIN_VALUE;
        double maxZ = Double.MIN_VALUE;
        Matrix4f matrix = poseStack.m_85850_().m_85861_();
        for (GeoQuad quad : cube.quads) {
            for (GeoVertex v : quad.vertices) {
                Vector4f translatedPosition = new Vector4f(v.position);
                translatedPosition.m_123607_(matrix);
                if (minX > (double)translatedPosition.m_123601_()) {
                    minX = translatedPosition.m_123601_();
                }
                if (minY > (double)translatedPosition.m_123615_()) {
                    minY = translatedPosition.m_123615_();
                }
                if (minZ > (double)translatedPosition.m_123616_()) {
                    minZ = translatedPosition.m_123616_();
                }
                if (maxX < (double)translatedPosition.m_123601_()) {
                    maxX = translatedPosition.m_123601_();
                }
                if (maxY < (double)translatedPosition.m_123615_()) {
                    maxY = translatedPosition.m_123615_();
                }
                if (!(maxZ < (double)translatedPosition.m_123616_())) continue;
                maxZ = translatedPosition.m_123616_();
            }
        }
        return new Vec3(minX + (maxX - minX) * 0.5, minY + (maxY - minY) * 0.5, minZ + (maxZ - minZ) * 0.5);
    }

    static Vector3f getClipPoint(Vector3f pos1, Vector3f pos2, float yClip) {
        Vector3f direct = pos2.m_122281_();
        direct.m_122267_(pos1);
        direct.m_122261_((yClip - pos1.m_122260_()) / (pos2.m_122260_() - pos1.m_122260_()));
        Vector3f clipPoint = pos1.m_122281_();
        clipPoint.m_122253_(direct);
        return clipPoint;
    }

    static ModelPart.Vertex getTranslatedVertex(GeoVertex original, Matrix4f matrix) {
        Vector4f translatedPosition = new Vector4f(original.position);
        translatedPosition.m_123607_(matrix);
        return new ModelPart.Vertex(translatedPosition.m_123601_(), translatedPosition.m_123615_(), translatedPosition.m_123616_(), original.textureU, original.textureV);
    }

    static class GeoModelPartition {
        final ArmorModelTransformer.PartTransformer<GeoCube> partTransformer;
        final IBone geoBone;

        private GeoModelPartition(ArmorModelTransformer.PartTransformer<GeoCube> partTransformer, IBone geoBone) {
            this.partTransformer = partTransformer;
            this.geoBone = geoBone;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class SimpleTransformer
    extends ArmorModelTransformer.PartTransformer<GeoCube> {
        final int jointId;

        public SimpleTransformer(int jointId) {
            this.jointId = jointId;
        }

        @Override
        public void bakeCube(PoseStack poseStack, String partName, GeoCube cube, List<SingleVertex> vertices, Map<String, List<Integer>> indices) {
            for (GeoQuad quad : cube.quads) {
                if (quad == null) continue;
                Vector3f norm = quad.normal.m_122281_();
                norm.m_122249_(poseStack.m_85850_().m_85864_());
                for (GeoVertex vertex : quad.vertices) {
                    Vector4f pos = new Vector4f(vertex.position);
                    pos.m_123607_(poseStack.m_85850_().m_85861_());
                    vertices.add(new SingleVertex().setPosition(new Vec3f(pos.m_123601_(), pos.m_123615_(), pos.m_123616_())).setNormal(new Vec3f(norm.m_122239_(), norm.m_122260_(), norm.m_122269_())).setTextureCoordinate(new Vec2f(vertex.textureU, vertex.textureV)).setEffectiveJointIDs(new Vec3f(this.jointId, 0.0f, 0.0f)).setEffectiveJointWeights(new Vec3f(1.0f, 0.0f, 0.0f)).setEffectiveJointNumber(1));
                }
                this.putIndexCount(indices, partName, indexCount);
                this.putIndexCount(indices, partName, indexCount + 1);
                this.putIndexCount(indices, partName, indexCount + 3);
                this.putIndexCount(indices, partName, indexCount + 3);
                this.putIndexCount(indices, partName, indexCount + 1);
                this.putIndexCount(indices, partName, indexCount + 2);
                indexCount += 4;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class LimbPartTransformer
    extends ArmorModelTransformer.PartTransformer<GeoCube> {
        final int upperJoint;
        final int lowerJoint;
        final int middleJoint;
        final boolean bendInFront;
        final SimpleTransformer upperAttachmentTransformer;
        final SimpleTransformer lowerAttachmentTransformer;
        final AABB noneAttachmentArea;
        final float yClipCoord;

        public LimbPartTransformer(int upperJoint, int lowerJoint, int middleJoint, float yClipCoord, boolean bendInFront, AABB noneAttachmentArea) {
            this.upperJoint = upperJoint;
            this.lowerJoint = lowerJoint;
            this.middleJoint = middleJoint;
            this.bendInFront = bendInFront;
            this.upperAttachmentTransformer = new SimpleTransformer(upperJoint);
            this.lowerAttachmentTransformer = new SimpleTransformer(lowerJoint);
            this.noneAttachmentArea = noneAttachmentArea;
            this.yClipCoord = yClipCoord;
        }

        @Override
        public void bakeCube(PoseStack poseStack, String partName, GeoCube cube, List<SingleVertex> vertices, Map<String, List<Integer>> indices) {
            Vec3 centerOfCube = GeoArmor.getCenterOfCube(poseStack, cube);
            if (!this.noneAttachmentArea.m_82390_(centerOfCube)) {
                if (centerOfCube.f_82480_ < (double)this.yClipCoord) {
                    this.lowerAttachmentTransformer.bakeCube(poseStack, partName, cube, vertices, indices);
                } else {
                    this.upperAttachmentTransformer.bakeCube(poseStack, partName, cube, vertices, indices);
                }
                return;
            }
            ArrayList polygons = Lists.newArrayList();
            for (GeoQuad quad : cube.quads) {
                Matrix4f matrix = poseStack.m_85850_().m_85861_();
                ModelPart.Vertex pos0 = GeoArmor.getTranslatedVertex(quad.vertices[0], matrix);
                ModelPart.Vertex pos1 = GeoArmor.getTranslatedVertex(quad.vertices[1], matrix);
                ModelPart.Vertex pos2 = GeoArmor.getTranslatedVertex(quad.vertices[2], matrix);
                ModelPart.Vertex pos3 = GeoArmor.getTranslatedVertex(quad.vertices[3], matrix);
                Direction direction = GeoArmor.getDirectionFromVector(quad.normal);
                if (pos1.f_104371_.m_122260_() > this.yClipCoord != pos2.f_104371_.m_122260_() > this.yClipCoord) {
                    boolean isFront;
                    boolean hasSameZ;
                    int lowerId;
                    int upperId;
                    float distance = pos2.f_104371_.m_122260_() - pos1.f_104371_.m_122260_();
                    float textureV = pos1.f_104373_ + (pos2.f_104373_ - pos1.f_104373_) * ((this.yClipCoord - pos1.f_104371_.m_122260_()) / distance);
                    Vector3f clipPos1 = GeoArmor.getClipPoint(pos1.f_104371_, pos2.f_104371_, this.yClipCoord);
                    Vector3f clipPos2 = GeoArmor.getClipPoint(pos0.f_104371_, pos3.f_104371_, this.yClipCoord);
                    ModelPart.Vertex pos4 = new ModelPart.Vertex(clipPos2, pos0.f_104372_, textureV);
                    ModelPart.Vertex pos5 = new ModelPart.Vertex(clipPos1, pos1.f_104372_, textureV);
                    if (distance > 0.0f) {
                        upperId = this.lowerJoint;
                        lowerId = this.upperJoint;
                    } else {
                        upperId = this.upperJoint;
                        lowerId = this.lowerJoint;
                    }
                    polygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(pos0, upperId), new AnimatedVertex(pos1, upperId), new AnimatedVertex(pos5, upperId), new AnimatedVertex(pos4, upperId)}, direction));
                    polygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(pos4, lowerId), new AnimatedVertex(pos5, lowerId), new AnimatedVertex(pos2, lowerId), new AnimatedVertex(pos3, lowerId)}, direction));
                    boolean bl = hasSameZ = pos4.f_104371_.m_122269_() < 0.0f == pos5.f_104371_.m_122269_() < 0.0f;
                    boolean bl2 = hasSameZ && pos4.f_104371_.m_122269_() < 0.0f == this.bendInFront ? true : (isFront = false);
                    if (isFront) {
                        polygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(pos4, this.middleJoint), new AnimatedVertex(pos5, this.middleJoint), new AnimatedVertex(pos5, this.upperJoint), new AnimatedVertex(pos4, this.upperJoint)}, 0.001f, direction));
                        polygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(pos4, this.lowerJoint), new AnimatedVertex(pos5, this.lowerJoint), new AnimatedVertex(pos5, this.middleJoint), new AnimatedVertex(pos4, this.middleJoint)}, 0.001f, direction));
                        continue;
                    }
                    if (hasSameZ) continue;
                    boolean startFront = pos4.f_104371_.m_122269_() > 0.0f;
                    int firstJoint = this.lowerJoint;
                    int secondJoint = this.lowerJoint;
                    int thirdJoint = startFront ? this.upperJoint : this.middleJoint;
                    int fourthJoint = startFront ? this.middleJoint : this.upperJoint;
                    int fifthJoint = this.upperJoint;
                    int sixthJoint = this.upperJoint;
                    polygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(pos4, firstJoint), new AnimatedVertex(pos5, secondJoint), new AnimatedVertex(pos5, thirdJoint), new AnimatedVertex(pos4, fourthJoint)}, 0.001f, direction));
                    polygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(pos4, fourthJoint), new AnimatedVertex(pos5, thirdJoint), new AnimatedVertex(pos5, fifthJoint), new AnimatedVertex(pos4, sixthJoint)}, 0.001f, direction));
                    continue;
                }
                int jointId = pos0.f_104371_.m_122260_() > this.yClipCoord ? this.upperJoint : this.lowerJoint;
                polygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(pos0, jointId), new AnimatedVertex(pos1, jointId), new AnimatedVertex(pos2, jointId), new AnimatedVertex(pos3, jointId)}, direction));
            }
            for (AnimatedPolygon quad : polygons) {
                Vector3f norm = quad.normal.m_122281_();
                norm.m_122249_(poseStack.m_85850_().m_85864_());
                for (AnimatedVertex vertex : quad.animatedVertexPositions) {
                    Vector4f pos = new Vector4f(vertex.f_104371_);
                    vertices.add(new SingleVertex().setPosition(new Vec3f(pos.m_123601_(), pos.m_123615_(), pos.m_123616_())).setNormal(new Vec3f(norm.m_122239_(), norm.m_122260_(), norm.m_122269_())).setTextureCoordinate(new Vec2f(vertex.f_104372_, vertex.f_104373_)).setEffectiveJointIDs(new Vec3f(vertex.jointId.m_123341_(), 0.0f, 0.0f)).setEffectiveJointWeights(new Vec3f(1.0f, 0.0f, 0.0f)).setEffectiveJointNumber(1));
                }
                this.putIndexCount(indices, partName, indexCount);
                this.putIndexCount(indices, partName, indexCount + 1);
                this.putIndexCount(indices, partName, indexCount + 3);
                this.putIndexCount(indices, partName, indexCount + 3);
                this.putIndexCount(indices, partName, indexCount + 1);
                this.putIndexCount(indices, partName, indexCount + 2);
                indexCount += 4;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class ChestPartTransformer
    extends ArmorModelTransformer.PartTransformer<GeoCube> {
        static final float X_PLANE = 0.0f;
        static final VertexWeight[] WEIGHT_ALONG_Y = new VertexWeight[]{new VertexWeight(13.6666f, 0.23f, 0.77f), new VertexWeight(15.8333f, 0.254f, 0.746f), new VertexWeight(18.0f, 0.5f, 0.5f), new VertexWeight(20.1666f, 0.744f, 0.256f), new VertexWeight(22.3333f, 0.77f, 0.23f)};
        final SimpleTransformer upperAttachmentTransformer;
        final SimpleTransformer lowerAttachmentTransformer;
        final AABB noneAttachmentArea;
        final float yClipCoord;

        public ChestPartTransformer(int upperJoint, int lowerJoint, float yBasis, AABB noneAttachmentArea) {
            this.noneAttachmentArea = noneAttachmentArea;
            this.upperAttachmentTransformer = new SimpleTransformer(upperJoint);
            this.lowerAttachmentTransformer = new SimpleTransformer(lowerJoint);
            this.yClipCoord = yBasis;
        }

        @Override
        public void bakeCube(PoseStack poseStack, String partName, GeoCube cube, List<SingleVertex> vertices, Map<String, List<Integer>> indices) {
            ModelPart.Vertex pos5;
            ModelPart.Vertex pos4;
            Vec3 centerOfCube = GeoArmor.getCenterOfCube(poseStack, cube);
            if (!this.noneAttachmentArea.m_82390_(centerOfCube)) {
                if (centerOfCube.f_82480_ < (double)this.yClipCoord) {
                    this.lowerAttachmentTransformer.bakeCube(poseStack, partName, cube, vertices, indices);
                } else {
                    this.upperAttachmentTransformer.bakeCube(poseStack, partName, cube, vertices, indices);
                }
                return;
            }
            ArrayList xClipPolygons = Lists.newArrayList();
            ArrayList xyClipPolygons = Lists.newArrayList();
            for (GeoQuad polygon : cube.quads) {
                Matrix4f matrix = poseStack.m_85850_().m_85861_();
                ModelPart.Vertex pos0 = GeoArmor.getTranslatedVertex(polygon.vertices[0], matrix);
                ModelPart.Vertex pos1 = GeoArmor.getTranslatedVertex(polygon.vertices[1], matrix);
                ModelPart.Vertex pos2 = GeoArmor.getTranslatedVertex(polygon.vertices[2], matrix);
                ModelPart.Vertex pos3 = GeoArmor.getTranslatedVertex(polygon.vertices[3], matrix);
                Direction direction = GeoArmor.getDirectionFromVector(polygon.normal);
                VertexWeight pos0Weight = ChestPartTransformer.getYClipWeight(pos0.f_104371_.m_122260_());
                VertexWeight pos1Weight = ChestPartTransformer.getYClipWeight(pos1.f_104371_.m_122260_());
                VertexWeight pos2Weight = ChestPartTransformer.getYClipWeight(pos2.f_104371_.m_122260_());
                VertexWeight pos3Weight = ChestPartTransformer.getYClipWeight(pos3.f_104371_.m_122260_());
                if (pos1.f_104371_.m_122239_() > 0.0f != pos2.f_104371_.m_122239_() > 0.0f) {
                    float distance = pos2.f_104371_.m_122239_() - pos1.f_104371_.m_122239_();
                    float textureU = pos1.f_104372_ + (pos2.f_104372_ - pos1.f_104372_) * ((0.0f - pos1.f_104371_.m_122239_()) / distance);
                    pos4 = new ModelPart.Vertex(0.0f, pos0.f_104371_.m_122260_(), pos0.f_104371_.m_122269_(), textureU, pos0.f_104373_);
                    pos5 = new ModelPart.Vertex(0.0f, pos1.f_104371_.m_122260_(), pos1.f_104371_.m_122269_(), textureU, pos1.f_104373_);
                    xClipPolygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(pos0, 8, 7, 0, pos0Weight.chestWeight, pos0Weight.torsoWeight, 0.0f), new AnimatedVertex(pos4, 8, 7, 0, pos0Weight.chestWeight, pos0Weight.torsoWeight, 0.0f), new AnimatedVertex(pos5, 8, 7, 0, pos1Weight.chestWeight, pos1Weight.torsoWeight, 0.0f), new AnimatedVertex(pos3, 8, 7, 0, pos3Weight.chestWeight, pos3Weight.torsoWeight, 0.0f)}, direction));
                    xClipPolygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(pos4, 8, 7, 0, pos0Weight.chestWeight, pos0Weight.torsoWeight, 0.0f), new AnimatedVertex(pos1, 8, 7, 0, pos1Weight.chestWeight, pos1Weight.torsoWeight, 0.0f), new AnimatedVertex(pos2, 8, 7, 0, pos2Weight.chestWeight, pos2Weight.torsoWeight, 0.0f), new AnimatedVertex(pos5, 8, 7, 0, pos1Weight.chestWeight, pos1Weight.torsoWeight, 0.0f)}, direction));
                    continue;
                }
                xClipPolygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(pos0, 8, 7, 0, pos0Weight.chestWeight, pos0Weight.torsoWeight, 0.0f), new AnimatedVertex(pos1, 8, 7, 0, pos1Weight.chestWeight, pos1Weight.torsoWeight, 0.0f), new AnimatedVertex(pos2, 8, 7, 0, pos2Weight.chestWeight, pos2Weight.torsoWeight, 0.0f), new AnimatedVertex(pos3, 8, 7, 0, pos3Weight.chestWeight, pos3Weight.torsoWeight, 0.0f)}, direction));
            }
            for (AnimatedPolygon polygon : xClipPolygons) {
                boolean upsideDown = polygon.animatedVertexPositions[1].f_104371_.m_122260_() > polygon.animatedVertexPositions[2].f_104371_.m_122260_();
                AnimatedVertex pos0 = upsideDown ? polygon.animatedVertexPositions[2] : polygon.animatedVertexPositions[0];
                AnimatedVertex pos1 = upsideDown ? polygon.animatedVertexPositions[3] : polygon.animatedVertexPositions[1];
                AnimatedVertex pos2 = upsideDown ? polygon.animatedVertexPositions[0] : polygon.animatedVertexPositions[2];
                AnimatedVertex pos3 = upsideDown ? polygon.animatedVertexPositions[1] : polygon.animatedVertexPositions[3];
                Direction direction = GeoArmor.getDirectionFromVector(polygon.normal);
                List<VertexWeight> vertexWeights = ChestPartTransformer.getMiddleYClipWeights(pos1.f_104371_.m_122260_(), pos2.f_104371_.m_122260_());
                ArrayList animatedVertices = Lists.newArrayList();
                animatedVertices.add(pos0);
                animatedVertices.add(pos1);
                if (vertexWeights.size() > 0) {
                    for (VertexWeight vertexWeight : vertexWeights) {
                        float distance = pos2.f_104371_.m_122260_() - pos1.f_104371_.m_122260_();
                        float textureV = pos1.f_104373_ + (pos2.f_104373_ - pos1.f_104373_) * ((vertexWeight.yClipCoord - pos1.f_104371_.m_122260_()) / distance);
                        Vector3f clipPos1 = GeoArmor.getClipPoint(pos1.f_104371_, pos2.f_104371_, vertexWeight.yClipCoord);
                        Vector3f clipPos2 = GeoArmor.getClipPoint(pos0.f_104371_, pos3.f_104371_, vertexWeight.yClipCoord);
                        pos4 = new ModelPart.Vertex(clipPos2, pos0.f_104372_, textureV);
                        pos5 = new ModelPart.Vertex(clipPos1, pos1.f_104372_, textureV);
                        animatedVertices.add(new AnimatedVertex(pos4, 8, 7, 0, vertexWeight.chestWeight, vertexWeight.torsoWeight, 0.0f));
                        animatedVertices.add(new AnimatedVertex(pos5, 8, 7, 0, vertexWeight.chestWeight, vertexWeight.torsoWeight, 0.0f));
                    }
                }
                animatedVertices.add(pos3);
                animatedVertices.add(pos2);
                for (int i = 0; i < (animatedVertices.size() - 2) / 2; ++i) {
                    int start = i * 2;
                    AnimatedVertex p0 = (AnimatedVertex)((Object)animatedVertices.get(start));
                    AnimatedVertex p1 = (AnimatedVertex)((Object)animatedVertices.get(start + 1));
                    AnimatedVertex p2 = (AnimatedVertex)((Object)animatedVertices.get(start + 3));
                    AnimatedVertex p3 = (AnimatedVertex)((Object)animatedVertices.get(start + 2));
                    xyClipPolygons.add(new AnimatedPolygon(new AnimatedVertex[]{new AnimatedVertex(p0, 8, 7, 0, p0.weight.x, p0.weight.y, 0.0f), new AnimatedVertex(p1, 8, 7, 0, p1.weight.x, p1.weight.y, 0.0f), new AnimatedVertex(p2, 8, 7, 0, p2.weight.x, p2.weight.y, 0.0f), new AnimatedVertex(p3, 8, 7, 0, p3.weight.x, p3.weight.y, 0.0f)}, direction));
                }
            }
            for (AnimatedPolygon polygon : xyClipPolygons) {
                Vector3f norm = polygon.normal.m_122281_();
                norm.m_122249_(poseStack.m_85850_().m_85864_());
                for (AnimatedVertex vertex : polygon.animatedVertexPositions) {
                    int count;
                    Vector4f pos = new Vector4f(vertex.f_104371_);
                    float weight1 = vertex.weight.x;
                    float weight2 = vertex.weight.y;
                    int joint1 = vertex.jointId.m_123341_();
                    int joint2 = vertex.jointId.m_123342_();
                    int n = count = weight1 > 0.0f && weight2 > 0.0f ? 2 : 1;
                    if (weight1 <= 0.0f) {
                        joint1 = joint2;
                        weight1 = weight2;
                    }
                    vertices.add(new SingleVertex().setPosition(new Vec3f(pos.m_123601_(), pos.m_123615_(), pos.m_123616_())).setNormal(new Vec3f(norm.m_122239_(), norm.m_122260_(), norm.m_122269_())).setTextureCoordinate(new Vec2f(vertex.f_104372_, vertex.f_104373_)).setEffectiveJointIDs(new Vec3f(joint1, joint2, 0.0f)).setEffectiveJointWeights(new Vec3f(weight1, weight2, 0.0f)).setEffectiveJointNumber(count));
                }
                this.putIndexCount(indices, partName, indexCount);
                this.putIndexCount(indices, partName, indexCount + 1);
                this.putIndexCount(indices, partName, indexCount + 3);
                this.putIndexCount(indices, partName, indexCount + 3);
                this.putIndexCount(indices, partName, indexCount + 1);
                this.putIndexCount(indices, partName, indexCount + 2);
                indexCount += 4;
            }
        }

        static VertexWeight getYClipWeight(float y) {
            if (y < ChestPartTransformer.WEIGHT_ALONG_Y[0].yClipCoord) {
                return new VertexWeight(y, 0.0f, 1.0f);
            }
            int index = -1;
            for (int i = 0; i < WEIGHT_ALONG_Y.length; ++i) {
            }
            if (index > 0) {
                VertexWeight pair = WEIGHT_ALONG_Y[index];
                return new VertexWeight(y, pair.chestWeight, pair.torsoWeight);
            }
            return new VertexWeight(y, 1.0f, 0.0f);
        }

        static List<VertexWeight> getMiddleYClipWeights(float minY, float maxY) {
            ArrayList cutYs = Lists.newArrayList();
            for (VertexWeight vertexWeight : WEIGHT_ALONG_Y) {
                if (!(vertexWeight.yClipCoord > minY) || !(maxY >= vertexWeight.yClipCoord)) continue;
                cutYs.add(vertexWeight);
            }
            return cutYs;
        }

        static class VertexWeight {
            final float yClipCoord;
            final float chestWeight;
            final float torsoWeight;

            public VertexWeight(float yClipCoord, float chestWeight, float torsoWeight) {
                this.yClipCoord = yClipCoord;
                this.chestWeight = chestWeight;
                this.torsoWeight = torsoWeight;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class AnimatedPolygon {
        public final AnimatedVertex[] animatedVertexPositions;
        public final Vector3f normal;

        public AnimatedPolygon(AnimatedVertex[] positionsIn, Direction directionIn) {
            this.animatedVertexPositions = positionsIn;
            this.normal = directionIn.m_122432_();
        }

        public AnimatedPolygon(AnimatedVertex[] positionsIn, float cor, Direction directionIn) {
            this.animatedVertexPositions = positionsIn;
            positionsIn[0] = new AnimatedVertex(positionsIn[0], positionsIn[0].f_104372_, positionsIn[0].f_104373_ + cor, positionsIn[0].jointId, positionsIn[0].weight);
            positionsIn[1] = new AnimatedVertex(positionsIn[1], positionsIn[1].f_104372_, positionsIn[1].f_104373_ + cor, positionsIn[1].jointId, positionsIn[1].weight);
            positionsIn[2] = new AnimatedVertex(positionsIn[2], positionsIn[2].f_104372_, positionsIn[2].f_104373_ - cor, positionsIn[2].jointId, positionsIn[2].weight);
            positionsIn[3] = new AnimatedVertex(positionsIn[3], positionsIn[3].f_104372_, positionsIn[3].f_104373_ - cor, positionsIn[3].jointId, positionsIn[3].weight);
            this.normal = directionIn.m_122432_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class AnimatedVertex
    extends ModelPart.Vertex {
        final Vec3i jointId;
        final Vec3f weight;

        public AnimatedVertex(ModelPart.Vertex posTexVertx, int jointId) {
            this(posTexVertx, jointId, 0, 0, 1.0f, 0.0f, 0.0f);
        }

        public AnimatedVertex(ModelPart.Vertex posTexVertx, int jointId1, int jointId2, int jointId3, float weight1, float weight2, float weight3) {
            this(posTexVertx, new Vec3i(jointId1, jointId2, jointId3), new Vec3f(weight1, weight2, weight3));
        }

        public AnimatedVertex(ModelPart.Vertex posTexVertx, Vec3i ids, Vec3f weights) {
            this(posTexVertx, posTexVertx.f_104372_, posTexVertx.f_104373_, ids, weights);
        }

        public AnimatedVertex(ModelPart.Vertex posTexVertx, float u, float v, Vec3i ids, Vec3f weights) {
            super(posTexVertx.f_104371_.m_122239_(), posTexVertx.f_104371_.m_122260_(), posTexVertx.f_104371_.m_122269_(), u, v);
            this.jointId = ids;
            this.weight = weights;
        }
    }
}

