/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import java.util.Collection;
import java.util.Map;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.client.model.ModelPart;
import yesman.epicfight.api.client.model.VertexIndicator;

@OnlyIn(value=Dist.CLIENT)
public abstract class Mesh<T extends VertexIndicator> {
    final float[] positions;
    final float[] uvs;
    final float[] normals;
    final int totalVertices;
    final Map<String, ModelPart<T>> parts;
    final RenderProperties renderProperties;

    public Mesh(Map<String, float[]> arrayMap, Mesh<T> parent, RenderProperties renderProperties, Map<String, ModelPart<T>> parts) {
        this.positions = parent == null ? arrayMap.get("positions") : parent.positions;
        this.normals = parent == null ? arrayMap.get("normals") : parent.normals;
        this.uvs = parent == null ? arrayMap.get("uvs") : parent.uvs;
        this.parts = parent == null ? parts : parent.parts;
        this.renderProperties = renderProperties;
        int totalV = 0;
        for (ModelPart<T> meshpart : parts.values()) {
            totalV += meshpart.getVertices().size();
        }
        this.totalVertices = totalV;
    }

    protected abstract ModelPart<T> getOrLogException(Map<String, ModelPart<T>> var1, String var2);

    public boolean hasPart(String part) {
        return this.parts.containsKey(part);
    }

    public ModelPart<T> getPart(String part) {
        return this.parts.get(part);
    }

    public Collection<ModelPart<T>> getAllParts() {
        return this.parts.values();
    }

    public RenderProperties getRenderProperty() {
        return this.renderProperties;
    }

    public void initialize() {
        this.parts.values().forEach(part -> {
            part.hidden = false;
        });
    }

    public void drawRawModel(PoseStack poseStack, VertexConsumer builder, int packedLightIn, float r, float g, float b, float a, int overlayCoord) {
        Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
        Matrix3f matrix3f = poseStack.m_85850_().m_85864_();
        for (ModelPart<T> part : this.parts.values()) {
            if (part.hidden) continue;
            for (VertexIndicator vi : part.getVertices()) {
                int pos = vi.position * 3;
                int norm = vi.normal * 3;
                int uv = vi.uv * 2;
                Vector4f posVec = new Vector4f(this.positions[pos], this.positions[pos + 1], this.positions[pos + 2], 1.0f);
                Vector3f normVec = new Vector3f(this.normals[norm], this.normals[norm + 1], this.normals[norm + 2]);
                posVec.m_123607_(matrix4f);
                normVec.m_122249_(matrix3f);
                builder.m_5954_(posVec.m_123601_(), posVec.m_123615_(), posVec.m_123616_(), r, g, b, a, this.uvs[uv], this.uvs[uv + 1], overlayCoord, packedLightIn, normVec.m_122239_(), normVec.m_122260_(), normVec.m_122269_());
            }
        }
    }

    public void drawRawModelNormal(PoseStack poseStack, VertexConsumer builder, int packedLightIn, float r, float g, float b, float a, int overlayCoord) {
        Matrix4f matrix4f = poseStack.m_85850_().m_85861_();
        for (ModelPart<T> part : this.parts.values()) {
            if (part.hidden) continue;
            for (VertexIndicator vi : part.getVertices()) {
                int pos = vi.position * 3;
                int uv = vi.uv * 2;
                Vector4f posVec = new Vector4f(this.positions[pos], this.positions[pos + 1], this.positions[pos + 2], 1.0f);
                posVec.m_123607_(matrix4f);
                builder.m_5483_((double)posVec.m_123601_(), (double)posVec.m_123615_(), (double)posVec.m_123616_()).m_85950_(r, g, b, a).m_7421_(this.uvs[uv], this.uvs[uv + 1]).m_85969_(packedLightIn).m_5752_();
            }
        }
    }

    public static class RenderProperties {
        final String customTexturePath;
        final boolean isTransparent;

        public RenderProperties(Builder builder) {
            this.customTexturePath = builder.customTexturePath;
            this.isTransparent = builder.isTransparent;
        }

        public String getCustomTexturePath() {
            return this.customTexturePath;
        }

        public boolean isTransparent() {
            return this.isTransparent;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            boolean isTransparent = false;
            String customTexturePath = null;

            public Builder customTexturePath(String path) {
                this.customTexturePath = path;
                return this;
            }

            public Builder transparency(boolean isTransparent) {
                this.isTransparent = isTransparent;
                return this;
            }

            public RenderProperties build() {
                return new RenderProperties(this);
            }
        }
    }

    public static class RawMesh
    extends Mesh<VertexIndicator> {
        public static final ModelPart<VertexIndicator> EMPTY = new ModelPart(null, null);

        public RawMesh(Map<String, float[]> arrayMap, Mesh<VertexIndicator> parent, RenderProperties properties, Map<String, ModelPart<VertexIndicator>> parts) {
            super(arrayMap, parent, properties, parts);
        }

        @Override
        protected ModelPart<VertexIndicator> getOrLogException(Map<String, ModelPart<VertexIndicator>> parts, String name) {
            if (!parts.containsKey(name)) {
                return EMPTY;
            }
            return parts.get(name);
        }
    }
}

