/*
 * Decompiled with CFR 0.152.
 */
package yesman.epicfight.api.animation.types;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.registries.RegistryObject;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.Animator;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.property.MoveCoordFunctions;
import yesman.epicfight.api.animation.types.ActionAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.HitEntityList;
import yesman.epicfight.api.utils.TypeFlexibleHashMap;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.world.capabilities.entitypatch.HumanoidMobPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.eventlistener.AttackEndEvent;
import yesman.epicfight.world.entity.eventlistener.DealtDamageEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class AttackAnimation
extends ActionAnimation {
    public final Phase[] phases;
    public static final TypeFlexibleHashMap.TypeKey<List<LivingEntity>> HIT_ENTITIES = new TypeFlexibleHashMap.TypeKey<List<LivingEntity>>(){

        @Override
        public List<LivingEntity> defaultValue() {
            return Lists.newArrayList();
        }
    };
    public static final TypeFlexibleHashMap.TypeKey<List<LivingEntity>> HURT_ENTITIES = new TypeFlexibleHashMap.TypeKey<List<LivingEntity>>(){

        @Override
        public List<LivingEntity> defaultValue() {
            return Lists.newArrayList();
        }
    };
    public static final TypeFlexibleHashMap.TypeKey<Integer> MAX_STRIKES_COUNT = new TypeFlexibleHashMap.TypeKey<Integer>(){

        @Override
        public Integer defaultValue() {
            return 0;
        }
    };

    public AttackAnimation(float convertTime, float antic, float preDelay, float contact, float recovery, @Nullable Collider collider, Joint colliderJoint, String path, Armature armature) {
        this(convertTime, path, armature, new Phase(0.0f, antic, preDelay, contact, recovery, Float.MAX_VALUE, colliderJoint, collider));
    }

    public AttackAnimation(float convertTime, float antic, float preDelay, float contact, float recovery, InteractionHand hand, @Nullable Collider collider, Joint colliderJoint, String path, Armature armature) {
        this(convertTime, path, armature, new Phase(0.0f, antic, preDelay, contact, recovery, Float.MAX_VALUE, hand, colliderJoint, collider));
    }

    public AttackAnimation(float convertTime, String path, Armature armature, Phase ... phases) {
        super(convertTime, path, armature);
        this.addProperty(AnimationProperty.ActionAnimationProperty.COORD_SET_BEGIN, MoveCoordFunctions.TRACE_LOC_TARGET);
        this.addProperty(AnimationProperty.ActionAnimationProperty.COORD_SET_TICK, MoveCoordFunctions.TRACE_LOC_TARGET);
        this.addProperty(AnimationProperty.ActionAnimationProperty.STOP_MOVEMENT, Boolean.valueOf(true));
        this.phases = phases;
        this.stateSpectrumBlueprint.clear();
        for (Phase phase : phases) {
            if (phase.noStateBind) continue;
            this.bindPhaseState(phase);
        }
    }

    protected void bindPhaseState(Phase phase) {
        float preDelay = phase.preDelay;
        if (preDelay == 0.0f) {
            preDelay += 0.01f;
        }
        this.stateSpectrumBlueprint.newTimePair(phase.start, preDelay).addState(EntityState.PHASE_LEVEL, 1).newTimePair(phase.start, phase.contact + 0.01f).addState(EntityState.CAN_SKILL_EXECUTION, false).newTimePair(phase.start, phase.recovery).addState(EntityState.MOVEMENT_LOCKED, true).addState(EntityState.UPDATE_LIVING_MOTION, false).addState(EntityState.CAN_BASIC_ATTACK, false).newTimePair(phase.start, phase.end).addState(EntityState.INACTION, true).newTimePair(phase.antic, phase.end).addState(EntityState.TURNING_LOCKED, true).newTimePair(preDelay, phase.contact + 0.01f).addState(EntityState.ATTACKING, true).addState(EntityState.PHASE_LEVEL, 2).newTimePair(phase.contact + 0.01f, phase.end).addState(EntityState.PHASE_LEVEL, 3);
    }

    @Override
    public void begin(LivingEntityPatch<?> entitypatch) {
        super.begin(entitypatch);
        entitypatch.setLastAttackSuccess(false);
    }

    @Override
    public void linkTick(LivingEntityPatch<?> entitypatch, DynamicAnimation linkAnimation) {
        super.linkTick(entitypatch, linkAnimation);
        if (!entitypatch.isLogicalClient() && entitypatch instanceof MobPatch) {
            MobPatch mobpatch = (MobPatch)entitypatch;
            AnimationPlayer player = ((Animator)entitypatch.getAnimator()).getPlayerFor(this);
            float elapsedTime = player.getElapsedTime();
            EntityState state = this.getState(entitypatch, elapsedTime);
            if (state.getLevel() == 1 && !state.turningLocked()) {
                ((Mob)mobpatch.getOriginal()).m_21573_().m_26573_();
                ((LivingEntity)entitypatch.getOriginal()).f_20921_ = 2.0f;
                LivingEntity target = entitypatch.getTarget();
                if (target != null) {
                    entitypatch.rotateTo((Entity)target, entitypatch.getYRotLimit(), false);
                }
            }
        }
    }

    @Override
    public void tick(LivingEntityPatch<?> entitypatch) {
        super.tick(entitypatch);
        if (!entitypatch.isLogicalClient()) {
            this.attackTick(entitypatch);
        }
    }

    @Override
    public void end(LivingEntityPatch<?> entitypatch, DynamicAnimation nextAnimation, boolean isEnd) {
        super.end(entitypatch, nextAnimation, isEnd);
        if (entitypatch instanceof ServerPlayerPatch) {
            ServerPlayerPatch playerpatch = (ServerPlayerPatch)entitypatch;
            if (isEnd) {
                playerpatch.getEventListener().triggerEvents(PlayerEventListener.EventType.ATTACK_ANIMATION_END_EVENT, new AttackEndEvent(playerpatch, this));
            }
        }
        if (entitypatch instanceof HumanoidMobPatch) {
            Mob entity;
            HumanoidMobPatch mobpatch = (HumanoidMobPatch)entitypatch;
            if (entitypatch.isLogicalClient() && (entity = (Mob)mobpatch.getOriginal()).m_5448_() != null && !entity.m_5448_().m_6084_()) {
                entity.m_6710_((LivingEntity)null);
            }
        }
    }

    protected void attackTick(LivingEntityPatch<?> entitypatch) {
        AnimationPlayer player = ((Animator)entitypatch.getAnimator()).getPlayerFor(this);
        float elapsedTime = player.getElapsedTime();
        float prevElapsedTime = player.getPrevElapsedTime();
        EntityState state = this.getState(entitypatch, elapsedTime);
        EntityState prevState = this.getState(entitypatch, prevElapsedTime);
        Phase phase = this.getPhaseByTime(elapsedTime);
        if (state.getLevel() == 1 && !state.turningLocked() && entitypatch instanceof MobPatch) {
            MobPatch mobpatch = (MobPatch)entitypatch;
            ((Mob)mobpatch.getOriginal()).m_21573_().m_26573_();
            ((LivingEntity)entitypatch.getOriginal()).f_20921_ = 2.0f;
            LivingEntity target = entitypatch.getTarget();
            if (target != null) {
                entitypatch.rotateTo((Entity)target, entitypatch.getYRotLimit(), false);
            }
        }
        if (prevState.attacking() || state.attacking() || prevState.getLevel() < 2 && state.getLevel() > 2) {
            if (!prevState.attacking() || phase != this.getPhaseByTime(prevElapsedTime) && (state.attacking() || prevState.getLevel() < 2 && state.getLevel() > 2)) {
                entitypatch.playSound(this.getSwingSound(entitypatch, phase), 0.0f, 0.0f);
                entitypatch.removeHurtEntities();
            }
            this.hurtCollidingEntities(entitypatch, prevElapsedTime, elapsedTime, prevState, state, phase);
        }
    }

    protected void hurtCollidingEntities(LivingEntityPatch<?> entitypatch, float prevElapsedTime, float elapsedTime, EntityState prevState, EntityState state, Phase phase) {
        LivingEntity entity = (LivingEntity)entitypatch.getOriginal();
        entitypatch.getArmature().initializeTransform();
        float prevPoseTime = prevState.attacking() ? prevElapsedTime : phase.preDelay;
        float poseTime = state.attacking() ? elapsedTime : phase.contact;
        List<Entity> list = this.getPhaseByTime(elapsedTime).getCollidingEntities(entitypatch, this, prevPoseTime, poseTime, this.getPlaySpeed(entitypatch));
        if (list.size() > 0) {
            HitEntityList hitEntities = new HitEntityList(entitypatch, list, phase.getProperty(AnimationProperty.AttackPhaseProperty.HIT_PRIORITY).orElse(HitEntityList.Priority.DISTANCE));
            int maxStrikes = this.getMaxStrikes(entitypatch, phase);
            while (entitypatch.getCurrenltyHurtEntities().size() < maxStrikes && hitEntities.next()) {
                Entity hitten = hitEntities.getEntity();
                LivingEntity trueEntity = this.getTrueEntity(hitten);
                if (trueEntity == null || !trueEntity.m_6084_() || entitypatch.getCurrenltyAttackedEntities().contains(trueEntity) || entitypatch.isTeammate(hitten) || !(hitten instanceof LivingEntity) && !(hitten instanceof PartEntity) || !entity.m_142582_(hitten)) continue;
                EpicFightDamageSource source = this.getEpicFightDamageSource(entitypatch, hitten, phase);
                int prevInvulTime = hitten.f_19802_;
                hitten.f_19802_ = 0;
                AttackResult attackResult = entitypatch.attack(source, hitten, phase.hand);
                hitten.f_19802_ = prevInvulTime;
                if (attackResult.resultType.dealtDamage()) {
                    if (entitypatch instanceof ServerPlayerPatch) {
                        ServerPlayerPatch playerpatch = (ServerPlayerPatch)entitypatch;
                        playerpatch.getEventListener().triggerEvents(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_POST, new DealtDamageEvent(playerpatch, trueEntity, source, attackResult.damage));
                    }
                    hitten.f_19853_.m_6263_(null, hitten.m_20185_(), hitten.m_20186_(), hitten.m_20189_(), this.getHitSound(entitypatch, phase), hitten.m_5720_(), 1.0f, 1.0f);
                    this.spawnHitParticle((ServerLevel)hitten.m_9236_(), entitypatch, hitten, phase);
                }
                entitypatch.getCurrenltyAttackedEntities().add(trueEntity);
                if (!attackResult.resultType.shouldCount()) continue;
                entitypatch.getCurrenltyHurtEntities().add(trueEntity);
            }
        }
    }

    public LivingEntity getTrueEntity(Entity entity) {
        PartEntity partEntity;
        Entity parentEntity;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return livingEntity;
        }
        if (entity instanceof PartEntity && (parentEntity = (partEntity = (PartEntity)entity).getParent()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)parentEntity;
            return livingEntity;
        }
        return null;
    }

    protected int getMaxStrikes(LivingEntityPatch<?> entitypatch, Phase phase) {
        return phase.getProperty(AnimationProperty.AttackPhaseProperty.MAX_STRIKES_MODIFIER).map(valueCorrector -> Float.valueOf(valueCorrector.getTotalValue(entitypatch.getMaxStrikes(phase.hand)))).orElse(Float.valueOf(entitypatch.getMaxStrikes(phase.hand))).intValue();
    }

    protected SoundEvent getSwingSound(LivingEntityPatch<?> entitypatch, Phase phase) {
        return phase.getProperty(AnimationProperty.AttackPhaseProperty.SWING_SOUND).orElse(entitypatch.getSwingSound(phase.hand));
    }

    protected SoundEvent getHitSound(LivingEntityPatch<?> entitypatch, Phase phase) {
        return phase.getProperty(AnimationProperty.AttackPhaseProperty.HIT_SOUND).orElse(entitypatch.getWeaponHitSound(phase.hand));
    }

    public EpicFightDamageSource getEpicFightDamageSource(LivingEntityPatch<?> entitypatch, Entity target, Phase phase) {
        return this.getEpicFightDamageSource(entitypatch.getDamageSource(this, phase.hand).cast(), entitypatch, target, phase);
    }

    public EpicFightDamageSource getEpicFightDamageSource(DamageSource originalSource, LivingEntityPatch<?> entitypatch, Entity target, Phase phase) {
        EpicFightDamageSource epicfightDamageSource;
        if (phase == null) {
            phase = this.getPhaseByTime(((Animator)entitypatch.getAnimator()).getPlayerFor(this).getElapsedTime());
        }
        EpicFightDamageSource extendedSource = originalSource instanceof EpicFightDamageSource ? (epicfightDamageSource = (EpicFightDamageSource)originalSource) : EpicFightDamageSource.commonEntityDamageSource(originalSource.f_19326_, (LivingEntity)entitypatch.getOriginal(), this);
        phase.getProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER).ifPresent(opt -> extendedSource.setDamageModifier((ValueModifier)opt));
        phase.getProperty(AnimationProperty.AttackPhaseProperty.ARMOR_NEGATION_MODIFIER).ifPresent(opt -> extendedSource.setArmorNegation(opt.getTotalValue(extendedSource.getArmorNegation())));
        phase.getProperty(AnimationProperty.AttackPhaseProperty.IMPACT_MODIFIER).ifPresent(opt -> extendedSource.setImpact(opt.getTotalValue(extendedSource.getImpact())));
        phase.getProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE).ifPresent(opt -> extendedSource.setStunType((StunType)((Object)opt)));
        phase.getProperty(AnimationProperty.AttackPhaseProperty.SOURCE_TAG).ifPresent(opt -> opt.forEach(extendedSource::addTag));
        phase.getProperty(AnimationProperty.AttackPhaseProperty.EXTRA_DAMAGE).ifPresent(opt -> opt.forEach(extendedSource::addExtraDamage));
        phase.getProperty(AnimationProperty.AttackPhaseProperty.SOURCE_LOCATION_PROVIDER).ifPresent(opt -> extendedSource.setInitialPosition((Vec3)opt.apply(entitypatch)));
        phase.getProperty(AnimationProperty.AttackPhaseProperty.SOURCE_LOCATION_PROVIDER).ifPresentOrElse(opt -> extendedSource.setInitialPosition((Vec3)opt.apply(entitypatch)), () -> extendedSource.setInitialPosition(((LivingEntity)entitypatch.getOriginal()).m_20182_()));
        return extendedSource;
    }

    protected void spawnHitParticle(ServerLevel world, LivingEntityPatch<?> attacker, Entity hit, Phase phase) {
        Optional<RegistryObject<HitParticleType>> particleOptional = phase.getProperty(AnimationProperty.AttackPhaseProperty.PARTICLE);
        HitParticleType particle = particleOptional.isPresent() ? (HitParticleType)((Object)particleOptional.get().get()) : attacker.getWeaponHitParticle(phase.hand);
        particle.spawnParticleWithArgument(world, null, null, hit, (Entity)attacker.getOriginal());
    }

    @Override
    public float getPlaySpeed(LivingEntityPatch<?> entitypatch) {
        if (entitypatch instanceof PlayerPatch) {
            PlayerPatch playerpatch = (PlayerPatch)entitypatch;
            Phase phase = this.getPhaseByTime(((Animator)playerpatch.getAnimator()).getPlayerFor(this).getElapsedTime());
            float speedFactor = this.getProperty(AnimationProperty.AttackAnimationProperty.ATTACK_SPEED_FACTOR).orElse(Float.valueOf(1.0f)).floatValue();
            Optional<Float> property = this.getProperty(AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED);
            float correctedSpeed = property.map(value -> Float.valueOf(playerpatch.getAttackSpeed(phase.hand) / value.floatValue())).orElse(Float.valueOf(this.totalTime * playerpatch.getAttackSpeed(phase.hand))).floatValue();
            correctedSpeed = (float)Math.round(correctedSpeed * 1000.0f) / 1000.0f;
            return 1.0f + (correctedSpeed - 1.0f) * speedFactor;
        }
        return 1.0f;
    }

    public <V> AttackAnimation addProperty(AnimationProperty.AttackAnimationProperty<V> propertyType, V value) {
        this.properties.put(propertyType, value);
        return this;
    }

    public <V> AttackAnimation addProperty(AnimationProperty.AttackPhaseProperty<V> propertyType, V value) {
        return this.addProperty(propertyType, value, 0);
    }

    public <V> AttackAnimation addProperty(AnimationProperty.AttackPhaseProperty<V> propertyType, V value, int index) {
        this.phases[index].addProperty(propertyType, value);
        return this;
    }

    public Phase getPhaseByTime(float elapsedTime) {
        Phase currentPhase = null;
        Phase[] phaseArray = this.phases;
        int n = phaseArray.length;
        for (int i = 0; i < n; ++i) {
            Phase phase;
            currentPhase = phase = phaseArray[i];
            if (phase.end > elapsedTime) break;
        }
        return currentPhase;
    }

    @Deprecated
    public void changeCollider(Collider newCollider, int index) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderDebugging(PoseStack poseStack, MultiBufferSource buffer, LivingEntityPatch<?> entitypatch, float playbackTime, float partialTicks) {
        AnimationPlayer animPlayer = ((Animator)entitypatch.getAnimator()).getPlayerFor(this);
        float prevElapsedTime = animPlayer.getPrevElapsedTime();
        float elapsedTime = animPlayer.getElapsedTime();
        Phase phase = this.getPhaseByTime(playbackTime);
        for (Pair<Joint, Collider> colliderInfo : phase.colliders) {
            Collider collider = (Collider)colliderInfo.getSecond();
            if (collider == null) {
                collider = entitypatch.getColliderMatching(phase.hand);
            }
            collider.draw(poseStack, buffer, entitypatch, this, (Joint)colliderInfo.getFirst(), prevElapsedTime, elapsedTime, partialTicks, this.getPlaySpeed(entitypatch));
        }
    }

    public static class Phase {
        private final Map<AnimationProperty.AttackPhaseProperty<?>, Object> properties = Maps.newHashMap();
        public final float start;
        public final float antic;
        public final float preDelay;
        public final float contact;
        public final float recovery;
        public final float end;
        public final InteractionHand hand;
        public List<Pair<Joint, Collider>> colliders;
        public final boolean noStateBind;

        public Phase(float start, float antic, float contact, float recovery, float end, Joint joint, Collider collider) {
            this(start, antic, contact, recovery, end, InteractionHand.MAIN_HAND, joint, collider);
        }

        public Phase(float start, float antic, float contact, float recovery, float end, InteractionHand hand, Joint joint, Collider collider) {
            this(start, antic, antic, contact, recovery, end, hand, joint, collider);
        }

        public Phase(float start, float antic, float preDelay, float contact, float recovery, float end, Joint joint, Collider collider) {
            this(start, antic, preDelay, contact, recovery, end, InteractionHand.MAIN_HAND, joint, collider);
        }

        public Phase(float start, float antic, float preDelay, float contact, float recovery, float end, InteractionHand hand, Joint joint, Collider collider) {
            this(start, antic, preDelay, contact, recovery, end, false, hand, joint, collider);
        }

        public Phase(InteractionHand hand, Joint joint, Collider collider) {
            this(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, true, hand, joint, collider);
        }

        public Phase(float start, float antic, float preDelay, float contact, float recovery, float end, boolean noStateBind, InteractionHand hand, Joint joint, Collider collider) {
            this(start, antic, preDelay, contact, recovery, end, noStateBind, hand, List.of(Pair.of((Object)joint, (Object)collider)));
        }

        public Phase(float start, float antic, float preDelay, float contact, float recovery, float end, boolean noStateBind, InteractionHand hand, List<Pair<Joint, Collider>> colliders) {
            this.start = start;
            this.antic = antic;
            this.preDelay = preDelay;
            this.contact = contact;
            this.recovery = recovery;
            this.end = end;
            this.colliders = colliders;
            this.hand = hand;
            this.noStateBind = noStateBind;
        }

        public <V> Phase addProperty(AnimationProperty.AttackPhaseProperty<V> propertyType, V value) {
            this.properties.put(propertyType, value);
            return this;
        }

        public void addProperties(Set<Map.Entry<AnimationProperty.AttackPhaseProperty<?>, Object>> set) {
            for (Map.Entry<AnimationProperty.AttackPhaseProperty<?>, Object> entry : set) {
                this.properties.put(entry.getKey(), entry.getValue());
            }
        }

        public <V> Optional<V> getProperty(AnimationProperty.AttackPhaseProperty<V> propertyType) {
            return Optional.ofNullable(this.properties.get(propertyType));
        }

        public List<Entity> getCollidingEntities(LivingEntityPatch<?> entitypatch, AttackAnimation animation, float prevElapsedTime, float elapsedTime, float attackSpeed) {
            ArrayList entities = Lists.newArrayList();
            for (Pair<Joint, Collider> colliderInfo : this.colliders) {
                Collider collider = (Collider)colliderInfo.getSecond();
                if (collider == null) {
                    collider = entitypatch.getColliderMatching(this.hand);
                }
                entities.addAll(collider.updateAndSelectCollideEntity(entitypatch, animation, prevElapsedTime, elapsedTime, (Joint)colliderInfo.getFirst(), attackSpeed));
            }
            return new ArrayList<Entity>(new HashSet(entities));
        }

        public List<Pair<Joint, Collider>> getColliders() {
            return this.colliders;
        }

        public InteractionHand getHand() {
            return this.hand;
        }
    }
}

