/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.epiccompat_parcool.forge.network;

import com.gitlab.srcmc.epiccompat_parcool.forge.network.client.CPSetParkourActive;
import com.gitlab.srcmc.epiccompat_parcool.forge.network.server.SPSetParkourActive;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

@Mod.EventBusSubscriber(modid="epiccompat_parcool", bus=Mod.EventBusSubscriber.Bus.MOD)
public class NetworkManager {
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("epiccompat_parcool", "network_manager"), () -> "1", "1"::equals, "1"::equals);

    public static <MSG> void sendToServer(MSG message) {
        INSTANCE.sendToServer(message);
    }

    public static <MSG> void sendToClient(MSG message, PacketDistributor.PacketTarget packetTarget) {
        INSTANCE.send(packetTarget, message);
    }

    public static <MSG> void sendToAll(MSG message) {
        NetworkManager.sendToClient(message, PacketDistributor.ALL.noArg());
    }

    public static <MSG> void sendToAllPlayerTrackingThisEntity(MSG message, Entity entity) {
        NetworkManager.sendToClient(message, PacketDistributor.TRACKING_ENTITY.with(() -> entity));
    }

    public static <MSG> void sendToPlayer(MSG message, ServerPlayer player) {
        NetworkManager.sendToClient(message, PacketDistributor.PLAYER.with(() -> player));
    }

    public static <MSG> void sendToAllPlayerTrackingThisEntityWithSelf(MSG message, ServerPlayer entity) {
        NetworkManager.sendToClient(message, PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity));
    }

    public static <MSG> void sendToAllPlayerTrackingThisChunkWithSelf(MSG message, LevelChunk chunk) {
        NetworkManager.sendToClient(message, PacketDistributor.TRACKING_CHUNK.with(() -> chunk));
    }

    @SubscribeEvent
    public static void register(FMLCommonSetupEvent event) {
        int id = 0;
        INSTANCE.registerMessage(id++, CPSetParkourActive.class, CPSetParkourActive::toBytes, CPSetParkourActive::fromBytes, CPSetParkourActive::handle);
        INSTANCE.registerMessage(id++, SPSetParkourActive.class, SPSetParkourActive::toBytes, SPSetParkourActive::fromBytes, SPSetParkourActive::handle);
    }
}

