/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.enchantlimiter.mixin;

import jackiecrazy.enchantlimiter.EnchantLimiter;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={EnchantmentHelper.class})
public class EnchantmentHelperMixin {
    @Overwrite
    public static void m_44865_(Map<Enchantment, Integer> enchMap, ItemStack stack) {
        CompoundTag compoundnbt;
        int i;
        Enchantment enchantment;
        ListTag listnbt = new ListTag();
        double accumulated = 0.0;
        double max = EnchantLimiter.getTotalEnchantPoints(stack);
        for (Map.Entry<Enchantment, Integer> entry : enchMap.entrySet()) {
            enchantment = entry.getKey();
            if (enchantment == null || EnchantLimiter.getRequiredEnchantPoints(enchantment, i = entry.getValue().intValue()) >= 0.0) continue;
            compoundnbt = new CompoundTag();
            compoundnbt.m_128359_("id", String.valueOf(Registry.f_122825_.m_7981_((Object)enchantment)));
            compoundnbt.m_128376_("lvl", (short)i);
            listnbt.add((Object)compoundnbt);
            if (stack.m_41720_() instanceof EnchantedBookItem) {
                EnchantedBookItem.m_41153_((ItemStack)stack, (EnchantmentInstance)new EnchantmentInstance(enchantment, i));
            }
            accumulated += EnchantLimiter.getRequiredEnchantPoints(enchantment, i);
        }
        for (Map.Entry<Enchantment, Integer> entry : enchMap.entrySet()) {
            enchantment = entry.getKey();
            if (enchantment == null || EnchantLimiter.getRequiredEnchantPoints(enchantment, i = entry.getValue().intValue()) < 0.0) continue;
            while (i >= 1 && accumulated + EnchantLimiter.getRequiredEnchantPoints(enchantment, i) > max) {
                --i;
            }
            if (i <= 0) continue;
            compoundnbt = new CompoundTag();
            compoundnbt.m_128359_("id", String.valueOf(Registry.f_122825_.m_7981_((Object)enchantment)));
            compoundnbt.m_128376_("lvl", (short)i);
            listnbt.add((Object)compoundnbt);
            if (stack.m_41720_() instanceof EnchantedBookItem) {
                EnchantedBookItem.m_41153_((ItemStack)stack, (EnchantmentInstance)new EnchantmentInstance(enchantment, i));
            }
            accumulated += EnchantLimiter.getRequiredEnchantPoints(enchantment, i);
        }
        if (listnbt.isEmpty()) {
            stack.m_41749_("Enchantments");
        } else if (stack.m_41720_() != Items.f_42690_) {
            stack.m_41700_("Enchantments", (Tag)listnbt);
        }
    }
}

