/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.enchantlimiter;

import jackiecrazy.enchantlimiter.EnchantLimiter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="enchantlimiter", bus=Mod.EventBusSubscriber.Bus.MOD)
public class LimiterConfig {
    public static final LimiterConfig CONFIG;
    public static final ForgeConfigSpec CONFIG_SPEC;
    public static HashMap<Enchantment, EnchantInfo> map;
    public static HashMap<Item, EnchantInfo> customItems;
    public static EnchantInfo DEFAULT;
    public static double pointsPerEnchantability;
    public static double grain;
    public static int basePoint;
    private final ForgeConfigSpec.DoubleValue ppe;
    private final ForgeConfigSpec.DoubleValue granularity;
    private final ForgeConfigSpec.IntValue basePoints;
    private final ForgeConfigSpec.IntValue baseCost;
    private final ForgeConfigSpec.IntValue incrementalCost;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> _customItems;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> _enchantDefinition;

    public LimiterConfig(ForgeConfigSpec.Builder b) {
        b.push("enchantability");
        this.ppe = b.comment("how much each point of enchantability in the item will add to its enchantment point pool").defineInRange("points per enchantability", 0.5, 0.0, Double.MAX_VALUE);
        this.granularity = b.comment("if the number of enchantment points falls within this distance to a whole number, it will be rounded to the whole number instead. This allows you to have clean 1/3 or 1/7 for the incremental cost of enchantments.").defineInRange("granularity", 0.1, 0.0, 1.0);
        this.basePoints = b.comment("how many enchantment points an item starts with").defineInRange("base points", 10, 0, Integer.MAX_VALUE);
        this.baseCost = b.comment("the default cost to add a new enchantment onto an item.").defineInRange("base cost", 0, 0, Integer.MAX_VALUE);
        this.incrementalCost = b.comment("the default cost to add one level to any existing enchantment on the item. An enchantment with level 1 will apply both the base cost and the incremental cost, once each.").defineInRange("incremental cost", 1, 0, Integer.MAX_VALUE);
        this._customItems = b.comment("Items that have their own enchantment point cap. Format is name, base enchantability, increment per extra point of enchantability.").defineList("custom items", Arrays.asList("minecraft:fishing_rod, 20, 0.5", "minecraft:bow, 15, 1", "minecraft:enchanted_book, 30, 0"), String.class::isInstance);
        this._enchantDefinition = b.comment("It's really irritating how nightconfig doesn't keep the entries in separate lines, but alas. Define enchantments here. Format is name, base cost, incremental cost.").defineList("enchantments", Arrays.asList("minecraft:mending, 5, 0", "minecraft:sharpness, 0, 1"), String.class::isInstance);
        b.pop();
        b.build();
    }

    private static String readAllBytesJava7(String filePath) {
        String content = "";
        try {
            content = new String(Files.readAllBytes(Paths.get(filePath, new String[0])));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return content;
    }

    @SubscribeEvent
    public static void loadConfig(ModConfigEvent e) {
        if (e.getConfig().getSpec() == CONFIG_SPEC) {
            try {
                map.clear();
                customItems.clear();
                pointsPerEnchantability = (Double)LimiterConfig.CONFIG.ppe.get();
                basePoint = (Integer)LimiterConfig.CONFIG.basePoints.get();
                grain = (Double)LimiterConfig.CONFIG.granularity.get();
                DEFAULT = new EnchantInfo(basePoint, pointsPerEnchantability);
                List list = (List)LimiterConfig.CONFIG._enchantDefinition.get();
                for (Enchantment ench : ForgeRegistries.ENCHANTMENTS) {
                    double base = ((Integer)LimiterConfig.CONFIG.baseCost.get()).intValue();
                    double incr = ((Integer)LimiterConfig.CONFIG.incrementalCost.get()).intValue();
                    for (String element : list) {
                        if (!element.startsWith(ForgeRegistries.ENCHANTMENTS.getKey((Object)ench).toString())) continue;
                        String[] split = element.split(",");
                        base = Double.parseDouble(split[1].trim());
                        incr = Double.parseDouble(split[2].trim());
                    }
                    map.put(ench, new EnchantInfo(base, incr));
                }
                for (String s : (List)LimiterConfig.CONFIG._customItems.get()) {
                    String[] split = s.split(",");
                    customItems.put((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(split[0].trim())), new EnchantInfo(Integer.parseInt(split[1].trim()), Double.parseDouble(split[2].trim())));
                }
                EnchantLimiter.LOGGER.debug("enchantment limits loaded!");
            }
            catch (Exception validationException) {
                EnchantLimiter.LOGGER.fatal("Something broke while loading the enchantment config!.");
                validationException.printStackTrace();
            }
        }
    }

    static {
        map = new HashMap();
        customItems = new HashMap();
        DEFAULT = new EnchantInfo(0.0, 1.0);
        Pair specPair = new ForgeConfigSpec.Builder().configure(LimiterConfig::new);
        CONFIG = (LimiterConfig)specPair.getLeft();
        CONFIG_SPEC = (ForgeConfigSpec)specPair.getRight();
    }

    public static class EnchantInfo {
        private final double base;
        private final double increment;

        EnchantInfo(double base, double increment) {
            this.base = base;
            this.increment = increment;
        }

        public double getIncrement() {
            return this.increment;
        }

        public double getBase() {
            return this.base;
        }
    }
}

