/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.diet.common.config;

import com.illusivesoulworks.diet.platform.Services;
import com.illusivesoulworks.spectrelib.config.SpectreConfigSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import org.apache.commons.lang3.tuple.Pair;

public class DietConfig {
    public static final SpectreConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;
    public static final SpectreConfigSpec SERVER_SPEC;
    public static final Server SERVER;
    private static final String CONFIG_PREFIX = "gui.diet.config.";

    static {
        Pair clientPair = new SpectreConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (SpectreConfigSpec)clientPair.getRight();
        CLIENT = (Client)clientPair.getLeft();
        Pair generalPair = new SpectreConfigSpec.Builder().configure(Server::new);
        SERVER_SPEC = (SpectreConfigSpec)generalPair.getRight();
        SERVER = (Server)generalPair.getLeft();
    }

    public static class Client {
        public final SpectreConfigSpec.IntValue buttonX;
        public final SpectreConfigSpec.IntValue buttonY;
        public final SpectreConfigSpec.ConfigValue<String> textColor;
        public final SpectreConfigSpec.BooleanValue addButton;

        public Client(SpectreConfigSpec.Builder builder) {
            this.addButton = builder.comment("If enabled, a button to the Diet GUI appears in player inventories.").translation("gui.diet.config.addButton").define("addButton", true);
            this.buttonX = builder.comment("The x-position of the Diet GUI button in player inventories.").translation("gui.diet.config.buttonX").defineInRange("buttonX", 126, -10000, 10000);
            this.buttonY = builder.comment("The y-position of the Diet GUI button in player inventories.").translation("gui.diet.config.buttonY").defineInRange("buttonY", -22, -10000, 10000);
            this.textColor = builder.comment("The primary text color of the Diet GUI, as an integer or hex code.").translation("gui.diet.config.textColor").define("textColor", (Object)"4210752");
        }
    }

    public static class Server {
        public final SpectreConfigSpec.IntValue deathPenaltyMin;
        public final SpectreConfigSpec.IntValue deathPenaltyLoss;
        public final SpectreConfigSpec.EnumValue<DeathPenaltyMethod> deathPenaltyMethod;
        public final SpectreConfigSpec.IntValue gainPenaltyPerGroup;
        public final SpectreConfigSpec.IntValue decayPenaltyPerGroup;
        public final SpectreConfigSpec.ConfigValue<List<? extends String>> foodOverrides;
        public final SpectreConfigSpec.BooleanValue hideTooltipsUntilEaten;
        public final SpectreConfigSpec.BooleanValue generateGroupsForEmptyItems;
        private final Map<Item, Float> overrideMap = new HashMap<Item, Float>();
        boolean initializedFoodOverrides = false;

        public Server(SpectreConfigSpec.Builder builder) {
            this.deathPenaltyMin = builder.comment("The minimum percentage that diet groups can be reduced to upon death.").translation("gui.diet.config.deathPenaltyMin").defineInRange("deathPenaltyMin", 0, 0, 100);
            this.deathPenaltyLoss = builder.comment("The reduction in percentage applied to all diet groups upon death.").translation("gui.diet.config.deathPenaltyLoss").defineInRange("deathPenaltyLoss", 100, 0, 100);
            this.deathPenaltyMethod = builder.comment("The method to apply for losses due to death penalties.\nAMOUNT = Reduce by a flat percentage amount\nPERCENT = Reduce by a percent of the current value\nRESET = Reset value to defaults").translation("gui.diet.config.deathPenaltyMethod").defineEnum("deathPenaltyMethod", (Enum)DeathPenaltyMethod.AMOUNT);
            this.gainPenaltyPerGroup = builder.comment("The percentage reduction in total gain for each diet group consumed at once.").translation("gui.diet.config.gainPenaltyPerGroup").defineInRange("gainPenaltyPerGroup", 15, 0, 100);
            this.decayPenaltyPerGroup = builder.comment("The percentage reduction in total decay for each diet group decayed at once.").translation("gui.diet.config.decayPenaltyPerGroup").defineInRange("decayPenaltyPerGroup", 15, 0, 100);
            this.foodOverrides = builder.comment("List of food quality overrides for diet gain values.\nFormat: \"modid:name;quality\"").translation("gui.diet.config.foodOverrides").defineList("foodOverrides", new ArrayList(), s -> s instanceof String);
            this.generateGroupsForEmptyItems = builder.comment("If enabled, food groups are assigned to unclassified items based on ingredients.").translation("gui.diet.config.generateGroupsForEmptyItems").define("generateGroupsForEmptyItems", true);
            this.hideTooltipsUntilEaten = builder.comment("If enabled, food group tooltips are hidden until player has eaten that type of item.").translation("gui.diet.config.hideTooltipsUntilEaten").define("hideTooltipsUntilEaten", false);
        }

        public Float getFoodOverride(Item item) {
            if (!this.initializedFoodOverrides) {
                this.overrideMap.clear();
                this.initializedFoodOverrides = true;
                for (String s : (List)this.foodOverrides.get()) {
                    String[] split = s.split(";");
                    Services.REGISTRY.getItem(new ResourceLocation(split[0])).ifPresent(item1 -> this.overrideMap.put((Item)item1, Float.valueOf(Float.parseFloat(split[1]))));
                }
            }
            return this.overrideMap.get(item);
        }
    }

    public static enum DeathPenaltyMethod {
        AMOUNT,
        PERCENT,
        RESET;

    }
}

