/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.defaultoptions.keys;

import com.mojang.blaze3d.platform.InputConstants;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.blay09.mods.balm.api.client.keymappings.KeyModifier;
import net.blay09.mods.defaultoptions.DefaultOptions;
import net.blay09.mods.defaultoptions.PlatformBindings;
import net.blay09.mods.defaultoptions.api.DefaultOptionsCategory;
import net.blay09.mods.defaultoptions.api.DefaultOptionsHandler;
import net.blay09.mods.defaultoptions.api.DefaultOptionsLoadStage;
import net.blay09.mods.defaultoptions.keys.DefaultKeyMapping;
import net.blay09.mods.defaultoptions.mixin.KeyMappingAccessor;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;

public class KeyMappingDefaultsHandler
implements DefaultOptionsHandler {
    private static final Pattern KEY_PATTERN = Pattern.compile("key_([^:]+):([^:]+)(?::(.+))?");
    private static final Map<String, DefaultKeyMapping> defaultKeys = new HashMap<String, DefaultKeyMapping>();
    private static final List<String> knownKeys = new ArrayList<String>();

    private File getDefaultOptionsFile() {
        return new File(DefaultOptions.getDefaultOptionsFolder(), "keybindings.txt");
    }

    @Override
    public String getId() {
        return "keymappings";
    }

    @Override
    public DefaultOptionsCategory getCategory() {
        return DefaultOptionsCategory.KEYS;
    }

    @Override
    public DefaultOptionsLoadStage getLoadStage() {
        return DefaultOptionsLoadStage.POST_LOAD;
    }

    @Override
    public void saveCurrentOptions() {
        Minecraft.m_91087_().f_91066_.m_92169_();
    }

    @Override
    public void saveCurrentOptionsAsDefault() {
        try (PrintWriter writer = new PrintWriter(new FileWriter(new File(DefaultOptions.getDefaultOptionsFolder(), "keybindings.txt")));){
            for (KeyMapping keyMapping : Minecraft.m_91087_().f_91066_.f_92059_) {
                KeyModifier keyModifier = PlatformBindings.INSTANCE.getKeyModifier(keyMapping);
                writer.println("key_" + keyMapping.m_90860_() + ":" + keyMapping.m_90865_() + ":" + keyModifier.name());
            }
        }
        catch (IOException e) {
            DefaultOptions.logger.error("Failed to save default key mappings", (Throwable)e);
        }
        this.loadDefaults();
    }

    @Override
    public boolean hasDefaults() {
        return this.getDefaultOptionsFile().exists();
    }

    @Override
    public boolean shouldLoadDefaults() {
        return true;
    }

    @Override
    public void loadDefaults() {
        File knownKeysFile;
        block30: {
            defaultKeys.clear();
            knownKeys.clear();
            File defaultKeysFile = new File(DefaultOptions.getDefaultOptionsFolder(), "keybindings.txt");
            if (defaultKeysFile.exists()) {
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(defaultKeysFile));
                    block23: while (true) {
                        String line;
                        while ((line = reader.readLine()) != null) {
                            Matcher matcher;
                            if (line.isEmpty() || !(matcher = KEY_PATTERN.matcher(line)).matches()) continue;
                            try {
                                KeyModifier modifier = matcher.group(3) != null ? KeyModifier.valueOf((String)matcher.group(3)) : KeyModifier.NONE;
                                defaultKeys.put(matcher.group(1), new DefaultKeyMapping(InputConstants.m_84851_((String)matcher.group(2)), modifier));
                                continue block23;
                            }
                            catch (Exception e) {
                                DefaultOptions.logger.error("Error loading default key binding for {}", (Object)line, (Object)e);
                            }
                        }
                        break block30;
                        {
                            continue block23;
                            break;
                        }
                        break;
                    }
                    finally {
                        reader.close();
                    }
                }
                catch (Exception e) {
                    DefaultOptions.logger.error("Error loading default key bindings", (Throwable)e);
                }
            }
        }
        if ((knownKeysFile = new File(DefaultOptions.getMinecraftDataDir(), "knownkeys.txt")).exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(knownKeysFile));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.isEmpty()) continue;
                    knownKeys.add(line);
                }
            }
            catch (IOException e) {
                DefaultOptions.logger.error("Error loading known key bindings", (Throwable)e);
            }
        }
        for (KeyMapping keyMapping : Minecraft.m_91087_().f_91066_.f_92059_) {
            if (!defaultKeys.containsKey(keyMapping.m_90860_())) continue;
            DefaultKeyMapping defaultKeyMapping = defaultKeys.get(keyMapping.m_90860_());
            ((KeyMappingAccessor)keyMapping).setDefaultKey(defaultKeyMapping.input);
            PlatformBindings.INSTANCE.setDefaultKeyModifier(keyMapping, defaultKeyMapping.modifier);
            if (knownKeys.contains(keyMapping.m_90860_())) continue;
            KeyModifier defaultKeyModifier = PlatformBindings.INSTANCE.getDefaultKeyModifier(keyMapping);
            PlatformBindings.INSTANCE.setKeyModifier(keyMapping, defaultKeyModifier);
            keyMapping.m_90848_(keyMapping.m_90861_());
            knownKeys.add(keyMapping.m_90860_());
        }
        KeyMapping.m_90854_();
        try (PrintWriter writer = new PrintWriter(new FileWriter(new File(DefaultOptions.getMinecraftDataDir(), "knownkeys.txt")));){
            for (String key : knownKeys) {
                writer.println(key);
            }
        }
        catch (IOException e) {
            DefaultOptions.logger.error("Error saving known key bindings", (Throwable)e);
        }
    }
}

