/*
 * Decompiled with CFR 0.152.
 */
package portb.biggerstacks.util;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.PacketDistributor;
import org.slf4j.Logger;
import portb.biggerstacks.Constants;
import portb.biggerstacks.net.ClientboundConfigureScreenOpenPacket;
import portb.biggerstacks.net.PacketHandler;
import portb.configlib.template.ConfigTemplate;
import portb.configlib.template.TemplateOptions;

public class ConfigCommand {
    public static final Logger LOGGER = LogUtils.getLogger();

    public static void register(RegisterCommandsEvent event) {
        LiteralArgumentBuilder cmd = (LiteralArgumentBuilder)Commands.m_82127_((String)"biggerstacks").then(Commands.m_82127_((String)"quicksetup").executes(context -> {
            try {
                boolean hasCustomExistingFile = false;
                TemplateOptions template = new TemplateOptions(64, 1, 1);
                if (Files.exists(Constants.RULESET_FILE, new LinkOption[0])) {
                    try {
                        template = ConfigTemplate.readParametersFromTemplate((String)new String(Files.readAllBytes(Constants.RULESET_FILE), StandardCharsets.UTF_8));
                    }
                    catch (Throwable e) {
                        LOGGER.debug("Error reading template file", e);
                        hasCustomExistingFile = true;
                    }
                }
                ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
                PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientboundConfigureScreenOpenPacket(hasCustomExistingFile, template.getNormalStackLimit(), template.getPotionStackLimit(), template.getEnchBookLimit()));
            }
            catch (CommandSyntaxException e) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Command must be run by a player"));
                return 0;
            }
            return 1;
        }));
        if (FMLEnvironment.dist.isDedicatedServer()) {
            cmd.requires(commandSourceStack -> commandSourceStack.m_6761_(4));
        }
        event.getDispatcher().register(cmd);
    }
}

