/*
 * Decompiled with CFR 0.152.
 */
package portb.biggerstacks.net;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkEvent;
import portb.biggerstacks.Constants;
import portb.biggerstacks.config.ClientConfig;
import portb.biggerstacks.net.GenericTemplateOptionsPacket;
import portb.configlib.template.ConfigTemplate;
import portb.configlib.template.TemplateOptions;
import portb.configlib.xml.Condition;
import portb.configlib.xml.Operator;
import portb.configlib.xml.OrBlock;
import portb.configlib.xml.Property;
import portb.configlib.xml.Rule;

public class ServerboundCreateConfigTemplatePacket
extends GenericTemplateOptionsPacket {
    public ServerboundCreateConfigTemplatePacket(int normalStackLimit, int potionsStackLimit, int enchantedBooksStackLimit) {
        super(normalStackLimit, potionsStackLimit, enchantedBooksStackLimit);
    }

    public ServerboundCreateConfigTemplatePacket(FriendlyByteBuf buf) {
        super(buf);
    }

    static void handleCreateConfigTemplate(ServerboundCreateConfigTemplatePacket serverboundCreateConfigTemplatePacket, Supplier<NetworkEvent.Context> contextSupplier) {
        ServerPlayer sender;
        if (FMLEnvironment.dist.isDedicatedServer() && ((sender = contextSupplier.get().getSender()) == null || !sender.m_20310_(4))) {
            return;
        }
        ConfigTemplate template = ConfigTemplate.generateTemplate((TemplateOptions)serverboundCreateConfigTemplatePacket);
        if (ModList.get().isLoaded("ic2")) {
            template.getRules().add(new Rule(Arrays.asList(new Condition(Property.MOD_ID, Operator.EQUALS, (Object)"ic2"), new OrBlock(Arrays.asList(new Condition(Property.ID, Operator.STRING_STARTS_WITH, (Object)"ic2:upgrade"), new Condition(Property.ID, Operator.STRING_ENDS_WITH, (Object)"pad_upgrade"), new Condition(Property.ID, Operator.STRING_ENDS_WITH, (Object)"upgrade_kit")))), 64));
        }
        try {
            if (FMLEnvironment.dist.isClient()) {
                ClientConfig.stfuWarning.set((Object)true);
            }
            Files.writeString(Constants.RULESET_FILE, (CharSequence)template.toXML(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void encode(FriendlyByteBuf buf) {
        super.encode(buf);
    }
}

