/*
 * Decompiled with CFR 0.152.
 */
package portb.biggerstacks.mixin.client;

import java.nio.file.Path;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.WorldSelectionList;
import net.minecraftforge.fml.loading.FMLPaths;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import portb.biggerstacks.config.ClientConfig;
import portb.biggerstacks.config.ServerConfig;
import portb.biggerstacks.gui.HighStackSizeWarning;
import portb.biggerstacks.mixin.client.WorldSelectionList$WorldListEntryInvoker;
import portb.configlib.ConfigLib;

@Mixin(value={WorldSelectionList.WorldListEntry.class})
public class WorldSelectionListMixin {
    @Inject(method={"loadWorld"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/worldselection/WorldSelectionList$WorldListEntry;queueLoadScreen()V")}, cancellable=true)
    private void showWarningBeforeWorldLoad(CallbackInfo ci) {
        if (!((Boolean)ClientConfig.stfuWarning.get()).booleanValue()) {
            int configMax = (Integer)ServerConfig.LOCAL_INSTANCE.maxStackCount.get();
            int actualMax = ConfigLib.readRuleset((Path)FMLPaths.CONFIGDIR.get().resolve("biggerstacks-rules.xml")).getMaxStacksize();
            if (configMax != 1 && actualMax > configMax) {
                ci.cancel();
                HighStackSizeWarning.createWarningScreen(actualMax, () -> {
                    WorldSelectionList$WorldListEntryInvoker invoker = (WorldSelectionList$WorldListEntryInvoker)((Object)this);
                    invoker.invokeQueueLoadScreen();
                    invoker.getMinecraft().m_231466_().m_233133_((Screen)invoker.accessScreen(), invoker.getSummary().m_78358_());
                });
            }
        }
    }
}

