/*
 * Decompiled with CFR 0.152.
 */
package jackiecrazy.armorcurve.mixin;

import jackiecrazy.armorcurve.CurveConfig;
import java.math.BigDecimal;
import net.minecraft.world.damagesource.CombatRules;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CombatRules.class})
public class DamageCalculatorMixin {
    @Inject(cancellable=true, at={@At(value="HEAD")}, method={"getDamageAfterAbsorb(FFF)F"})
    private static void getDamageLeft(float damage, float armor, float armorToughness, CallbackInfoReturnable<Float> info) {
        if (!(Float.isFinite(damage) && Float.isFinite(armor) && Float.isFinite(armorToughness))) {
            return;
        }
        BigDecimal ret = CurveConfig.first.with("damage", new BigDecimal(damage)).and("armor", new BigDecimal(armor)).and("toughness", new BigDecimal(armorToughness)).eval();
        ret = CurveConfig.second.with("damage", ret).and("armor", new BigDecimal(armor)).and("toughness", new BigDecimal(armorToughness)).eval();
        info.setReturnValue((Object)Float.valueOf(ret.floatValue()));
    }

    @Inject(cancellable=true, at={@At(value="HEAD")}, method={"getDamageAfterMagicAbsorb(FF)F"})
    private static void getInflictedDamage(float damage, float prot, CallbackInfoReturnable<Float> info) {
        if (!Float.isFinite(damage) || !Float.isFinite(prot)) {
            return;
        }
        BigDecimal ret = CurveConfig.enchants.with("damage", new BigDecimal(damage)).and("enchant", new BigDecimal(prot)).eval();
        info.setReturnValue((Object)Float.valueOf(ret.floatValue()));
    }
}

