/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.weaponinnate;

import java.util.List;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import reascer.wom.gameasset.WOMAnimations;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.weaponinnate.WeaponInnateSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;

public class CharybdisSkill
extends WeaponInnateSkill {
    public CharybdisSkill(Skill.Builder builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        if (!container.getExecuter().isLogicalClient()) {
            this.setConsumption(container, 6.0f);
            this.setConsumptionSynchronize((ServerPlayerPatch)container.getExecuter(), 6.0f);
        }
        container.setResource(6.0f);
    }

    public void executeOnServer(ServerPlayerPatch executer, FriendlyByteBuf args) {
        if (executer.consumeStamina(this.consumption) || ((ServerPlayer)executer.getOriginal()).m_7500_()) {
            executer.playAnimationSynchronized(WOMAnimations.STAFF_CHARYBDIS, 0.0f);
            super.executeOnServer(executer, args);
        }
    }

    public List<Component> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerPatch<?> playerCap) {
        List list = super.getTooltipOnItem(itemStack, cap, playerCap);
        this.generateTooltipforPhase(list, itemStack, cap, playerCap, (Map)this.properties.get(0), "Each Strike:");
        return list;
    }

    public boolean isExecutableState(PlayerPatch<?> executer) {
        executer.updateEntityState();
        EntityState playerState = executer.getEntityState();
        return !((Player)executer.getOriginal()).m_21255_() && executer.currentLivingMotion != LivingMotions.FALL && playerState.canUseSkill() && executer.getEntityState().canBasicAttack();
    }

    public WeaponInnateSkill registerPropertiesToAnimation() {
        return this;
    }

    public void updateContainer(SkillContainer container) {
        if (!container.getExecuter().isLogicalClient()) {
            this.setConsumption(container, 6.0f);
            this.setConsumptionSynchronize((ServerPlayerPatch)container.getExecuter(), 6.0f);
        }
        container.setResource(6.0f);
        container.deactivate();
    }
}

