/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.weaponinnate;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import reascer.wom.gameasset.WOMAnimations;
import yesman.epicfight.gameasset.EpicFightSkills;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.weaponinnate.WeaponInnateSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.damagesource.EpicFightEntityDamageSource;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.effect.EpicFightMobEffects;
import yesman.epicfight.world.entity.eventlistener.PlayerEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;
import yesman.epicfight.world.entity.eventlistener.SkillConsumeEvent;

public class AgonyPlungeSkill
extends WeaponInnateSkill {
    private static final UUID EVENT_UUID = UUID.fromString("c7a0ee46-56b3-4008-9fba-d2594b1e2676");
    public static final SkillDataManager.SkillDataKey<Boolean> PLUNGING = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.BOOLEAN);
    public static final SkillDataManager.SkillDataKey<Integer> STACK = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.INTEGER);

    public AgonyPlungeSkill(Skill.Builder<?> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        container.getDataManager().registerData(PLUNGING);
        container.getDataManager().registerData(STACK);
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.MODIFY_DAMAGE_EVENT, EVENT_UUID, event -> {
            if (((Boolean)container.getDataManager().getDataValue(PLUNGING)).booleanValue() && event.getDamage() > 1.0f && (Integer)container.getDataManager().getDataValue(STACK) > 0) {
                float attackDamage = event.getDamage();
                event.setDamage(attackDamage * (float)((Integer)container.getDataManager().getDataValue(STACK)).intValue());
                ((Player)container.getExecuter().getOriginal()).m_183634_();
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID, event -> {
            if (((Boolean)container.getDataManager().getDataValue(PLUNGING)).booleanValue()) {
                container.getDataManager().setData(PLUNGING, (Object)false);
                container.getDataManager().setData(STACK, (Object)0);
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.ATTACK_ANIMATION_END_EVENT, EVENT_UUID, event -> {
            if (((Boolean)container.getDataManager().getDataValue(PLUNGING)).booleanValue()) {
                container.getDataManager().setData(PLUNGING, (Object)false);
                container.getDataManager().setData(STACK, (Object)0);
            }
        });
    }

    public void onRemoved(SkillContainer container) {
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.MODIFY_DAMAGE_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.ATTACK_ANIMATION_END_EVENT, EVENT_UUID);
    }

    public void executeOnServer(ServerPlayerPatch executer, FriendlyByteBuf args) {
        if (executer.getSkill(EpicFightSkills.HYPERVITALITY) == null) {
            executer.playAnimationSynchronized(WOMAnimations.AGONY_PLUNGE_FORWARD, 0.0f);
        } else {
            executer.playAnimationSynchronized(WOMAnimations.AGONY_PLUNGE_FORWARD_X, 0.0f);
        }
        executer.getSkill((Skill)this).getDataManager().setDataSync(PLUNGING, (Object)true, (ServerPlayer)executer.getOriginal());
        if (executer.getSkill(EpicFightSkills.HYPERVITALITY) == null) {
            executer.getSkill((Skill)this).getDataManager().setDataSync(STACK, (Object)executer.getSkill((Skill)this).getStack(), (ServerPlayer)executer.getOriginal());
        } else {
            executer.getSkill((Skill)this).getDataManager().setDataSync(STACK, (Object)1, (ServerPlayer)executer.getOriginal());
        }
        if (!((ServerPlayer)executer.getOriginal()).m_7500_()) {
            SkillConsumeEvent event = new SkillConsumeEvent((PlayerPatch)executer, (Skill)this, this.resource, true);
            executer.getEventListener().triggerEvents(PlayerEventListener.EventType.SKILL_CONSUME_EVENT, (PlayerEvent)event);
            if (!event.isCanceled()) {
                event.getResourceType().consumer.consume((Skill)this, executer, event.getAmount());
            }
            ((ServerPlayer)executer.getOriginal()).f_19853_.m_6263_(null, ((ServerPlayer)executer.getOriginal()).f_19854_, ((ServerPlayer)executer.getOriginal()).f_19855_, ((ServerPlayer)executer.getOriginal()).f_19856_, SoundEvents.f_12323_, ((ServerPlayer)executer.getOriginal()).m_5720_(), 1.0f, 1.0f);
            DamageSource damage = new EpicFightEntityDamageSource("agonized_to_death", executer.getOriginal(), WOMAnimations.AGONY_PLUNGE_FORWARD).setStunType(StunType.NONE).cast().m_19380_().m_19382_();
            ((ServerPlayer)executer.getOriginal()).m_6469_(damage, ((ServerPlayer)executer.getOriginal()).m_21223_() * (0.4f - 0.1f * (float)EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44983_, (LivingEntity)((LivingEntity)executer.getOriginal()))));
        }
        if (executer.getSkill(EpicFightSkills.HYPERVITALITY) == null && !((ServerPlayer)executer.getOriginal()).m_7500_()) {
            this.setStackSynchronize(executer, 0);
        }
        executer.getSkill((Skill)this).activate();
    }

    public List<Component> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerPatch<?> playerCap) {
        List list = super.getTooltipOnItem(itemStack, cap, playerCap);
        this.generateTooltipforPhase(list, itemStack, cap, playerCap, (Map)this.properties.get(0), "Jump :");
        this.generateTooltipforPhase(list, itemStack, cap, playerCap, (Map)this.properties.get(1), "Plunge :");
        return list;
    }

    public WeaponInnateSkill registerPropertiesToAnimation() {
        return this;
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        if (((Boolean)container.getDataManager().getDataValue(PLUNGING)).booleanValue()) {
            ((Player)container.getExecuter().getOriginal()).m_7292_(new MobEffectInstance((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get(), 5, 0, true, false, false));
            ((Player)container.getExecuter().getOriginal()).m_183634_();
        }
    }
}

