/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.passive;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.UUID;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.effect.EpicFightMobEffects;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class PainAnticipationSkill
extends PassiveSkill {
    private static final UUID EVENT_UUID = UUID.fromString("8f274f40-ea63-11ec-8fea-0242ac120002");
    protected static final SkillDataManager.SkillDataKey<Integer> TIMER = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.INTEGER);
    protected static final SkillDataManager.SkillDataKey<Boolean> ACTIVE = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.BOOLEAN);
    protected static final SkillDataManager.SkillDataKey<Integer> DUREE = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.INTEGER);
    protected int maxtimer = 40;
    protected int maxduree = 40;
    protected float damage_reduction = 0.6f;

    public PainAnticipationSkill(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        container.getDataManager().registerData(TIMER);
        container.getDataManager().registerData(ACTIVE);
        container.getDataManager().registerData(DUREE);
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.HURT_EVENT_POST, EVENT_UUID, event -> {
            if ((Integer)container.getDataManager().getDataValue(TIMER) == 0 || ((Boolean)container.getDataManager().getDataValue(ACTIVE)).booleanValue()) {
                ((EpicFightDamageSource)event.getDamageSource()).setStunType(StunType.NONE);
                event.setAmount(event.getAmount() * this.damage_reduction);
                ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).f_19853_.m_6263_(null, ((Player)container.getExecuter().getOriginal()).m_20185_(), ((Player)container.getExecuter().getOriginal()).m_20186_(), ((Player)container.getExecuter().getOriginal()).m_20189_(), SoundEvents.f_144179_, ((Player)container.getExecuter().getOriginal()).m_5720_(), 2.0f, 1.0f);
                ((ServerLevel)((Player)container.getExecuter().getOriginal()).f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123762_, ((Player)container.getExecuter().getOriginal()).m_20185_() - 0.2, ((Player)container.getExecuter().getOriginal()).m_20186_() + 1.3, ((Player)container.getExecuter().getOriginal()).m_20189_() - 0.2, 10, 0.6, 0.8, 0.6, (double)0.1f);
                container.getDataManager().setDataSync(ACTIVE, (Object)true, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID, event -> {
            if ((Integer)container.getDataManager().getDataValue(TIMER) == 0) {
                ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).f_19853_.m_6263_(null, ((Player)container.getExecuter().getOriginal()).m_20185_(), ((Player)container.getExecuter().getOriginal()).m_20186_(), ((Player)container.getExecuter().getOriginal()).m_20189_(), SoundEvents.f_144179_, ((Player)container.getExecuter().getOriginal()).m_5720_(), 2.0f, 1.0f);
                ((ServerLevel)((Player)container.getExecuter().getOriginal()).f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123762_, ((Player)container.getExecuter().getOriginal()).m_20185_() - 0.2, ((Player)container.getExecuter().getOriginal()).m_20186_() + 1.3, ((Player)container.getExecuter().getOriginal()).m_20189_() - 0.2, 10, 0.6, 0.8, 0.6, (double)0.05f);
                container.getDataManager().setDataSync(ACTIVE, (Object)true, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
            }
            container.getDataManager().setDataSync(TIMER, (Object)this.maxtimer, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
        });
    }

    public void onRemoved(SkillContainer container) {
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.HURT_EVENT_POST, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, PoseStack poseStack, float x, float y) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, (double)gui.getSlidingProgression(), 0.0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getSkillTexture());
        if (((Boolean)container.getDataManager().getDataValue(ACTIVE)).booleanValue()) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiComponent.m_93160_((PoseStack)poseStack, (int)((int)x), (int)((int)y), (int)24, (int)24, (float)0.0f, (float)0.0f, (int)1, (int)1, (int)1, (int)1);
            gui.font.m_92750_(poseStack, String.valueOf((Integer)container.getDataManager().getDataValue(DUREE) / 20 + 1), x + 7.0f, y + 13.0f, 0xFFFFFF);
        } else {
            if ((Integer)container.getDataManager().getDataValue(TIMER) > 0) {
                RenderSystem.m_157429_((float)0.5f, (float)0.5f, (float)0.5f, (float)0.5f);
            } else {
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            GuiComponent.m_93160_((PoseStack)poseStack, (int)((int)x), (int)((int)y), (int)24, (int)24, (float)0.0f, (float)0.0f, (int)1, (int)1, (int)1, (int)1);
            if ((Integer)container.getDataManager().getDataValue(TIMER) > 0) {
                gui.font.m_92750_(poseStack, String.valueOf((Integer)container.getDataManager().getDataValue(TIMER) / 20 + 1), x + 7.0f, y + 13.0f, 0xFFFFFF);
            }
        }
        poseStack.m_85849_();
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        if ((Integer)container.getDataManager().getDataValue(TIMER) > 0 && (Integer)container.getDataManager().getDataValue(DUREE) == 0 && !container.getExecuter().isLogicalClient()) {
            container.getDataManager().setDataSync(TIMER, (Object)((Integer)container.getDataManager().getDataValue(TIMER) - 1), (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            if ((Integer)container.getDataManager().getDataValue(TIMER) == 0) {
                container.getDataManager().setDataSync(DUREE, (Object)this.maxduree, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                ((ServerLevel)((Player)container.getExecuter().getOriginal()).f_19853_).m_6263_(null, ((Player)container.getExecuter().getOriginal()).m_20185_(), ((Player)container.getExecuter().getOriginal()).m_20186_(), ((Player)container.getExecuter().getOriginal()).m_20189_(), SoundEvents.f_144179_, ((Player)container.getExecuter().getOriginal()).m_5720_(), 2.0f, 2.0f);
                ((ServerLevel)((Player)container.getExecuter().getOriginal()).f_19853_).m_8767_((ParticleOptions)DustParticleOptions.f_123656_, ((Player)container.getExecuter().getOriginal()).m_20185_() - 0.2, ((Player)container.getExecuter().getOriginal()).m_20186_() + 1.3, ((Player)container.getExecuter().getOriginal()).m_20189_() - 0.2, 30, 0.6, 0.8, 0.6, 0.05);
            }
        }
        if (((Boolean)container.getDataManager().getDataValue(ACTIVE)).booleanValue()) {
            ((Player)container.getExecuter().getOriginal()).m_7292_(new MobEffectInstance((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get(), 5, 0, true, false, false));
            if ((Integer)container.getDataManager().getDataValue(DUREE) > 0) {
                if (!container.getExecuter().isLogicalClient()) {
                    container.getDataManager().setDataSync(DUREE, (Object)((Integer)container.getDataManager().getDataValue(DUREE) - 1), (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                    ((ServerLevel)((Player)container.getExecuter().getOriginal()).f_19853_).m_8767_((ParticleOptions)DustParticleOptions.f_123656_, ((Player)container.getExecuter().getOriginal()).m_20185_() - 0.2, ((Player)container.getExecuter().getOriginal()).m_20186_() + 1.3, ((Player)container.getExecuter().getOriginal()).m_20189_() - 0.2, 4, 0.6, 0.8, 0.6, 0.05);
                    if ((Integer)container.getDataManager().getDataValue(DUREE) == 0) {
                        ((ServerLevel)((Player)container.getExecuter().getOriginal()).f_19853_).m_6263_(null, ((Player)container.getExecuter().getOriginal()).m_20185_(), ((Player)container.getExecuter().getOriginal()).m_20186_(), ((Player)container.getExecuter().getOriginal()).m_20189_(), SoundEvents.f_144179_, ((Player)container.getExecuter().getOriginal()).m_5720_(), 2.0f, 0.5f);
                        container.getDataManager().setDataSync(ACTIVE, (Object)false, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                        container.getDataManager().setDataSync(TIMER, (Object)this.maxtimer, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                    }
                }
            } else if (!container.getExecuter().isLogicalClient()) {
                container.getDataManager().setDataSync(ACTIVE, (Object)false, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                container.getDataManager().setDataSync(TIMER, (Object)this.maxtimer, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            }
        }
    }
}

