/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.passive;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.passive.PassiveSkill;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class HeartShieldSkill
extends PassiveSkill {
    public static final SkillDataManager.SkillDataKey<Integer> MAX_SHIELD = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.INTEGER);
    public static final SkillDataManager.SkillDataKey<Integer> RECOVERY_COOLDOWN = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.INTEGER);
    public static final SkillDataManager.SkillDataKey<Integer> RECOVERY_RATE = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.INTEGER);
    private static final UUID EVENT_UUID = UUID.fromString("42580b91-53a6-4d7f-92b4-487aa585cd0b");
    private float recovery_delay;
    private float recovery_rate;

    public HeartShieldSkill(Skill.Builder<? extends Skill> builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getDataManager().registerData(MAX_SHIELD);
        container.getDataManager().registerData(RECOVERY_COOLDOWN);
        container.getDataManager().registerData(RECOVERY_RATE);
        this.recovery_delay = 5.0f;
        this.recovery_rate = 2.0f;
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID, event -> container.getDataManager().setDataSync(RECOVERY_COOLDOWN, (Object)100, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal()));
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        ((Player)container.getExecuter().getOriginal()).m_7911_(0.0f);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        return (Integer)container.getDataManager().getDataValue(RECOVERY_COOLDOWN) > 0 || ((Player)container.getExecuter().getOriginal()).m_6103_() < (float)((Integer)container.getDataManager().getDataValue(MAX_SHIELD)).intValue();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, PoseStack poseStack, float x, float y) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, (double)gui.getSlidingProgression(), 0.0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getSkillTexture());
        if ((Integer)container.getDataManager().getDataValue(RECOVERY_COOLDOWN) > 0) {
            RenderSystem.m_157429_((float)0.5f, (float)0.5f, (float)0.5f, (float)0.5f);
        } else {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        GuiComponent.m_93160_((PoseStack)poseStack, (int)((int)x), (int)((int)y), (int)24, (int)24, (float)0.0f, (float)0.0f, (int)1, (int)1, (int)1, (int)1);
        if ((Integer)container.getDataManager().getDataValue(RECOVERY_COOLDOWN) > 0) {
            gui.font.m_92750_(poseStack, String.valueOf((Integer)container.getDataManager().getDataValue(RECOVERY_COOLDOWN) / 20 + 1), x + 7.0f, y + 13.0f, 0xFFFFFF);
        }
        poseStack.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgsOfScreen(List<Object> list) {
        list.add(String.format("%.1f", Float.valueOf(this.recovery_delay)));
        list.add(String.format("%.1f", Float.valueOf(this.recovery_rate)));
        return list;
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        int protection = 0;
        for (ItemStack ArmorPiece : ((Player)container.getExecuter().getOriginal()).m_6168_()) {
            protection += EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44965_, (ItemStack)ArmorPiece);
        }
        this.recovery_rate = (float)(40 / (1 + protection / 4)) / 20.0f;
        if (!container.getExecuter().isLogicalClient()) {
            container.getDataManager().setDataSync(MAX_SHIELD, (Object)20, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            if ((Integer)container.getDataManager().getDataValue(RECOVERY_COOLDOWN) > 0) {
                container.getDataManager().setDataSync(RECOVERY_COOLDOWN, (Object)((Integer)container.getDataManager().getDataValue(RECOVERY_COOLDOWN) - 1), (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            } else if (((Player)container.getExecuter().getOriginal()).m_6103_() < (float)((Integer)container.getDataManager().getDataValue(MAX_SHIELD)).intValue()) {
                if ((Integer)container.getDataManager().getDataValue(RECOVERY_RATE) > 0) {
                    container.getDataManager().setDataSync(RECOVERY_RATE, (Object)((Integer)container.getDataManager().getDataValue(RECOVERY_RATE) - 1), (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                } else {
                    container.getDataManager().setDataSync(RECOVERY_RATE, (Object)(40 / (1 + protection / 4)), (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                    if (((Player)container.getExecuter().getOriginal()).m_6103_() + 1.0f >= (float)((Integer)container.getDataManager().getDataValue(MAX_SHIELD)).intValue()) {
                        ((Player)container.getExecuter().getOriginal()).m_7911_((float)((Integer)container.getDataManager().getDataValue(MAX_SHIELD)).intValue());
                    } else {
                        ((Player)container.getExecuter().getOriginal()).m_7911_(((Player)container.getExecuter().getOriginal()).m_6103_() + 1.0f);
                    }
                }
            }
        }
    }
}

