/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.guard;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import reascer.wom.gameasset.WOMAnimations;
import reascer.wom.gameasset.WOMColliders;
import reascer.wom.gameasset.WOMSkills;
import reascer.wom.world.capabilities.item.WOMWeaponCategories;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.client.gui.BattleModeGui;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.ColliderPreset;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.guard.GuardSkill;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.eventlistener.HurtEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class VengefulParry
extends GuardSkill {
    private static final UUID EVENT_UUID = UUID.fromString("802e2116-02fa-4746-937d-a89429a84113");
    public static final SkillDataManager.SkillDataKey<Float> CONSUMPTION_VALUE = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.FLOAT);
    private static final SkillDataManager.SkillDataKey<Integer> TIMER = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.INTEGER);
    private static final SkillDataManager.SkillDataKey<Integer> COOLDOWN = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.INTEGER);
    private static final SkillDataManager.SkillDataKey<Integer> VENGENCE_DURATION = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.INTEGER);
    private static final SkillDataManager.SkillDataKey<Integer> CHARGE = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.INTEGER);
    private static final SkillDataManager.SkillDataKey<Boolean> HOLDING_STANCE = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.BOOLEAN);

    public static GuardSkill.Builder createCounterAttackBuilder() {
        return GuardSkill.createGuardBuilder();
    }

    public VengefulParry(GuardSkill.Builder builder) {
        super(builder);
    }

    public void setPenalizer(float penalizer) {
        this.penalizer = penalizer;
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getDataManager().registerData(TIMER);
        container.getDataManager().registerData(COOLDOWN);
        container.getDataManager().registerData(VENGENCE_DURATION);
        container.getDataManager().registerData(CHARGE);
        container.getDataManager().registerData(HOLDING_STANCE);
        container.getDataManager().registerData(CONSUMPTION_VALUE);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.CLIENT_ITEM_USE_EVENT, GuardSkill.EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, GuardSkill.EVENT_UUID);
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID, event -> {
            boolean flag1;
            CapabilityItem itemCapability = ((ServerPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(InteractionHand.MAIN_HAND);
            boolean bl = flag1 = !((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_21255_() && ((ServerPlayerPatch)event.getPlayerPatch()).currentLivingMotion != LivingMotions.FALL && ((ServerPlayerPatch)event.getPlayerPatch()).getEntityState().canUseSkill() && ((ServerPlayerPatch)event.getPlayerPatch()).getEntityState().canBasicAttack();
            if (this.isHoldingWeaponAvailable(event.getPlayerPatch(), itemCapability, GuardSkill.BlockType.GUARD) && flag1 && ((ServerPlayerPatch)event.getPlayerPatch()).getStamina() > 0.0f && (Integer)container.getDataManager().getDataValue(TIMER) == 0 && (Integer)container.getDataManager().getDataValue(COOLDOWN) == 0) {
                StaticAnimation animation = switch (new Random().nextInt() % 3) {
                    case 0 -> Animations.SWORD_GUARD_ACTIVE_HIT1;
                    case 1 -> Animations.SWORD_GUARD_ACTIVE_HIT2;
                    case 2 -> Animations.SWORD_GUARD_ACTIVE_HIT3;
                    default -> Animations.SWORD_GUARD_ACTIVE_HIT1;
                };
                if (itemCapability.getStyle((LivingEntityPatch)event.getPlayerPatch()) == CapabilityItem.Styles.TWO_HAND) {
                    StaticAnimation staticAnimation = animation = new Random().nextBoolean() ? Animations.LONGSWORD_GUARD_ACTIVE_HIT1 : Animations.LONGSWORD_GUARD_ACTIVE_HIT2;
                }
                if (itemCapability.getWeaponCollider() == ColliderPreset.SPEAR) {
                    animation = Animations.SPEAR_GUARD_HIT;
                }
                if (itemCapability.getWeaponCollider() == ColliderPreset.UCHIGATANA) {
                    animation = Animations.UCHIGATANA_GUARD_HIT;
                }
                if (itemCapability.getWeaponCollider() == WOMColliders.STAFF) {
                    animation = Animations.SPEAR_GUARD_HIT;
                }
                float convert = -0.05f;
                if (itemCapability.getWeaponCollider() == WOMColliders.AGONY) {
                    animation = WOMAnimations.AGONY_GUARD_HIT_1;
                }
                if (itemCapability.getWeaponCollider() == WOMColliders.RUINE) {
                    animation = Animations.LONGSWORD_GUARD_HIT;
                }
                if (itemCapability.getWeaponCollider() == WOMColliders.KATANA) {
                    animation = WOMAnimations.KATANA_GUARD_HIT;
                    convert = -0.15f;
                }
                if (itemCapability.getWeaponCollider() == WOMColliders.HERSCHER && itemCapability.getStyle((LivingEntityPatch)event.getPlayerPatch()) == CapabilityItem.Styles.OCHS) {
                    animation = WOMAnimations.HERRSCHER_GUARD_PARRY;
                }
                if (itemCapability.getWeaponCollider() == WOMColliders.MOONLESS) {
                    animation = WOMAnimations.MOONLESS_GUARD_HIT_1;
                }
                if (!((ServerPlayerPatch)event.getPlayerPatch()).consumeStamina(8.0f)) {
                    ((ServerPlayerPatch)event.getPlayerPatch()).setStamina(0.0f);
                }
                ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).f_19853_.m_6263_(null, ((Player)container.getExecuter().getOriginal()).m_20185_(), ((Player)container.getExecuter().getOriginal()).m_20186_(), ((Player)container.getExecuter().getOriginal()).m_20189_(), (SoundEvent)EpicFightSounds.CLASH.get(), ((Player)container.getExecuter().getOriginal()).m_5720_(), 1.0f, 2.0f);
                ((ServerPlayerPatch)event.getPlayerPatch()).playAnimationSynchronized(animation, convert);
                ((ServerPlayerPatch)event.getPlayerPatch()).currentLivingMotion = LivingMotions.BLOCK;
                container.getDataManager().setDataSync(TIMER, (Object)40, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
                container.getDataManager().setDataSync(CHARGE, (Object)0, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
                container.getDataManager().setDataSync(HOLDING_STANCE, (Object)true, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
            } else if (this.isHoldingWeaponAvailable(event.getPlayerPatch(), itemCapability, GuardSkill.BlockType.GUARD) && ((ServerPlayerPatch)event.getPlayerPatch()).getEntityState().canBasicAttack() && (Integer)container.getDataManager().getDataValue(TIMER) == 0) {
                ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).f_19853_.m_6263_(null, ((Player)container.getExecuter().getOriginal()).m_20185_(), ((Player)container.getExecuter().getOriginal()).m_20186_(), ((Player)container.getExecuter().getOriginal()).m_20189_(), SoundEvents.f_12031_, ((Player)container.getExecuter().getOriginal()).m_5720_(), 1.0f, 2.0f);
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.MODIFY_DAMAGE_EVENT, EVENT_UUID, event -> {
            if ((Integer)container.getDataManager().getDataValue(CHARGE) > 0) {
                event.setDamage((float)((Integer)container.getDataManager().getDataValue(CHARGE)).intValue());
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_POST, EVENT_UUID, event -> {
            if (event.getDamageSource().getAnimation() instanceof AttackAnimation && (Integer)container.getDataManager().getDataValue(CHARGE) > 0) {
                AnimationPlayer player;
                float elapsedTime;
                ServerPlayerPatch entitypatch = (ServerPlayerPatch)event.getPlayerPatch();
                AttackAnimation anim = (AttackAnimation)event.getDamageSource().getAnimation();
                AttackAnimation.Phase phase = anim.getPhaseByTime(elapsedTime = (player = entitypatch.getAnimator().getPlayerFor((DynamicAnimation)event.getDamageSource().getAnimation())).getElapsedTime());
                if (phase == anim.phases[0]) {
                    ((ServerLevel)((Player)container.getExecuter().getOriginal()).f_19853_).m_6263_(null, event.getTarget().m_20185_(), event.getTarget().m_20186_(), event.getTarget().m_20189_(), SoundEvents.f_11835_, event.getTarget().m_5720_(), 2.0f, 0.5f);
                    for (int i = 0; i < (Integer)container.getDataManager().getDataValue(CHARGE) + 1; ++i) {
                        ((ServerLevel)((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).f_19853_).m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.0f, 0.0f, 0.0f), 1.0f), event.getTarget().m_20185_() + (double)((new Random().nextFloat() - 0.5f) * 3.0f), event.getTarget().m_20186_() + (double)(event.getTarget().m_20206_() / 2.0f), event.getTarget().m_20189_() + (double)((new Random().nextFloat() - 0.5f) * 3.0f), 2, 0.0, 0.0, 0.0, 0.0);
                    }
                    container.getDataManager().setDataSync(VENGENCE_DURATION, (Object)5, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                } else {
                    container.getDataManager().setDataSync(CHARGE, (Object)0, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                }
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID, event -> {
            CapabilityItem itemCapability = ((ServerPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_7655_());
            if (super.isHoldingWeaponAvailable(event.getPlayerPatch(), itemCapability, GuardSkill.BlockType.GUARD) && (Integer)container.getDataManager().getDataValue(TIMER) > 0) {
                float impact = 0.5f;
                float knockback = 0.25f;
                this.guard(container, itemCapability, (HurtEvent.Pre)event, knockback, impact, false);
            }
        }, 0);
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID, event -> {
            if ((Integer)container.getDataManager().getDataValue(TIMER) > 0) {
                container.getDataManager().setDataSync(COOLDOWN, (Object)20, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
            }
            container.getDataManager().setDataSync(TIMER, (Object)0, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.ATTACK_ANIMATION_END_EVENT, EVENT_UUID, event -> container.getDataManager().setDataSync(CHARGE, (Object)0, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal()));
    }

    public void onRemoved(SkillContainer container) {
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID, 0);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.ACTION_EVENT_SERVER, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.ATTACK_ANIMATION_END_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.MODIFY_DAMAGE_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.DEALT_DAMAGE_EVENT_POST, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.CLIENT_ITEM_USE_EVENT, EVENT_UUID);
        super.onRemoved(container);
    }

    public void guard(SkillContainer container, CapabilityItem itemCapability, HurtEvent.Pre event, float knockback, float impact, boolean advanced) {
        DamageSource damageSource;
        if (this.isHoldingWeaponAvailable(event.getPlayerPatch(), itemCapability, GuardSkill.BlockType.GUARD) && this.isBlockableSource(damageSource = (DamageSource)event.getDamageSource(), true)) {
            ((ServerPlayerPatch)event.getPlayerPatch()).playSound((SoundEvent)EpicFightSounds.CLASH.get(), -0.05f, 0.1f);
            ServerPlayer serveerPlayer = (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal();
            ((HitParticleType)EpicFightParticles.HIT_BLUNT.get()).spawnParticleWithArgument((ServerLevel)serveerPlayer.f_19853_, HitParticleType.FRONT_OF_EYES, HitParticleType.ZERO, (Entity)serveerPlayer, damageSource.m_7640_());
            container.getDataManager().setDataSync(CHARGE, (Object)((Integer)container.getDataManager().getDataValue(CHARGE) + (int)event.getAmount()), serveerPlayer);
            this.dealEvent(event.getPlayerPatch(), event, advanced);
            return;
        }
    }

    protected boolean isBlockableSource(DamageSource damageSource, boolean advanced) {
        return damageSource.m_19360_() && advanced || super.isBlockableSource(damageSource, false);
    }

    @Nullable
    protected StaticAnimation getGuardMotion(PlayerPatch<?> playerpatch, CapabilityItem itemCapability, GuardSkill.BlockType blockType) {
        if (blockType == GuardSkill.BlockType.GUARD) {
            if (itemCapability.getWeaponCollider() == WOMColliders.AGONY) {
                return new Random().nextBoolean() ? WOMAnimations.AGONY_GUARD_HIT_1 : WOMAnimations.AGONY_GUARD_HIT_2;
            }
            if (itemCapability.getWeaponCollider() == WOMColliders.KATANA) {
                return WOMAnimations.KATANA_GUARD_HIT;
            }
            if (itemCapability.getWeaponCollider() == WOMColliders.HERSCHER && itemCapability.getStyle(playerpatch) == CapabilityItem.Styles.OCHS) {
                return WOMAnimations.HERRSCHER_GUARD_HIT;
            }
            if (itemCapability.getWeaponCollider() == WOMColliders.MOONLESS) {
                switch (new Random().nextInt() % 3) {
                    case 0: {
                        return WOMAnimations.MOONLESS_GUARD_HIT_1;
                    }
                    case 1: {
                        return WOMAnimations.MOONLESS_GUARD_HIT_2;
                    }
                    case 2: {
                        return WOMAnimations.MOONLESS_GUARD_HIT_3;
                    }
                }
                return WOMAnimations.MOONLESS_GUARD_HIT_1;
            }
        }
        return super.getGuardMotion(playerpatch, itemCapability, blockType);
    }

    public Skill getPriorSkill() {
        return WOMSkills.PERFECT_BULWARK;
    }

    protected boolean isAdvancedGuard() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldDraw(SkillContainer container) {
        return (Integer)container.getDataManager().getDataValue(CHARGE) > 0 || (Integer)container.getDataManager().getDataValue(COOLDOWN) > 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawOnGui(BattleModeGui gui, SkillContainer container, PoseStack poseStack, float x, float y) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, (double)gui.getSlidingProgression(), 0.0);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.getSkillTexture());
        if ((Integer)container.getDataManager().getDataValue(COOLDOWN) > 0) {
            RenderSystem.m_157429_((float)0.5f, (float)0.5f, (float)0.5f, (float)0.5f);
        } else {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        GuiComponent.m_93160_((PoseStack)poseStack, (int)((int)x), (int)((int)y), (int)24, (int)24, (float)0.0f, (float)0.0f, (int)1, (int)1, (int)1, (int)1);
        String damage = String.valueOf(container.getDataManager().getDataValue(CHARGE));
        if ((Integer)container.getDataManager().getDataValue(CHARGE) == 0) {
            damage = "";
        }
        gui.font.m_92750_(poseStack, damage, x + 5.0f, y + 6.0f, 0xFFFFFF);
        poseStack.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgsOfScreen(List<Object> list) {
        list.clear();
        list.add(String.format("%s, %s, %s, %s, %s, %s, %s, %s", new Object[]{CapabilityItem.WeaponCategories.UCHIGATANA, CapabilityItem.WeaponCategories.LONGSWORD, CapabilityItem.WeaponCategories.SWORD, CapabilityItem.WeaponCategories.TACHI, CapabilityItem.WeaponCategories.SPEAR, WOMWeaponCategories.AGONY, WOMWeaponCategories.RUINE, WOMWeaponCategories.STAFF}).toLowerCase());
        return list;
    }

    public void updateContainer(SkillContainer container) {
        super.updateContainer(container);
        if (!container.getExecuter().isLogicalClient()) {
            if ((Integer)container.getDataManager().getDataValue(TIMER) > 0) {
                container.getDataManager().setDataSync(TIMER, (Object)((Integer)container.getDataManager().getDataValue(TIMER) - 1), (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                if ((Integer)container.getDataManager().getDataValue(TIMER) > 1) {
                    ((Player)container.getExecuter().getOriginal()).m_6672_(InteractionHand.MAIN_HAND);
                }
                if ((Integer)container.getDataManager().getDataValue(TIMER) > 5) {
                    ((Player)container.getExecuter().getOriginal()).m_7292_(new MobEffectInstance(MobEffects.f_19597_, 5, 10, true, false, false));
                }
                if ((Integer)container.getDataManager().getDataValue(TIMER) == 0 && ((Boolean)container.getDataManager().getDataValue(HOLDING_STANCE)).booleanValue()) {
                    container.getDataManager().setDataSync(COOLDOWN, (Object)40, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                    container.getDataManager().setDataSync(HOLDING_STANCE, (Object)false, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
                    ((Player)container.getExecuter().getOriginal()).m_5810_();
                }
            }
        } else {
            if ((Integer)container.getDataManager().getDataValue(TIMER) > 1) {
                ((Player)container.getExecuter().getOriginal()).m_6672_(InteractionHand.MAIN_HAND);
            }
            if ((Integer)container.getDataManager().getDataValue(TIMER) == 0 && ((Boolean)container.getDataManager().getDataValue(HOLDING_STANCE)).booleanValue()) {
                container.getDataManager().setData(HOLDING_STANCE, (Object)false);
                ((Player)container.getExecuter().getOriginal()).m_5810_();
            }
        }
        if ((Integer)container.getDataManager().getDataValue(COOLDOWN) > 0) {
            container.getDataManager().setData(COOLDOWN, (Object)((Integer)container.getDataManager().getDataValue(COOLDOWN) - 1));
        }
        if ((Integer)container.getDataManager().getDataValue(VENGENCE_DURATION) > 0) {
            if ((Integer)container.getDataManager().getDataValue(VENGENCE_DURATION) == 1 && !container.getExecuter().isLogicalClient()) {
                container.getDataManager().setDataSync(CHARGE, (Object)0, (ServerPlayer)((ServerPlayerPatch)container.getExecuter()).getOriginal());
            }
            container.getDataManager().setData(VENGENCE_DURATION, (Object)((Integer)container.getDataManager().getDataValue(VENGENCE_DURATION) - 1));
        }
    }
}

