/*
 * Decompiled with CFR 0.152.
 */
package reascer.wom.skill.guard;

import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import reascer.wom.gameasset.WOMAnimations;
import reascer.wom.gameasset.WOMColliders;
import reascer.wom.world.capabilities.item.WOMWeaponCategories;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.ColliderPreset;
import yesman.epicfight.gameasset.EpicFightSkills;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.skill.Skill;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.guard.GuardSkill;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.WeaponCategory;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.entity.eventlistener.HurtEvent;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class CounterAttack
extends GuardSkill {
    private static final UUID EVENT_UUID = UUID.fromString("ad8def54-20a4-4806-be95-ce3f5054627c");
    private static final SkillDataManager.SkillDataKey<Integer> LAST_ACTIVE = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.INTEGER);
    public static final SkillDataManager.SkillDataKey<Float> CONSUMPTION_VALUE = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.FLOAT);
    private static final SkillDataManager.SkillDataKey<Boolean> PARRYING = SkillDataManager.SkillDataKey.createDataKey((SkillDataManager.ValueType)SkillDataManager.ValueType.BOOLEAN);

    public static GuardSkill.Builder createCounterAttackBuilder() {
        return GuardSkill.createGuardBuilder().addAdvancedGuardMotion((WeaponCategory)CapabilityItem.WeaponCategories.SWORD, (itemCap, playerpatch) -> itemCap.getStyle((LivingEntityPatch)playerpatch) == CapabilityItem.Styles.ONE_HAND ? Animations.SWEEPING_EDGE : (itemCap.getStyle((LivingEntityPatch)playerpatch) == CapabilityItem.Styles.OCHS ? WOMAnimations.HERRSCHER_TRANE : Animations.SWORD_DUAL_AUTO3)).addAdvancedGuardMotion((WeaponCategory)CapabilityItem.WeaponCategories.LONGSWORD, (itemCap, playerpatch) -> Animations.LONGSWORD_DASH).addAdvancedGuardMotion((WeaponCategory)CapabilityItem.WeaponCategories.TACHI, (itemCap, playerpatch) -> Animations.RUSHING_TEMPO2).addAdvancedGuardMotion((WeaponCategory)CapabilityItem.WeaponCategories.SPEAR, (itemCap, playerpatch) -> Animations.GRASPING_SPIRAL_SECOND).addAdvancedGuardMotion((WeaponCategory)CapabilityItem.WeaponCategories.UCHIGATANA, (itemCap, playerpatch) -> Animations.UCHIGATANA_SHEATHING_DASH);
    }

    public CounterAttack(GuardSkill.Builder builder) {
        super(builder);
    }

    public void setPenalizer(float penalizer) {
        this.penalizer = penalizer;
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        container.getDataManager().registerData(LAST_ACTIVE);
        container.getDataManager().registerData(PARRYING);
        container.getDataManager().registerData(CONSUMPTION_VALUE);
        container.getDataManager().setData(PARRYING, (Object)false);
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.CLIENT_ITEM_USE_EVENT, EVENT_UUID, event -> {
            CapabilityItem itemCapability = ((LocalPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(InteractionHand.MAIN_HAND);
            if (this.isHoldingWeaponAvailable(event.getPlayerPatch(), itemCapability, GuardSkill.BlockType.GUARD)) {
                ((LocalPlayer)((LocalPlayerPatch)event.getPlayerPatch()).getOriginal()).m_6672_(InteractionHand.MAIN_HAND);
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID, event -> {
            CapabilityItem itemCapability = ((ServerPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(InteractionHand.MAIN_HAND);
            if (((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).f_19797_ - (Integer)container.getDataManager().getDataValue(LAST_ACTIVE) > 20) {
                container.getDataManager().setDataSync(PARRYING, (Object)false, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
            }
            if (!((Boolean)container.getDataManager().getDataValue(PARRYING)).booleanValue() && ((ServerPlayerPatch)event.getPlayerPatch()).getStamina() > 0.0f) {
                if (this.isHoldingWeaponAvailable(event.getPlayerPatch(), itemCapability, GuardSkill.BlockType.ADVANCED_GUARD) && ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).f_19797_ - (Integer)container.getDataManager().getDataValue(LAST_ACTIVE) > 20 && !((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_21255_() && ((ServerPlayerPatch)event.getPlayerPatch()).currentLivingMotion != LivingMotions.FALL && ((ServerPlayerPatch)event.getPlayerPatch()).getEntityState().canUseSkill() && ((ServerPlayerPatch)event.getPlayerPatch()).getEntityState().canBasicAttack()) {
                    StaticAnimation animation = switch (new Random().nextInt() % 3) {
                        case 0 -> Animations.SWORD_GUARD_ACTIVE_HIT1;
                        case 1 -> Animations.SWORD_GUARD_ACTIVE_HIT2;
                        case 2 -> Animations.SWORD_GUARD_ACTIVE_HIT3;
                        default -> Animations.SWORD_GUARD_ACTIVE_HIT1;
                    };
                    if (itemCapability.getStyle((LivingEntityPatch)event.getPlayerPatch()) == CapabilityItem.Styles.TWO_HAND) {
                        StaticAnimation staticAnimation = animation = new Random().nextBoolean() ? Animations.LONGSWORD_GUARD_ACTIVE_HIT1 : Animations.LONGSWORD_GUARD_ACTIVE_HIT2;
                    }
                    if (itemCapability.getWeaponCollider() == ColliderPreset.SPEAR) {
                        animation = Animations.SPEAR_GUARD_HIT;
                    }
                    if (itemCapability.getWeaponCollider() == ColliderPreset.UCHIGATANA) {
                        animation = Animations.UCHIGATANA_GUARD_HIT;
                    }
                    if (itemCapability.getWeaponCollider() == WOMColliders.STAFF) {
                        animation = Animations.SPEAR_GUARD_HIT;
                    }
                    float convert = -0.05f;
                    if (itemCapability.getWeaponCollider() == WOMColliders.AGONY) {
                        animation = WOMAnimations.AGONY_GUARD_HIT_1;
                    }
                    if (itemCapability.getWeaponCollider() == WOMColliders.RUINE) {
                        animation = Animations.LONGSWORD_GUARD_HIT;
                    }
                    if (itemCapability.getWeaponCollider() == WOMColliders.KATANA) {
                        animation = WOMAnimations.KATANA_GUARD_HIT;
                        convert = -0.15f;
                    }
                    if (itemCapability.getWeaponCollider() == WOMColliders.HERSCHER && itemCapability.getStyle((LivingEntityPatch)event.getPlayerPatch()) == CapabilityItem.Styles.OCHS) {
                        animation = WOMAnimations.HERRSCHER_GUARD_PARRY;
                    }
                    if (itemCapability.getWeaponCollider() == WOMColliders.MOONLESS) {
                        animation = WOMAnimations.MOONLESS_GUARD_HIT_1;
                    }
                    if (!((ServerPlayerPatch)event.getPlayerPatch()).consumeStamina(3.0f)) {
                        ((ServerPlayerPatch)event.getPlayerPatch()).setStamina(0.0f);
                    }
                    ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).f_19853_.m_6263_(null, ((Player)container.getExecuter().getOriginal()).m_20185_(), ((Player)container.getExecuter().getOriginal()).m_20186_(), ((Player)container.getExecuter().getOriginal()).m_20189_(), (SoundEvent)EpicFightSounds.CLASH.get(), ((Player)container.getExecuter().getOriginal()).m_5720_(), 1.0f, 2.0f);
                    ((ServerPlayerPatch)event.getPlayerPatch()).playAnimationSynchronized(animation, convert);
                    ((ServerPlayerPatch)event.getPlayerPatch()).currentLivingMotion = LivingMotions.BLOCK;
                    container.getDataManager().setDataSync(LAST_ACTIVE, (Object)((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).f_19797_, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
                    container.getDataManager().setDataSync(PARRYING, (Object)true, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
                } else if (this.isHoldingWeaponAvailable(event.getPlayerPatch(), itemCapability, GuardSkill.BlockType.ADVANCED_GUARD) && ((ServerPlayerPatch)event.getPlayerPatch()).getEntityState().canBasicAttack()) {
                    ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).f_19853_.m_6263_(null, ((Player)container.getExecuter().getOriginal()).m_20185_(), ((Player)container.getExecuter().getOriginal()).m_20186_(), ((Player)container.getExecuter().getOriginal()).m_20189_(), SoundEvents.f_12031_, ((Player)container.getExecuter().getOriginal()).m_5720_(), 1.0f, 2.0f);
                    container.getDataManager().setDataSync(LAST_ACTIVE, (Object)(((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).f_19797_ - 4), (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
                }
            }
            if (this.isHoldingWeaponAvailable(event.getPlayerPatch(), itemCapability, GuardSkill.BlockType.ADVANCED_GUARD) && (((ServerPlayerPatch)event.getPlayerPatch()).getStamina() == 0.0f || ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).f_19797_ - (Integer)container.getDataManager().getDataValue(LAST_ACTIVE) > 10) && ((ServerPlayerPatch)event.getPlayerPatch()).getEntityState().canBasicAttack()) {
                ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).f_19853_.m_6263_(null, ((Player)container.getExecuter().getOriginal()).m_20185_(), ((Player)container.getExecuter().getOriginal()).m_20186_(), ((Player)container.getExecuter().getOriginal()).m_20189_(), SoundEvents.f_12031_, ((Player)container.getExecuter().getOriginal()).m_5720_(), 1.0f, 2.0f);
                container.getDataManager().setDataSync(LAST_ACTIVE, (Object)(((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).f_19797_ - 4), (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
            }
            if (this.isHoldingWeaponAvailable(event.getPlayerPatch(), itemCapability, GuardSkill.BlockType.GUARD)) {
                ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_6672_(InteractionHand.MAIN_HAND);
            }
        });
        container.getExecuter().getEventListener().addEventListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID, event -> {
            CapabilityItem itemCapability = ((ServerPlayerPatch)event.getPlayerPatch()).getHoldingItemCapability(((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_7655_());
            if (((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).f_19797_ - (Integer)container.getDataManager().getDataValue(LAST_ACTIVE) < 10 && ((Boolean)container.getDataManager().getDataValue(PARRYING)).booleanValue()) {
                container.getDataManager().setDataSync(PARRYING, (Object)false, (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal());
                DamageSource damageSource = (DamageSource)event.getDamageSource();
                boolean isFront = false;
                Vec3 sourceLocation = damageSource.m_7270_();
                if (sourceLocation != null) {
                    Vec3 viewVector = ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20252_(1.0f);
                    Vec3 toSourceLocation = sourceLocation.m_82546_(((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20182_()).m_82541_();
                    if (toSourceLocation.m_82526_(viewVector) > 0.0) {
                        isFront = true;
                    }
                }
                if (isFront) {
                    float impact = 0.5f;
                    float knockback = 0.25f;
                    if (event.getDamageSource() instanceof EpicFightDamageSource) {
                        impact = ((EpicFightDamageSource)event.getDamageSource()).getImpact();
                        knockback += Math.min(impact * 0.1f, 1.0f);
                    }
                    this.guard(container, itemCapability, (HurtEvent.Pre)event, knockback, impact, false);
                }
            } else if (super.isHoldingWeaponAvailable(event.getPlayerPatch(), itemCapability, GuardSkill.BlockType.GUARD) && ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_6117_()) {
                DamageSource damageSource = (DamageSource)event.getDamageSource();
                boolean isFront = false;
                Vec3 sourceLocation = damageSource.m_7270_();
                if (sourceLocation != null) {
                    Vec3 viewVector = ((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20252_(1.0f);
                    Vec3 toSourceLocation = sourceLocation.m_82546_(((ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal()).m_20182_()).m_82541_();
                    if (toSourceLocation.m_82526_(viewVector) > 0.0) {
                        isFront = true;
                    }
                }
                if (isFront) {
                    float impact = 0.5f;
                    float knockback = 0.25f;
                    if (event.getDamageSource() instanceof EpicFightDamageSource) {
                        impact = ((EpicFightDamageSource)event.getDamageSource()).getImpact();
                        knockback += Math.min(impact * 0.1f, 1.0f);
                    }
                    super.guard(container, itemCapability, event, knockback, impact, false);
                }
            }
        }, 2);
    }

    public void onRemoved(SkillContainer container) {
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.HURT_EVENT_PRE, EVENT_UUID, 2);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.SERVER_ITEM_USE_EVENT, EVENT_UUID);
        container.getExecuter().getEventListener().removeListener(PlayerEventListener.EventType.CLIENT_ITEM_USE_EVENT, EVENT_UUID);
        super.onRemoved(container);
    }

    public void guard(SkillContainer container, CapabilityItem itemCapability, HurtEvent.Pre event, float knockback, float impact, boolean advanced) {
        DamageSource damageSource;
        if (this.isHoldingWeaponAvailable(event.getPlayerPatch(), itemCapability, GuardSkill.BlockType.ADVANCED_GUARD) && this.isBlockableSource(damageSource = (DamageSource)event.getDamageSource(), true)) {
            float convert;
            ServerPlayer playerentity = (ServerPlayer)((ServerPlayerPatch)event.getPlayerPatch()).getOriginal();
            int timing = playerentity.f_19797_ - (Integer)container.getDataManager().getDataValue(LAST_ACTIVE);
            boolean successParrying = timing < 10;
            float penalty = ((Float)container.getDataManager().getDataValue(PENALTY)).floatValue();
            ((ServerPlayerPatch)event.getPlayerPatch()).playSound((SoundEvent)EpicFightSounds.CLASH.get(), -0.05f, 0.1f);
            ((HitParticleType)EpicFightParticles.HIT_BLUNT.get()).spawnParticleWithArgument((ServerLevel)playerentity.f_19853_, HitParticleType.FRONT_OF_EYES, HitParticleType.ZERO, (Entity)playerentity, damageSource.m_7640_());
            if (successParrying) {
                penalty = 0.1f;
                knockback *= 0.4f;
            } else {
                container.getDataManager().setDataSync(PENALTY, (Object)Float.valueOf(penalty += this.getPenalizer(itemCapability)), playerentity);
            }
            if (damageSource.m_7640_() instanceof LivingEntity) {
                knockback += (float)EnchantmentHelper.m_44894_((LivingEntity)((LivingEntity)damageSource.m_7640_())) * 0.1f;
            }
            ((ServerPlayerPatch)event.getPlayerPatch()).knockBackEntity(damageSource.m_7640_().m_20182_(), knockback);
            if (container.getDataManager().getDataValue(CONSUMPTION_VALUE) != null && ((Float)container.getDataManager().getDataValue(CONSUMPTION_VALUE)).floatValue() != 0.0f) {
                penalty *= ((Float)container.getDataManager().getDataValue(CONSUMPTION_VALUE)).floatValue();
            }
            boolean enoughStamina = true;
            if (penalty > 0.0f) {
                enoughStamina = ((ServerPlayerPatch)event.getPlayerPatch()).consumeStamina(penalty * impact);
            } else {
                container.getDataManager().setDataSync(PENALTY, (Object)Float.valueOf(penalty), playerentity);
                enoughStamina = true;
            }
            GuardSkill.BlockType blockType = successParrying ? GuardSkill.BlockType.ADVANCED_GUARD : (enoughStamina ? GuardSkill.BlockType.GUARD : GuardSkill.BlockType.GUARD_BREAK);
            StaticAnimation animation = this.getGuardMotion(event.getPlayerPatch(), itemCapability, blockType);
            float f = timing <= 2 ? -0.15f : (convert = timing < 5 ? 0.0f : 0.15f);
            if (animation == Animations.RUSHING_TEMPO2) {
                float f2 = timing <= 2 ? -0.1f : (convert = timing < 5 ? 0.0f : 0.15f);
            }
            if (animation == Animations.SWEEPING_EDGE) {
                float f3 = timing <= 2 ? -0.1f : (convert = timing < 5 ? 0.0f : 0.15f);
            }
            if (animation != null) {
                ((ServerPlayerPatch)event.getPlayerPatch()).playAnimationSynchronized(animation, convert);
            }
            if (blockType == GuardSkill.BlockType.GUARD_BREAK) {
                ((ServerPlayerPatch)event.getPlayerPatch()).playSound((SoundEvent)EpicFightSounds.NEUTRALIZE_MOBS.get(), 3.0f, 0.0f, 0.1f);
            }
            this.dealEvent(event.getPlayerPatch(), event, advanced);
            return;
        }
    }

    protected boolean isBlockableSource(DamageSource damageSource, boolean advanced) {
        return damageSource.m_19360_() && advanced || super.isBlockableSource(damageSource, false);
    }

    @Nullable
    protected StaticAnimation getGuardMotion(PlayerPatch<?> playerpatch, CapabilityItem itemCapability, GuardSkill.BlockType blockType) {
        if (blockType == GuardSkill.BlockType.ADVANCED_GUARD) {
            if (itemCapability.getWeaponCollider() == WOMColliders.AGONY) {
                return WOMAnimations.AGONY_COUNTER;
            }
            if (itemCapability.getWeaponCollider() == WOMColliders.KATANA) {
                return WOMAnimations.KATANA_SHEATHED_COUNTER;
            }
            if (itemCapability.getWeaponCollider() == WOMColliders.RUINE) {
                return WOMAnimations.RUINE_COUNTER;
            }
            if (itemCapability.getWeaponCollider() == WOMColliders.MOONLESS) {
                return WOMAnimations.MOONLESS_REWINDER;
            }
            if (itemCapability.getWeaponCollider() == WOMColliders.STAFF) {
                return WOMAnimations.STAFF_DASH;
            }
            StaticAnimation motion = (StaticAnimation)this.getGuradMotionMap(blockType).getOrDefault(itemCapability.getWeaponCategory(), (a, b) -> null).apply(itemCapability, playerpatch);
            if (motion != null) {
                return motion;
            }
        }
        if (blockType == GuardSkill.BlockType.GUARD) {
            if (itemCapability.getWeaponCollider() == WOMColliders.AGONY) {
                return new Random().nextBoolean() ? WOMAnimations.AGONY_GUARD_HIT_1 : WOMAnimations.AGONY_GUARD_HIT_2;
            }
            if (itemCapability.getWeaponCollider() == WOMColliders.KATANA) {
                return WOMAnimations.KATANA_GUARD_HIT;
            }
            if (itemCapability.getWeaponCollider() == WOMColliders.MOONLESS) {
                switch (new Random().nextInt() % 3) {
                    case 0: {
                        return WOMAnimations.MOONLESS_GUARD_HIT_1;
                    }
                    case 1: {
                        return WOMAnimations.MOONLESS_GUARD_HIT_2;
                    }
                    case 2: {
                        return WOMAnimations.MOONLESS_GUARD_HIT_3;
                    }
                }
                return WOMAnimations.MOONLESS_GUARD_HIT_1;
            }
            if (itemCapability.getWeaponCollider() == WOMColliders.HERSCHER && itemCapability.getStyle(playerpatch) == CapabilityItem.Styles.OCHS) {
                return WOMAnimations.HERRSCHER_GUARD_HIT;
            }
        }
        return super.getGuardMotion(playerpatch, itemCapability, blockType);
    }

    public Skill getPriorSkill() {
        return EpicFightSkills.PARRYING;
    }

    protected boolean isAdvancedGuard() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Object> getTooltipArgsOfScreen(List<Object> list) {
        list.clear();
        list.add(String.format("%s, %s, %s, %s, %s, %s, %s, %s", new Object[]{CapabilityItem.WeaponCategories.UCHIGATANA, CapabilityItem.WeaponCategories.LONGSWORD, CapabilityItem.WeaponCategories.SWORD, CapabilityItem.WeaponCategories.TACHI, CapabilityItem.WeaponCategories.SPEAR, WOMWeaponCategories.AGONY, WOMWeaponCategories.RUINE, WOMWeaponCategories.STAFF}).toLowerCase());
        return list;
    }
}

