/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.harderspawners.util;

import com.mactso.harderspawners.config.MyConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Utility {
    static final int TWO_SECONDS = 40;
    private static final Logger LOGGER = LogManager.getLogger();

    public static void drawParticleBeam(BlockPos pos, ServerLevel serverWorld, ParticleOptions particleType) {
        Vec3 bV3d = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
        boolean doSpellParticleType = true;
        double xOffset = 0.0;
        double zOffset = 0.0;
        for (double d0 = 0.0; d0 <= 3.0; d0 += 0.5) {
            xOffset = serverWorld.m_213780_().m_188500_() - 0.5;
            zOffset = serverWorld.m_213780_().m_188500_() - 0.5;
            serverWorld.m_8767_(particleType, bV3d.m_7096_(), bV3d.m_7098_(), bV3d.m_7094_(), 1, xOffset, d0, zOffset, 0.04);
        }
    }

    public static void debugMsg(int level, String dMsg) {
        if (MyConfig.getDebugLevel() > level - 1) {
            LOGGER.info("L" + level + ":" + dMsg);
        }
    }

    public static void debugMsg(int level, BlockPos pos, String dMsg) {
        if (MyConfig.getDebugLevel() > level - 1) {
            LOGGER.info("L" + level + " (" + pos.m_123341_() + "," + pos.m_123342_() + "," + pos.m_123343_() + "): " + dMsg);
        }
    }

    public static void sendBoldChat(Player p, String chatMessage, ChatFormatting textColor) {
        MutableComponent component = Component.m_237113_((String)chatMessage);
        component.m_6270_(component.m_7383_().m_131136_(Boolean.valueOf(true)));
        component.m_6270_(component.m_7383_().m_131140_(ChatFormatting.DARK_GREEN));
        p.m_213846_((Component)component);
    }

    public static void sendChat(Player p, String chatMessage, ChatFormatting textColor) {
        MutableComponent component = Component.m_237113_((String)chatMessage);
        component.m_6270_(component.m_7383_().m_131140_(ChatFormatting.GREEN));
        p.m_213846_((Component)component);
    }

    public static void updateEffect(LivingEntity e, int amplifier, MobEffect mobEffect, int duration) {
        MobEffectInstance ei = e.m_21124_(mobEffect);
        if (amplifier == 10) {
            amplifier = 20;
        }
        if (ei != null) {
            if (amplifier > ei.m_19564_()) {
                e.m_21195_(mobEffect);
            }
            if (amplifier == ei.m_19564_() && ei.m_19557_() > 10) {
                return;
            }
            if (ei.m_19557_() > 10) {
                return;
            }
            e.m_21195_(mobEffect);
        }
        e.m_7292_(new MobEffectInstance(mobEffect, duration, amplifier, true, true));
    }

    public static boolean populateEntityType(EntityType<?> et, ServerLevel level, BlockPos savePos, int range, int modifier) {
        boolean isBaby = false;
        return Utility.populateEntityType(et, level, savePos, range, modifier, isBaby);
    }

    public static boolean populateEntityType(EntityType<?> et, ServerLevel level, BlockPos savePos, int range, int modifier, boolean isBaby) {
        boolean persistant = false;
        return Utility.populateEntityType(et, level, savePos, range, modifier, persistant, isBaby);
    }

    public static boolean populateEntityType(EntityType<?> et, ServerLevel level, BlockPos savePos, int range, int modifier, boolean persistant, boolean isBaby) {
        int numZP = level.f_46441_.m_188503_(range) - modifier;
        if (numZP < 0) {
            return false;
        }
        for (int i = 0; i <= numZP; ++i) {
            Mob e = et == EntityType.f_20509_ ? (Mob)et.m_20600_(level, null, null, null, savePos.m_122013_(2).m_122025_(2), MobSpawnType.SPAWNER, true, true) : (Mob)et.m_20600_(level, null, null, null, savePos.m_122013_(2).m_122025_(2), MobSpawnType.NATURAL, true, true);
            if (persistant) {
                e.m_21530_();
            }
            if (et == EntityType.f_20531_) {
                e.m_21561_(true);
            }
            e.m_6863_(isBaby);
        }
        return true;
    }

    public static boolean isOutside(BlockPos pos, ServerLevel serverLevel) {
        return serverLevel.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, pos) == pos;
    }
}

