/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.harderspawners.events;

import com.mactso.harderspawners.config.MobSpawnerManager;
import com.mactso.harderspawners.config.MyConfig;
import com.mactso.harderspawners.events.ServerTickHandler;
import com.mactso.harderspawners.util.SharedUtilityMethods;
import com.mactso.harderspawners.util.Utility;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.InclusiveRange;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.SpawnData;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SpawnerSpawnEvent {
    private static int debugThreadIdentifier = 0;
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int SECONDS_120 = 2400;
    private static final int EFFECT_LEVEL_0 = 0;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onCheckSpawnerSpawn(LivingSpawnEvent.CheckSpawn event) {
        BlockPos eventPos;
        int skylight;
        Mob le;
        if (event.getSpawnReason() != MobSpawnType.SPAWNER) {
            return;
        }
        if (event.getSpawner() == null) {
            return;
        }
        if (event.getSpawner().getSpawnerBlockEntity() == null) {
            return;
        }
        if (MyConfig.debugLevel > 0) {
            debugThreadIdentifier = (debugThreadIdentifier + 1) % 10000;
            System.out.println("HarderSpawners: (" + debugThreadIdentifier + ") Checking Spawner Spawn Event at " + (int)event.getX() + "+(int)event.getY()+" + (int)event.getZ() + ".");
        }
        if (!(event.getLevel() instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverWorld = (ServerLevel)event.getLevel();
        if (!serverWorld.m_45784_((Entity)(le = event.getEntity()))) {
            event.setResult(Event.Result.DENY);
            return;
        }
        event.setResult(Event.Result.ALLOW);
        boolean inWater = false;
        if (serverWorld.m_46855_(le.m_20191_()) && !le.m_6040_()) {
            le.m_7292_(new MobEffectInstance(MobEffects.f_19608_, MyConfig.getHostileSpawnerResistDaylightDuration() * 20, 0, false, false));
        }
        if ((skylight = serverWorld.m_45517_(LightLayer.SKY, eventPos = new BlockPos(Mth.m_14107_((double)event.getX()), Mth.m_14107_((double)event.getY()), Mth.m_14107_((double)event.getZ())))) < 15 && serverWorld.m_46803_(eventPos) > 6) {
            boolean bl = SharedUtilityMethods.removeLightNearSpawner(eventPos, serverWorld);
        }
        BlockPos AbSpPos = event.getSpawner().getSpawnerBlockEntity().m_58899_();
        BaseSpawner mySpawner = event.getSpawner();
        Utility.drawParticleBeam(AbSpPos.m_122013_(4), serverWorld, (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_49991_.m_49966_()));
        Utility.drawParticleBeam(AbSpPos.m_122020_(4), serverWorld, (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_49991_.m_49966_()));
        Utility.drawParticleBeam(AbSpPos.m_122030_(4), serverWorld, (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_49991_.m_49966_()));
        Utility.drawParticleBeam(AbSpPos.m_122025_(4), serverWorld, (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_49991_.m_49966_()));
        int debug5 = 7;
        boolean justSpawned = true;
        SpawnerSpawnEvent.updateHostileSpawnerValues(mySpawner, justSpawned);
        int debug = 4;
        String leStr = ForgeRegistries.ENTITY_TYPES.getKey((Object)le.m_6095_()).toString();
        MobSpawnerManager.MobSpawnerBreakPercentageItem t = MobSpawnerManager.getMobSpawnerBreakPercentage(leStr);
        if (MyConfig.getHostileSpawnerResistDaylightDuration() > 0 && serverWorld.m_46803_(eventPos) > 8) {
            le.m_7292_(new MobEffectInstance(MobEffects.f_19607_, MyConfig.getHostileSpawnerResistDaylightDuration() * 20, 0, false, false));
        }
        if (t == null) {
            leStr = "harderspawners:default";
            t = MobSpawnerManager.getMobSpawnerBreakPercentage(leStr);
        }
        double mobSpawnerBreakPercentage = 0.2;
        if (t != null) {
            mobSpawnerBreakPercentage = t.getSpawnerBreakPercentage();
        }
        if (mobSpawnerBreakPercentage == 0.0) {
            return;
        }
        mobSpawnerBreakPercentage /= 4.0;
        RandomSource chance = event.getLevel().m_213780_();
        double failRoll = 100.0 * chance.m_188500_();
        boolean canExplode = true;
        if (failRoll < mobSpawnerBreakPercentage) {
            double explodeRoll = 100.0 * chance.m_188500_();
            if (le instanceof Silverfish) {
                canExplode = false;
            }
            serverWorld.m_46961_(AbSpPos, false);
            boolean explode = false;
            if (canExplode && explodeRoll < MyConfig.spawnersExplodePercentage) {
                explode = true;
            }
            if (explode) {
                Vec3 explodepos = new Vec3((double)AbSpPos.m_123341_(), (double)AbSpPos.m_123342_(), (double)AbSpPos.m_123343_());
                serverWorld.m_7703_(null, new DamageSource("explosion").m_19375_(), null, explodepos.f_82479_, explodepos.f_82480_, explodepos.f_82481_, 6.0f, true, Explosion.BlockInteraction.DESTROY);
            }
        }
    }

    public static void updateHostileSpawnerValues(BaseSpawner mySpawner, boolean fromSpawnEvent) {
        CompoundTag tag = new CompoundTag();
        boolean changed = false;
        CompoundTag spawnDataTag = (tag = mySpawner.m_186381_(tag)).m_128469_("SpawnData");
        CompoundTag entityTag = spawnDataTag.m_128469_("entity");
        Optional optional = EntityType.m_20637_((CompoundTag)entityTag);
        if (optional.isEmpty()) {
            return;
        }
        if (((EntityType)optional.get()).m_20674_() != MobCategory.MONSTER) {
            return;
        }
        if (tag.m_128451_("MaxNearbyEntities") != MyConfig.maxNearbyEntities) {
            tag.m_128405_("MaxNearbyEntities", MyConfig.maxNearbyEntities);
            changed = true;
        }
        if (tag.m_128451_("RequiredPlayerRange") != MyConfig.requiredPlayerRange) {
            tag.m_128405_("RequiredPlayerRange", MyConfig.requiredPlayerRange);
            changed = true;
        }
        if (tag.m_128451_("SpawnRange") != MyConfig.spawnRange) {
            tag.m_128405_("SpawnRange", MyConfig.spawnRange);
            changed = true;
        }
        if (fromSpawnEvent) {
            int time = tag.m_128451_("MinSpawnDelay");
            if (tag.m_128451_("MinSpawnDelay") >= MyConfig.getSpawnerMinutesStunned() * 1200) {
                tag.m_128405_("MinSpawnDelay", 200);
                tag.m_128405_("MaxSpawnDelay", 800);
                tag.m_128405_("Delay", 240);
                changed = true;
            }
        }
        int lightLevel = MyConfig.getHostileSpawnerLightLevel();
        SpawnData.CustomSpawnRules c = new SpawnData.CustomSpawnRules(new InclusiveRange((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(lightLevel)), new InclusiveRange((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(lightLevel)));
        SpawnData s = new SpawnData(entityTag, Optional.of(c));
        Optional wSD = SpawnData.f_186559_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)s).result();
        if (wSD.isPresent() && !spawnDataTag.equals(wSD.get())) {
            tag.m_128365_("SpawnData", (Tag)wSD.get());
            changed = true;
        }
        if (changed) {
            mySpawner.m_151328_(mySpawner.getSpawnerBlockEntity().m_58904_(), mySpawner.getSpawnerBlockEntity().m_58899_(), tag);
            ServerTickHandler.addClientUpdate((ServerLevel)mySpawner.getSpawnerBlockEntity().m_58904_(), mySpawner.getSpawnerBlockEntity().m_58899_());
        }
    }
}

