/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.harderspawners.events;

import com.mactso.harderspawners.config.MyConfig;
import com.mactso.harderspawners.events.ServerTickHandler;
import com.mactso.harderspawners.util.SharedUtilityMethods;
import com.mactso.harderspawners.util.Utility;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SpawnerBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class SpawnerBreakHandler {
    static int spamLimiter = 0;
    static boolean SHOW_PARTICLES = true;
    static long cGameTime = 0L;

    @SubscribeEvent
    public void onBreakBlock(BlockEvent.BreakEvent event) {
        if (MyConfig.getSpawnerMinutesStunned() == 0) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)event.getPlayer();
        if (sp.m_7500_()) {
            return;
        }
        if (!event.isCancelable()) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)sp.f_19853_;
        BlockPos pos = event.getPos();
        BlockState bs = serverLevel.m_8055_(pos);
        Block b = bs.m_60734_();
        if (b != Blocks.f_50085_) {
            return;
        }
        BlockEntity be = serverLevel.m_7702_(pos);
        sp.f_19853_.m_5594_(null, pos, SoundEvents.f_11854_, SoundSource.AMBIENT, 1.0f, 1.0f);
        if (be instanceof SpawnerBlockEntity) {
            SpawnerBlockEntity sbe = (SpawnerBlockEntity)be;
            BaseSpawner mySpawner = sbe.m_59801_();
            CompoundTag tag = new CompoundTag();
            tag = mySpawner.m_186381_(tag);
            int minSpawnDelay = tag.m_128451_("MinSpawnDelay");
            int stunnedTicks = MyConfig.getSpawnerMinutesStunned() * 1200;
            if (tag.m_128451_("MinSpawnDelay") != stunnedTicks) {
                tag.m_128405_("MinSpawnDelay", stunnedTicks);
                tag.m_128405_("MaxSpawnDelay", stunnedTicks + 10);
                tag.m_128405_("Delay", stunnedTicks + 5);
                mySpawner.m_151328_(mySpawner.getSpawnerBlockEntity().m_58904_(), mySpawner.getSpawnerBlockEntity().m_58899_(), tag);
                sbe.m_6596_();
                event.setCanceled(true);
                ServerTickHandler.addClientUpdate(serverLevel, pos);
            } else {
                sp.f_19853_.m_5594_(null, pos, SoundEvents.f_11797_, SoundSource.AMBIENT, 1.0f, 1.0f);
                ServerTickHandler.addClientUpdate(serverLevel, pos);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void blockBreakSpeed(PlayerEvent.BreakSpeed event) {
        float baseDestroySpeed;
        int THREE_SECONDS = 60;
        if (event.getState().m_60734_() == null || event.getPosition().isEmpty()) {
            return;
        }
        if (!(event.getState().m_60734_() instanceof SpawnerBlock)) {
            return;
        }
        if (event.getEntity() == null) {
            return;
        }
        if (event.getEntity().m_7500_()) {
            return;
        }
        BlockPos pos = (BlockPos)event.getPosition().get();
        Block spawnerBlock = event.getState().m_60734_();
        String debugSideType = "ServerSide";
        Player player = event.getEntity();
        long gameTime = player.f_19853_.m_46467_();
        if (player.f_19853_.m_5776_()) {
            debugSideType = "ClientSide";
        }
        if (player instanceof ServerPlayer) {
            debugSideType = "ServerSide";
        }
        if (MyConfig.debugLevel > 0) {
            System.out.println(debugSideType);
        }
        Item playerItem = player.m_21205_().m_41720_();
        boolean toolHarvestsBlockFaster = false;
        float originalToolSpeed = event.getOriginalSpeed();
        if (originalToolSpeed > 1.0f) {
            toolHarvestsBlockFaster = true;
        }
        int revengeLevel = MyConfig.spawnerRevengeLevel - 1;
        if (MyConfig.spawnerRevengeLevel > 0 && !player.f_19853_.m_5776_()) {
            SimpleParticleType particles = ParticleTypes.f_123777_;
            ServerPlayer serverPlayer = (ServerPlayer)event.getEntity();
            ServerLevel serverWorld = serverPlayer.m_9236_();
            BlockEntity be = serverWorld.m_7702_(pos);
            if (!(be instanceof SpawnerBlockEntity)) {
                return;
            }
            int stunnedTicks = MyConfig.getSpawnerMinutesStunned() * 1200;
            SpawnerBlockEntity sbe = (SpawnerBlockEntity)be;
            BaseSpawner mySpawner = sbe.m_59801_();
            CompoundTag tag = new CompoundTag();
            tag = mySpawner.m_186381_(tag);
            int minSpawnDelay = tag.m_128451_("MinSpawnDelay");
            if (tag.m_128451_("MinSpawnDelay") == stunnedTicks) {
                particles = ParticleTypes.f_175830_;
            }
            RandomSource rand = player.f_19853_.m_213780_();
            double vx = 0.06 * rand.m_188500_() - 0.03;
            double vz = 0.06 * rand.m_188500_() - 0.03;
            Vec3 rfv = new Vec3(vx, 0.05, vz);
            if (cGameTime < gameTime) {
                cGameTime = gameTime + 2L + (long)rand.m_188503_(3);
                player.f_19853_.m_5594_(null, pos, SoundEvents.f_11849_, SoundSource.AMBIENT, 0.11f, 0.3f);
                BlockPos p = pos;
                for (int j = 0; j < 11; ++j) {
                    double x = (double)pos.m_123341_() + rand.m_188500_();
                    double y = (double)pos.m_123342_() + 0.95;
                    double z = (double)pos.m_123343_() + rand.m_188500_();
                    serverWorld.m_8767_((ParticleOptions)particles, x, y, z, 3, rfv.f_82479_, rfv.f_82480_, rfv.f_82481_, -0.04);
                }
            }
            boolean destroyedLight = SharedUtilityMethods.removeLightNearSpawner(pos, serverWorld);
            if (revengeLevel >= 0) {
                MobEffectInstance ei;
                serverPlayer.m_9236_().m_5594_(null, pos, SoundEvents.f_11899_, SoundSource.AMBIENT, 0.9f, 0.25f);
                MobEffect effect = MobEffects.f_19614_;
                if (revengeLevel >= 4) {
                    effect = MobEffects.f_19615_;
                }
                if ((ei = player.m_21124_(effect)) != null) {
                    if (ei.m_19557_() > 10) {
                        return;
                    }
                    if (ei.m_19557_() < 1 || ei.m_19564_() > revengeLevel) {
                        serverPlayer.m_6234_(effect);
                    }
                }
                serverPlayer.m_7292_(new MobEffectInstance(effect, 60, revengeLevel % 4, true, SHOW_PARTICLES));
                serverPlayer.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 60, revengeLevel % 4, true, SHOW_PARTICLES));
            }
        }
        float newDestroySpeed = baseDestroySpeed = event.getOriginalSpeed();
        if (MyConfig.spawnerBreakSpeedMultiplier > 0 && (newDestroySpeed /= (float)(1 + MyConfig.spawnerBreakSpeedMultiplier)) > 0.0f) {
            event.setNewSpeed(newDestroySpeed);
            if (MyConfig.debugLevel > 0) {
                System.out.println("Slowed breaking spawner modifier applied:" + MyConfig.spawnerBreakSpeedMultiplier + " slowing from " + baseDestroySpeed + " to " + newDestroySpeed + ".");
            }
        }
        if (player.f_19853_.m_5776_() && spamLimiter++ % 20 == 0 && MyConfig.spawnerTextOff == 0) {
            Utility.sendChat(player, "The spawner slowly breaks...", ChatFormatting.DARK_AQUA);
            if (MyConfig.debugLevel > 1) {
                Utility.sendChat(player, "Slowed breaking spawner modifier applied: " + MyConfig.spawnerBreakSpeedMultiplier + " speed reduced from " + baseDestroySpeed + " to " + newDestroySpeed + ".", ChatFormatting.GREEN);
            }
        }
    }
}

