/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.harderspawners.events;

import com.mactso.harderspawners.config.MyConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class MyEntityPlaceEvent {
    @SubscribeEvent
    public void bucket(FillBucketEvent event) {
        BlockHitResult br;
        Level world = event.getLevel();
        ItemStack stack = event.getEmptyBucket();
        BlockPos pos = null;
        if (event.getTarget().m_6662_() == HitResult.Type.BLOCK && (pos = (br = (BlockHitResult)event.getTarget()).m_82425_().m_121945_(br.m_82434_())) != null && stack.m_41720_() instanceof BucketItem) {
            BucketItem b = (BucketItem)stack.m_41720_();
            if (this.isSpawnerNearby(world, pos) && b.getFluid().getFluidType().getLightLevel() > 8) {
                if (!world.m_5776_()) {
                    world.m_5594_(null, pos, SoundEvents.f_12031_, SoundSource.AMBIENT, 0.9f, 0.25f);
                }
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onPlaceBlock(BlockEvent.EntityPlaceEvent event) {
        Level world = (Level)event.getLevel();
        BlockState placedBlockState = event.getPlacedBlock();
        BlockPos placedBlockPos = event.getPos();
        Block placedBlock = placedBlockState.m_60734_();
        int blockLightValue = placedBlockState.getLightEmission((BlockGetter)world, placedBlockPos);
        if (placedBlock == Blocks.f_50261_) {
            blockLightValue = 15;
        }
        if (this.isSpawnerNearby(world, placedBlockPos) && world.m_46803_(placedBlockPos) < 15 && blockLightValue > 8 && world.m_213780_().m_188503_(100) <= MyConfig.getDestroyLightPercentage()) {
            world.m_46961_(placedBlockPos, true);
        }
    }

    private boolean isSpawnerNearby(Level world, BlockPos blockPos) {
        Block tempBlock;
        int dz;
        int dx;
        int dy;
        int x = blockPos.m_123341_();
        int y = blockPos.m_123342_();
        int z = blockPos.m_123343_();
        int destroyRange = MyConfig.getDestroyLightRange();
        int destroyYRange = destroyRange / 2;
        for (dy = -1; dy < 2; ++dy) {
            for (dx = -1; dx < 2; ++dx) {
                for (dz = -1; dz < 2; ++dz) {
                    tempBlock = world.m_8055_(new BlockPos(x + dx, y + dy, z + dz)).m_60734_();
                    if (tempBlock != Blocks.f_50085_) continue;
                    return true;
                }
            }
        }
        for (dy = 0 - destroyYRange; dy < destroyYRange; ++dy) {
            for (dx = 0 - destroyRange; dx < 0 + destroyRange; ++dx) {
                for (dz = 0 - destroyRange; dz < 0 + destroyRange; ++dz) {
                    tempBlock = world.m_8055_(new BlockPos(x + dx, y + dy, z + dz)).m_60734_();
                    if (tempBlock != Blocks.f_50085_) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

