/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.hardermonsterboats.config;

import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="hardermonsterboats", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MyConfig {
    private static final Logger LOGGER;
    public static final Common COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;
    public static String[] willMonsterMountBoat;
    public static String[] willMonsterNotHitBoat;
    public static String[] willMonsterNotLeaveBoat;

    public static boolean isWillMonsterMountBoat(String classname) {
        for (String mod : willMonsterMountBoat) {
            if (!classname.contains(mod)) continue;
            return true;
        }
        return false;
    }

    public static boolean isWillMonsterNotHitBoat(String classname) {
        for (String mod : willMonsterNotHitBoat) {
            if (!classname.contains(mod)) continue;
            return true;
        }
        return false;
    }

    public static boolean isWillMonsterNotLeaveBoat(String classname) {
        for (String mod : willMonsterNotLeaveBoat) {
            if (!classname.contains(mod)) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void onModConfigEvent(ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == COMMON_SPEC) {
            MyConfig.bakeConfig();
        }
    }

    public static void bakeConfig() {
        willMonsterMountBoat = MyConfig.extract((List)MyConfig.COMMON.willMonsterMountBoat.get());
        willMonsterNotHitBoat = MyConfig.extract((List)MyConfig.COMMON.willMonsterNotHitBoat.get());
        willMonsterNotLeaveBoat = MyConfig.extract((List)MyConfig.COMMON.willMonsterNotLeaveBoat.get());
    }

    private static String[] extract(List<? extends String> value) {
        return value.toArray(new String[value.size()]);
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        LOGGER = LogManager.getLogger();
    }

    public static class Common {
        List<String> willMonsterMountBoatList = Arrays.asList("minecraft:zombie_villager", "minecraft:vex");
        List<String> willMonsterNotHitBoatList = Arrays.asList("minecraft:zombie_villager", "minecraft:zombie", "minecraft:creeper", "minecraft:skeleton", "nasty:skeleton", "minecraft:vex");
        List<String> willMonsterNotLeaveBoatList = Arrays.asList("minecraft:zombie_villager");
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> willMonsterMountBoat;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> willMonsterNotHitBoat;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> willMonsterNotLeaveBoat;

        public Common(ForgeConfigSpec.Builder builder) {
            String baseTrans = "hardermonsterboats.config.";
            this.willMonsterMountBoat = builder.comment("Checked Mods Name List").translation("hardermonsterboats.config.willMonsterMountBoat").defineList("willMonsterMountBoat", this.willMonsterMountBoatList, Common::isString);
            this.willMonsterNotLeaveBoat = builder.comment("Checked Mods Name List").translation("hardermonsterboats.config.willMonsterNotLeaveBoat").defineList("willMonsterNotLeaveBoat", this.willMonsterNotLeaveBoatList, Common::isString);
            this.willMonsterNotHitBoat = builder.comment("Checked Mods Name List").translation("hardermonsterboats.config.willMonsterNotHitBoat").defineList("willMonsterNotHitBoat", this.willMonsterNotHitBoatList, Common::isString);
        }

        public static boolean isString(Object o) {
            return o instanceof String;
        }
    }
}

