/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.util;

import net.minecraft.core.RegistryAccess;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;

public class ModDamageSources {
    private static DamageSource ADDITIONAL = new AdditionalDamageSource();

    public static void setup(RegistryAccess registryAccess) {
    }

    public static DamageSource additional() {
        return ADDITIONAL;
    }

    public static DamageSource additional(Entity attacker) {
        return attacker == null ? ModDamageSources.additional() : new AdditionalEntityDamageSource(attacker);
    }

    public static DamageSource silverAttack(Entity attacker) {
        return new SilverAttackDamageSource(attacker);
    }

    public static DamageSource armorPiercing(Entity attacker) {
        return new ArmorPiercingDamageSource(attacker);
    }

    public static boolean isAdditional(DamageSource source) {
        return source == DamageSource.f_19318_ || source == DamageSource.f_19319_ || source instanceof Additional;
    }

    static class AdditionalEntityDamageSource
    extends EntityDamageSource
    implements Additional {
        AdditionalEntityDamageSource(Entity attacker) {
            super("entityAdditional", attacker);
        }
    }

    static class SilverAttackDamageSource
    extends EntityDamageSource
    implements Additional {
        SilverAttackDamageSource(Entity attacker) {
            super("silver", attacker);
            this.m_19380_();
            this.m_19389_();
        }
    }

    static class ArmorPiercingDamageSource
    extends EntityDamageSource
    implements Additional {
        ArmorPiercingDamageSource(Entity attacker) {
            super("armorPiercing", attacker);
            this.m_19380_();
        }
    }

    static interface Additional {
    }

    static class AdditionalDamageSource
    extends DamageSource
    implements Additional {
        AdditionalDamageSource() {
            super("additional");
        }
    }
}

