/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.network;

import com.magistuarmory.item.LanceItem;
import dev.architectury.networking.NetworkManager;
import io.netty.buffer.Unpooled;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class PacketLanceCollision {
    public static final ResourceLocation ID = new ResourceLocation("magistuarmory", "packet_lance_collision");

    public static void sendToServer(int entityid, float damage) {
        NetworkManager.sendToServer((ResourceLocation)ID, (FriendlyByteBuf)PacketLanceCollision.encode(entityid, damage));
    }

    static FriendlyByteBuf encode(int entityid, float speed) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeInt(entityid);
        buf.writeFloat(speed);
        return buf;
    }

    public static void apply(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        Player player = context.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        Entity victim = player2.f_19853_.m_6815_(buf.readInt());
        if (victim == null) {
            return;
        }
        float speed = buf.readFloat();
        context.queue(() -> PacketLanceCollision.execute(victim, speed, player2));
    }

    static void execute(Entity victim, float speed, ServerPlayer player) {
        ItemStack stack = player.m_21205_();
        Item item = stack.m_41720_();
        if (item instanceof LanceItem) {
            LanceItem lance = (LanceItem)item;
            boolean dismount = victim.m_9236_().m_213780_().m_188500_() > 1.0 - (double)lance.getClickedScale();
            lance.setRideSpeed(stack, speed);
            lance.setDismount(stack, dismount);
            player.m_5706_(victim);
            player.m_36334_();
        }
    }
}

