/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.item;

import com.magistuarmory.block.ModBlocks;
import com.magistuarmory.block.PaviseUpperCollisionBlock;
import com.magistuarmory.item.MedievalShieldItem;
import com.magistuarmory.item.ModItemTier;
import com.magistuarmory.item.ShieldType;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.jetbrains.annotations.Nullable;

public class PaviseItem
extends MedievalShieldItem {
    private final Direction attachmentDirection = Direction.DOWN;

    public PaviseItem(String id, ResourceLocation location, Item.Properties properties, ModItemTier material, boolean paintable, boolean is3d, ShieldType type) {
        super(id, location, properties, material, paintable, is3d, type);
    }

    private static <T extends Comparable<T>> BlockState updateState(BlockState blockstate, Property<T> property, String string) {
        return property.m_6215_(string).map(comparable -> (BlockState)blockstate.m_61124_(property, comparable)).orElse(blockstate);
    }

    public static boolean updateCustomBlockEntityTag(Level level, @Nullable Player player, BlockPos blockpos, ItemStack stack) {
        MinecraftServer server = level.m_7654_();
        if (server != null) {
            CompoundTag blockentitytag = PaviseItem.getBlockEntityData(stack);
            BlockEntity blockentity = level.m_7702_(blockpos);
            if (blockentity != null) {
                if (!(level.f_46443_ || !blockentity.m_6326_() || player != null && player.m_36337_())) {
                    return false;
                }
                CompoundTag tag2 = blockentity.m_187482_();
                CompoundTag tag3 = tag2.m_6426_();
                if (stack.m_41783_() != null) {
                    tag2.m_128365_("ItemStack", (Tag)stack.m_41783_());
                }
                tag2.m_128379_("Enchanted", stack.m_41793_());
                tag2.m_128359_("ShieldId", ((PaviseItem)stack.m_41720_()).getId());
                if (blockentitytag != null) {
                    blockentitytag.m_128405_("Base", PaviseItem.m_43102_((ItemStack)stack).m_41060_());
                    tag2.m_128391_(blockentitytag);
                }
                if (!tag2.equals((Object)tag3)) {
                    blockentity.m_142466_(tag2);
                    blockentity.m_6596_();
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    public static CompoundTag getBlockEntityData(ItemStack stack) {
        return stack.m_41737_("BlockEntityTag");
    }

    public static ListTag getEnchantmentData(ItemStack stack) {
        return stack.m_41785_();
    }

    public static void setBlockEntityData(ItemStack stack, BlockEntityType<?> type, CompoundTag tag) {
        if (tag.m_128456_()) {
            stack.m_41749_("BlockEntityTag");
        }
        BlockEntity.m_187468_((CompoundTag)tag, type);
        stack.m_41700_("BlockEntityTag", (Tag)tag);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        InteractionResult result = super.m_6225_(context);
        if (result.m_19077_() || context.m_43723_() != null && !context.m_43723_().m_6144_()) {
            return result;
        }
        result = this.place(new BlockPlaceContext(context));
        if (!result.m_19077_() && this.m_41472_()) {
            InteractionResult result2 = this.m_7203_(context.m_43725_(), context.m_43723_(), context.m_43724_()).m_19089_();
            return result2 == InteractionResult.CONSUME ? InteractionResult.CONSUME_PARTIAL : result2;
        }
        return result;
    }

    public InteractionResult place(BlockPlaceContext context) {
        if (!context.m_7059_()) {
            return InteractionResult.FAIL;
        }
        BlockPlaceContext context2 = this.updatePlacementContext(context);
        if (context2 == null) {
            return InteractionResult.FAIL;
        }
        BlockState blockstate = this.getPlacementState(context2);
        if (blockstate == null) {
            return InteractionResult.FAIL;
        }
        if (!this.placeBlock(context2, blockstate)) {
            return InteractionResult.FAIL;
        }
        BlockPos blockpos = context2.m_8083_();
        Level level = context2.m_43725_();
        Player player = context2.m_43723_();
        ItemStack stack = context2.m_43722_();
        BlockState blockstate2 = level.m_8055_(blockpos);
        if (blockstate2.m_60713_(blockstate.m_60734_())) {
            blockstate2 = this.updateBlockStateFromTag(blockpos, level, stack, blockstate2);
            this.updateCustomBlockEntityTag(blockpos, level, player, stack, blockstate2);
            blockstate2.m_60734_().m_6402_(level, blockpos, blockstate2, (LivingEntity)player, stack);
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10591_.m_59469_((ServerPlayer)player, blockpos, stack);
            }
        }
        SoundType sound = blockstate2.m_60827_();
        level.m_5594_(player, blockpos, this.getPlaceSound(blockstate2), SoundSource.BLOCKS, (sound.m_56773_() + 1.0f) / 2.0f, sound.m_56774_() * 0.8f);
        level.m_220407_(GameEvent.f_157797_, blockpos, GameEvent.Context.m_223719_((Entity)player, (BlockState)blockstate2));
        if (player == null || !player.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    protected SoundEvent getPlaceSound(BlockState blockstate) {
        return blockstate.m_60827_().m_56777_();
    }

    @Nullable
    public BlockPlaceContext updatePlacementContext(BlockPlaceContext context) {
        return context;
    }

    protected boolean updateCustomBlockEntityTag(BlockPos blockpos, Level level, @Nullable Player player, ItemStack stack, BlockState blockstate) {
        return PaviseItem.updateCustomBlockEntityTag(level, player, blockpos, stack);
    }

    private BlockState updateBlockStateFromTag(BlockPos blockpos, Level level, ItemStack stack, BlockState blockstate) {
        BlockState blockstate2 = blockstate;
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            CompoundTag tag2 = tag.m_128469_("BlockStateTag");
            StateDefinition statedefinition = blockstate.m_60734_().m_49965_();
            for (String string : tag2.m_128431_()) {
                Property property = statedefinition.m_61081_(string);
                if (property == null) continue;
                String string2 = Objects.requireNonNull(tag2.m_128423_(string)).m_7916_();
                blockstate2 = PaviseItem.updateState(blockstate2, property, string2);
            }
        }
        if (blockstate2 != blockstate) {
            level.m_7731_(blockpos, blockstate2, 2);
        }
        return blockstate2;
    }

    protected boolean placeBlock(BlockPlaceContext context, BlockState blockstate) {
        BlockPos aboveblockpos;
        Level level = context.m_43725_();
        if (level.m_7433_(aboveblockpos = context.m_8083_().m_7494_(), state -> state.m_60734_() != Blocks.f_50016_) && !level.m_46801_(aboveblockpos)) {
            return false;
        }
        if (!context.m_43725_().m_7731_(context.m_8083_(), blockstate, 11)) {
            return false;
        }
        level.m_7731_(aboveblockpos, ((PaviseUpperCollisionBlock)((Object)ModBlocks.PAVISE_UPPER_COLLISION.get())).m_49966_(), 27);
        return true;
    }

    public String m_5524_() {
        return this.getBlock().m_7705_();
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag tooltipflag) {
        super.m_7373_(stack, level, list, tooltipflag);
        list.add((Component)Component.m_237115_((String)"canbeplacedonground").m_130940_(ChatFormatting.BLUE));
    }

    public Block getBlock() {
        return (Block)ModBlocks.PAVISE.get();
    }

    protected boolean canPlace(LevelReader levelreader, BlockState blockstate, BlockPos blockpos) {
        return blockstate.m_60710_(levelreader, blockpos);
    }

    @Nullable
    protected BlockState getPlacementState(BlockPlaceContext context) {
        Direction[] var6;
        BlockState blockstate2 = null;
        Level levelreader = context.m_43725_();
        BlockPos blockpos = context.m_8083_();
        for (Direction direction : var6 = context.m_6232_()) {
            BlockState blockstate3;
            if (direction == this.attachmentDirection.m_122424_() || (blockstate3 = this.getBlock().m_5573_(context)) == null || !this.canPlace((LevelReader)levelreader, blockstate3, blockpos)) continue;
            blockstate2 = blockstate3;
            break;
        }
        return blockstate2 != null && levelreader.m_45752_(blockstate2, blockpos, CollisionContext.m_82749_()) ? blockstate2 : null;
    }
}

