/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.item;

import dev.architectury.platform.Platform;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.Ingredient;

public class ModItemTier
implements Tier {
    private final String name;
    private final float attackDamageBonus;
    private final int enchantmentValue;
    private final int level;
    private final Supplier<Ingredient> repairIngredient;
    private final float speed;
    private final int uses;
    private final float density;
    public static ModItemTier WOOD = new ModItemTier("wood", (Tier)Tiers.WOOD, 0.0f);
    public static ModItemTier STONE = new ModItemTier("stone", (Tier)Tiers.STONE, 1.0f);
    public static ModItemTier IRON = new ModItemTier("iron", (Tier)Tiers.IRON, 2.0f);
    public static ModItemTier DIAMOND = new ModItemTier("diamond", (Tier)Tiers.DIAMOND, 3.0f);
    public static ModItemTier GOLD = new ModItemTier("gold", (Tier)Tiers.GOLD, 4.0f);
    public static ModItemTier NETHERITE = new ModItemTier("netherite", (Tier)Tiers.NETHERITE, 5.0f);
    public static ModItemTier COPPER = new ModItemTier("copper", 1, 150, 0.7f, 0.0f, 10, Platform.isForge() ? "forge:ingots/copper" : "c:copper_ingots", 1.0f);
    public static ModItemTier SILVER = new ModItemTier("silver", 2, 230, 5.5f, 1.0f, 18, Platform.isForge() ? "forge:ingots/silver" : "c:silver_ingots", 2.0f);
    public static ModItemTier STEEL = new ModItemTier("steel", 2, 400, 6.0f, 2.5f, 14, Platform.isForge() ? "forge:ingots/steel" : "c:steel_ingots", 2.0f);
    public static ModItemTier TIN = new ModItemTier("tin", 2, 130, 6.0f, 0.0f, 20, Platform.isForge() ? "forge:ingots/tin" : "c:tin_ingots", 2.0f);
    public static ModItemTier BRONZE = new ModItemTier("bronze", 2, 200, 6.0f, 2.0f, 15, Platform.isForge() ? "forge:ingots/bronze" : "c:bronze_ingots", 2.0f);

    public ModItemTier(String name, Tier tier, float density) {
        this.name = name;
        this.level = tier.m_6604_();
        this.uses = tier.m_6609_();
        this.speed = tier.m_6624_();
        this.attackDamageBonus = tier.m_6631_();
        this.enchantmentValue = tier.m_6601_();
        this.repairIngredient = () -> ((Tier)tier).m_6282_();
        this.density = density;
    }

    public ModItemTier(String name, int level, int uses, float speed, float attack, int enchantment, String repairitemtag, float density) {
        this.name = name;
        this.level = level;
        this.uses = uses;
        this.speed = speed;
        this.attackDamageBonus = attack;
        this.enchantmentValue = enchantment;
        this.repairIngredient = () -> Ingredient.m_204132_((TagKey)TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation(repairitemtag)));
        this.density = density;
    }

    public float m_6631_() {
        return this.attackDamageBonus;
    }

    public int m_6601_() {
        return this.enchantmentValue;
    }

    public int m_6604_() {
        return this.level;
    }

    public Ingredient m_6282_() {
        return this.repairIngredient.get();
    }

    public float m_6624_() {
        return this.speed;
    }

    public int m_6609_() {
        return this.uses;
    }

    public String getMaterialName() {
        return this.name;
    }

    public float getDensity() {
        return this.density;
    }
}

