/*
 * Decompiled with CFR 0.152.
 */
package com.magistuarmory.client.render.tileentity;

import com.magistuarmory.client.render.model.ModModels;
import com.magistuarmory.client.render.model.item.MedievalShieldModel;
import com.magistuarmory.client.render.tileentity.ShieldPatternLayer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HeraldryItemStackRenderer
extends BlockEntityWithoutLevelRenderer
implements ShieldPatternLayer {
    private Model model;
    private final ResourceLocation location;
    private final ResourceLocation locationPattern;
    private final ResourceLocation locationNoPattern;
    private final String patternsDirectory;

    public HeraldryItemStackRenderer(String id, ResourceLocation location) {
        super(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
        this.location = location;
        this.locationPattern = new ResourceLocation(location.m_135827_(), "entity/" + id + "_pattern");
        this.locationNoPattern = new ResourceLocation(location.m_135827_(), "entity/" + id + "_nopattern");
        this.patternsDirectory = "entity/" + location.m_135815_() + "/";
    }

    public void loadModel(EntityModelSet context) {
        this.model = new MedievalShieldModel(context.m_171103_(ModModels.createLocation(this.location)));
    }

    public void m_108829_(ItemStack stack, ItemTransforms.TransformType transform, PoseStack pose, MultiBufferSource buffer, int p, int overlay) {
        Model model = this.model;
        if (model instanceof MedievalShieldModel) {
            MedievalShieldModel shieldmodel = (MedievalShieldModel)model;
            pose.m_85836_();
            pose.m_85841_(1.0f, -1.0f, -1.0f);
            if (BlockItem.m_186336_((ItemStack)stack) != null) {
                material = this.getBaseMaterial();
                VertexConsumer vertexconsumer = material.m_119204_().m_118381_(ItemRenderer.m_115222_((MultiBufferSource)buffer, (RenderType)this.model.m_103119_(material.m_119193_()), (boolean)true, (boolean)stack.m_41790_()));
                shieldmodel.handle().m_104306_(pose, vertexconsumer, p, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                List list = BannerBlockEntity.m_58484_((DyeColor)ShieldItem.m_43102_((ItemStack)stack), (ListTag)BannerBlockEntity.m_58487_((ItemStack)stack));
                this.renderPatterns(pose, buffer, p, overlay, list, stack.m_41790_(), shieldmodel.plate(), 1.0f, 1.0f, 1.0f);
            } else {
                material = new Material(Sheets.f_110738_, this.locationNoPattern);
                VertexConsumer vertexconsumer = material.m_119204_().m_118381_(ItemRenderer.m_115222_((MultiBufferSource)buffer, (RenderType)this.model.m_103119_(material.m_119193_()), (boolean)true, (boolean)stack.m_41790_()));
                shieldmodel.handle().m_104306_(pose, vertexconsumer, p, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                for (ModelPart part : shieldmodel.plate()) {
                    part.m_104306_(pose, vertexconsumer, p, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
                }
            }
            pose.m_85849_();
        }
    }

    @Override
    public Material getBaseMaterial() {
        return new Material(Sheets.f_110738_, this.locationPattern);
    }

    @Override
    public Material getPatternMaterial(ResourceLocation patternlocation) {
        return new Material(Sheets.f_110738_, new ResourceLocation(this.location.m_135827_(), this.patternsDirectory + patternlocation.m_135815_()));
    }
}

