/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.badge;

import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.origins.badge.Badge;
import io.github.apace100.origins.badge.BadgeFactories;
import io.github.apace100.origins.badge.BadgeFactory;
import io.github.apace100.origins.badge.TooltipBadge;
import io.github.apace100.origins.screen.tooltip.CraftingRecipeTooltipComponent;
import io.github.edwinmindcraft.apoli.api.power.configuration.ConfiguredPower;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public record CraftingRecipeBadge(ResourceLocation spriteId, Recipe<CraftingContainer> recipe, @Nullable Component prefix, @Nullable Component suffix) implements Badge
{
    public CraftingRecipeBadge(SerializableData.Instance instance) {
        this(instance.getId("sprite"), (Recipe<CraftingContainer>)((Recipe)instance.get("recipe")), (Component)instance.get("prefix"), (Component)instance.get("suffix"));
    }

    @Override
    public boolean hasTooltip() {
        return true;
    }

    public NonNullList<ItemStack> peekInputs(float time) {
        int seed = Mth.m_14143_((float)(time / 30.0f));
        NonNullList inputs = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
        NonNullList ingredients = this.recipe.m_7527_();
        for (int index = 0; index < ingredients.size(); ++index) {
            ItemStack[] stacks = ((Ingredient)ingredients.get(index)).m_43908_();
            if (stacks.length <= 0) continue;
            inputs.set(index, (Object)stacks[seed % stacks.length].m_41777_());
        }
        return inputs;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<ClientTooltipComponent> getTooltipComponents(ConfiguredPower<?, ?> powerType, int widthLimit, float time, Font textRenderer) {
        LinkedList<ClientTooltipComponent> tooltips = new LinkedList<ClientTooltipComponent>();
        if (Minecraft.m_91087_().f_91066_.f_92125_) {
            MutableComponent recipeIdText = Component.m_237113_((String)this.recipe.m_6423_().toString()).m_130940_(ChatFormatting.DARK_GRAY);
            widthLimit = Math.max(130, textRenderer.m_92852_((FormattedText)recipeIdText));
            if (this.prefix != null) {
                TooltipBadge.addLines(tooltips, this.prefix, textRenderer, widthLimit);
            }
            tooltips.add(new CraftingRecipeTooltipComponent(this.peekInputs(time), this.recipe.m_8043_().m_41777_()));
            if (this.suffix != null) {
                TooltipBadge.addLines(tooltips, this.suffix, textRenderer, widthLimit);
            }
            TooltipBadge.addLines(tooltips, (Component)recipeIdText, textRenderer, widthLimit);
        } else {
            widthLimit = 130;
            if (this.prefix != null) {
                TooltipBadge.addLines(tooltips, this.prefix, textRenderer, widthLimit);
            }
            tooltips.add(new CraftingRecipeTooltipComponent(this.peekInputs(time), this.recipe.m_8043_().m_41777_()));
            if (this.suffix != null) {
                TooltipBadge.addLines(tooltips, this.suffix, textRenderer, widthLimit);
            }
        }
        return tooltips;
    }

    @Override
    public SerializableData.Instance toData(SerializableData.Instance instance) {
        instance.set("sprite", (Object)this.spriteId);
        instance.set("recipe", this.recipe);
        instance.set("prefix", (Object)this.prefix);
        instance.set("suffix", (Object)this.suffix);
        return instance;
    }

    @Override
    public BadgeFactory getBadgeFactory() {
        return (BadgeFactory)BadgeFactories.CRAFTING_RECIPE.get();
    }
}

