/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.util;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.map.type.MapDecorationType;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.moonlight.api.util.math.MthUtils;
import net.mehvahdjukaar.moonlight.core.map.MapDataInternal;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Utils {
    public static void swapItem(Player player, InteractionHand hand, ItemStack oldItem, ItemStack newItem, boolean bothSides) {
        if (!player.f_19853_.f_46443_ || bothSides) {
            player.m_21008_(hand, ItemUtils.m_41817_((ItemStack)oldItem.m_41777_(), (Player)player, (ItemStack)newItem, (boolean)player.m_7500_()));
        }
    }

    public static void swapItem(Player player, InteractionHand hand, ItemStack oldItem, ItemStack newItem) {
        if (!player.f_19853_.f_46443_) {
            player.m_21008_(hand, ItemUtils.m_41817_((ItemStack)oldItem.m_41777_(), (Player)player, (ItemStack)newItem, (boolean)player.m_7500_()));
        }
    }

    public static void swapItemNBT(Player player, InteractionHand hand, ItemStack oldItem, ItemStack newItem) {
        if (!player.f_19853_.f_46443_) {
            player.m_21008_(hand, ItemUtils.m_41817_((ItemStack)oldItem.m_41777_(), (Player)player, (ItemStack)newItem, (boolean)false));
        }
    }

    public static void swapItem(Player player, InteractionHand hand, ItemStack newItem) {
        if (!player.f_19853_.f_46443_) {
            player.m_21008_(hand, ItemUtils.m_41817_((ItemStack)player.m_21120_(hand).m_41777_(), (Player)player, (ItemStack)newItem, (boolean)player.m_7500_()));
        }
    }

    public static void addStackToExisting(Player player, ItemStack stack) {
        Inventory inv = player.m_150109_();
        boolean added = false;
        for (int j = 0; j < inv.f_35974_.size(); ++j) {
            if (!inv.m_8020_(j).m_150930_(stack.m_41720_()) || !inv.m_36040_(j, stack)) continue;
            added = true;
            break;
        }
        if (!added && inv.m_36054_(stack)) {
            player.m_36176_(stack, false);
        }
    }

    public static int getXPinaBottle(int bottleCount, RandomSource rand) {
        int xp = 0;
        for (int i = 0; i < bottleCount; ++i) {
            xp += 3 + rand.m_188503_(5) + rand.m_188503_(5);
        }
        return xp;
    }

    public static VoxelShape rotateVoxelShape(VoxelShape source, Direction direction) {
        AtomicReference<VoxelShape> newShape = new AtomicReference<VoxelShape>(Shapes.m_83040_());
        source.m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
            Vec3 min = new Vec3(minX - 0.5, minY - 0.5, minZ - 0.5);
            Vec3 max = new Vec3(maxX - 0.5, maxY - 0.5, maxZ - 0.5);
            Vec3 v1 = MthUtils.rotateVec3(min, direction);
            Vec3 v2 = MthUtils.rotateVec3(max, direction);
            VoxelShape s = Shapes.m_166049_((double)(0.5 + Math.min(v1.f_82479_, v2.f_82479_)), (double)(0.5 + Math.min(v1.f_82480_, v2.f_82480_)), (double)(0.5 + Math.min(v1.f_82481_, v2.f_82481_)), (double)(0.5 + Math.max(v1.f_82479_, v2.f_82479_)), (double)(0.5 + Math.max(v1.f_82480_, v2.f_82480_)), (double)(0.5 + Math.max(v1.f_82481_, v2.f_82481_)));
            newShape.set(Shapes.m_83110_((VoxelShape)((VoxelShape)newShape.get()), (VoxelShape)s));
        });
        return newShape.get();
    }

    public static ResourceLocation getID(Block object) {
        return Registry.f_122824_.m_7981_((Object)object);
    }

    public static ResourceLocation getID(EntityType<?> object) {
        return Registry.f_122826_.m_7981_(object);
    }

    public static ResourceLocation getID(Biome object) {
        return BuiltinRegistries.f_123865_.m_7981_((Object)object);
    }

    public static ResourceLocation getID(ConfiguredFeature<?, ?> object) {
        return BuiltinRegistries.f_123861_.m_7981_(object);
    }

    public static ResourceLocation getID(Item object) {
        return Registry.f_122827_.m_7981_((Object)object);
    }

    public static ResourceLocation getID(Fluid object) {
        return Registry.f_122822_.m_7981_((Object)object);
    }

    public static ResourceLocation getID(BlockEntityType<?> object) {
        return Registry.f_122830_.m_7981_(object);
    }

    public static ResourceLocation getID(RecipeSerializer<?> object) {
        return Registry.f_122865_.m_7981_(object);
    }

    public static ResourceLocation getID(SoftFluid object) {
        return SoftFluidRegistry.getID(object);
    }

    public static ResourceLocation getID(MapDecorationType<?, ?> object) {
        return MapDataInternal.hackyGetRegistry().m_7981_(object);
    }

    public static ResourceLocation getID(Object object) {
        if (object instanceof Block) {
            Block b = (Block)object;
            return Utils.getID(b);
        }
        if (object instanceof Item) {
            Item b = (Item)object;
            return Utils.getID(b);
        }
        if (object instanceof EntityType) {
            EntityType b = (EntityType)object;
            return Utils.getID(b);
        }
        if (object instanceof Biome) {
            Biome b = (Biome)object;
            return Utils.getID(b);
        }
        if (object instanceof Fluid) {
            Fluid b = (Fluid)object;
            return Utils.getID(b);
        }
        if (object instanceof BlockEntityType) {
            BlockEntityType b = (BlockEntityType)object;
            return Utils.getID(b);
        }
        if (object instanceof RecipeSerializer) {
            RecipeSerializer b = (RecipeSerializer)object;
            return Utils.getID(b);
        }
        if (object instanceof ConfiguredFeature) {
            ConfiguredFeature c = (ConfiguredFeature)object;
            return Utils.getID(c);
        }
        if (object instanceof Supplier) {
            Supplier s = (Supplier)object;
            return Utils.getID(s.get());
        }
        if (object instanceof SoftFluid) {
            SoftFluid s = (SoftFluid)object;
            return Utils.getID(s);
        }
        if (object instanceof MapDecorationType) {
            MapDecorationType s = (MapDecorationType)object;
            return Utils.getID(s);
        }
        throw new UnsupportedOperationException("Unknown class type " + object.getClass());
    }

    public static RegistryAccess hackyGetRegistryAccess() {
        MinecraftServer s = PlatformHelper.getCurrentServer();
        if (s != null) {
            return s.m_206579_();
        }
        if (!PlatformHelper.getEnv().isServer()) {
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level != null) {
                return level.m_5962_();
            }
            throw new UnsupportedOperationException("Failed to get registry access: Minecraft level was null");
        }
        throw new UnsupportedOperationException("Failed to get registry access. This is a bug");
    }

    public static BlockBehaviour.Properties copyPropertySafe(BlockBehaviour blockBehaviour) {
        BlockBehaviour.Properties p = BlockBehaviour.Properties.m_60926_((BlockBehaviour)blockBehaviour);
        p.m_60953_(s -> 0);
        p.m_222979_(BlockBehaviour.OffsetType.NONE);
        p.m_155949_(blockBehaviour.m_60590_());
        return p;
    }

    public static HitResult rayTrace(LivingEntity entity, Level world, ClipContext.Block blockMode, ClipContext.Fluid fluidMode) {
        return Utils.rayTrace((Entity)entity, world, blockMode, fluidMode, ForgeHelper.getReachDistance(entity));
    }

    public static HitResult rayTrace(Entity entity, Level world, ClipContext.Block blockMode, ClipContext.Fluid fluidMode, double range) {
        Vec3 startPos = entity.m_146892_();
        Vec3 ray = entity.m_20252_(1.0f).m_82490_(range);
        Vec3 endPos = startPos.m_82549_(ray);
        ClipContext context = new ClipContext(startPos, endPos, blockMode, fluidMode, entity);
        return world.m_45547_(context);
    }

    @Nullable
    public static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> getTicker(BlockEntityType<A> type, BlockEntityType<E> targetType, BlockEntityTicker<? super E> ticker) {
        return targetType == type ? ticker : null;
    }

    public static boolean mayBuild(Player player, BlockPos pos) {
        if (player.m_150110_().f_35938_) {
            return true;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            return !player.m_36187_(player.f_19853_, pos, sp.f_8941_.m_9290_());
        }
        return !player.m_36187_(player.f_19853_, pos, Minecraft.m_91087_().f_91072_.m_105295_());
    }
}

