/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.map.client;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import net.mehvahdjukaar.moonlight.api.integration.MapAtlasCompat;
import net.mehvahdjukaar.moonlight.api.map.CustomMapDecoration;
import net.mehvahdjukaar.moonlight.core.CompatHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;

public class DecorationRenderer<T extends CustomMapDecoration> {
    private final RenderType RENDER_TYPE;
    private final int mapColor;
    private final boolean renderOnFrame;
    public boolean rendersText = true;
    private final ResourceLocation textureId;

    public DecorationRenderer(ResourceLocation texture, int mapColor, boolean renderOnFrame) {
        this.RENDER_TYPE = RenderType.m_110497_((ResourceLocation)texture);
        this.renderOnFrame = renderOnFrame;
        this.mapColor = mapColor;
        this.textureId = texture;
    }

    public ResourceLocation getTextureId() {
        return this.textureId;
    }

    public DecorationRenderer(ResourceLocation texture, int mapColor) {
        this(texture, mapColor, true);
    }

    public DecorationRenderer(ResourceLocation texture) {
        this(texture, -1, true);
    }

    public int getColor(T decoration) {
        return this.mapColor;
    }

    public RenderType getRenderType(T decoration) {
        return this.RENDER_TYPE;
    }

    public boolean render(T decoration, PoseStack matrixStack, MultiBufferSource buffer, MapItemSavedData mapData, boolean isOnFrame, int light, int index) {
        VertexConsumer vertexBuilder = buffer.m_6299_(this.getRenderType(decoration));
        return this.render(decoration, matrixStack, buffer, vertexBuilder, mapData, isOnFrame, light, index);
    }

    public boolean render(T decoration, PoseStack matrixStack, MultiBufferSource buffer, VertexConsumer vertexBuilder, MapItemSavedData mapData, boolean isOnFrame, int light, int index) {
        if (!isOnFrame || this.renderOnFrame) {
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)(0.0f + (float)((CustomMapDecoration)decoration).getX() / 2.0f + 64.0f), (double)(0.0f + (float)((CustomMapDecoration)decoration).getY() / 2.0f + 64.0f), (double)-0.02f);
            matrixStack.m_85845_(Vector3f.f_122227_.m_122240_((float)(((CustomMapDecoration)decoration).getRot() * 360) / 16.0f));
            matrixStack.m_85841_(4.0f, 4.0f, 3.0f);
            if (CompatHandler.MAP_ATLASES) {
                MapAtlasCompat.scaleDecoration(matrixStack);
            }
            Matrix4f matrix4f1 = matrixStack.m_85850_().m_85861_();
            int color = this.getColor(decoration);
            int b = NativeImage.m_85085_((int)color);
            int g = NativeImage.m_85103_((int)color);
            int r = NativeImage.m_85119_((int)color);
            vertexBuilder.m_85982_(matrix4f1, -1.0f, 1.0f, (float)index * -0.001f).m_6122_(r, g, b, 255).m_7421_(0.0f, 1.0f).m_85969_(light).m_5752_();
            vertexBuilder.m_85982_(matrix4f1, 1.0f, 1.0f, (float)index * -0.001f).m_6122_(r, g, b, 255).m_7421_(1.0f, 1.0f).m_85969_(light).m_5752_();
            vertexBuilder.m_85982_(matrix4f1, 1.0f, -1.0f, (float)index * -0.001f).m_6122_(r, g, b, 255).m_7421_(1.0f, 0.0f).m_85969_(light).m_5752_();
            vertexBuilder.m_85982_(matrix4f1, -1.0f, -1.0f, (float)index * -0.001f).m_6122_(r, g, b, 255).m_7421_(0.0f, 0.0f).m_85969_(light).m_5752_();
            matrixStack.m_85849_();
            if (((CustomMapDecoration)decoration).getDisplayName() != null && this.rendersText) {
                Font font = Minecraft.m_91087_().f_91062_;
                Component displayName = ((CustomMapDecoration)decoration).getDisplayName();
                float width = font.m_92852_((FormattedText)displayName);
                float scale = Mth.m_14036_((float)(25.0f / width), (float)0.0f, (float)0.6666667f);
                matrixStack.m_85836_();
                matrixStack.m_85837_((double)(0.0f + (float)((CustomMapDecoration)decoration).getX() / 2.0f + 64.0f - width * scale / 2.0f), (double)(0.0f + (float)((CustomMapDecoration)decoration).getY() / 2.0f + 64.0f + 4.0f), (double)-0.025f);
                if (CompatHandler.MAP_ATLASES) {
                    MapAtlasCompat.scaleDecorationText(matrixStack, width, scale);
                }
                matrixStack.m_85841_(scale, scale, 1.0f);
                matrixStack.m_85837_(0.0, 0.0, (double)-0.1f);
                font.m_92841_(displayName, 0.0f, 0.0f, -1, false, matrixStack.m_85850_().m_85861_(), buffer, false, Integer.MIN_VALUE, light);
                matrixStack.m_85849_();
            }
            return true;
        }
        return false;
    }
}

