/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.client.terraform;

import de.cristelknight.doapi.DoApiExpectPlatform;
import dev.architectury.registry.client.level.entity.EntityModelLayerRegistry;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.resources.ResourceLocation;

public final class TerraformBoatClientHelper {
    private TerraformBoatClientHelper() {
    }

    private static ResourceLocation getLayerId(ResourceLocation boatId, boolean chest) {
        String prefix = chest ? "chest_boat/" : "boat/";
        return new ResourceLocation(boatId.m_135827_(), prefix + boatId.m_135815_());
    }

    public static ModelLayerLocation getLayer(ResourceLocation boatId, boolean chest) {
        return new ModelLayerLocation(TerraformBoatClientHelper.getLayerId(boatId, chest), "main");
    }

    private static void registerModelLayer(ResourceLocation boatId, boolean chest) {
        EntityModelLayerRegistry.register((ModelLayerLocation)TerraformBoatClientHelper.getLayer(boatId, chest), () -> BoatModel.m_233347_((boolean)chest));
    }

    public static void registerModelLayers(ResourceLocation boatId) {
        TerraformBoatClientHelper.registerModelLayer(boatId, false);
        TerraformBoatClientHelper.registerModelLayer(boatId, true);
    }

    public static void registerAllModelLayers() {
        for (ResourceLocation location : DoApiExpectPlatform.getAllDoApiBoatTypeNames()) {
            TerraformBoatClientHelper.registerModelLayers(location);
        }
    }

    public static void preClientInit() {
        TerraformBoatClientHelper.registerAllModelLayers();
    }
}

