/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.client.render.feature;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import de.cristelknight.doapi.Util;
import de.cristelknight.doapi.api.DoApiAPI;
import de.cristelknight.doapi.api.DoApiPlugin;
import de.cristelknight.doapi.client.render.feature.FullCustomArmor;
import de.cristelknight.doapi.common.item.CustomArmorItem;
import java.util.List;
import java.util.Map;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DyeableArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CustomArmorFeatureRenderer<T extends LivingEntity, M extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    public Map<FullCustomArmor, Pair<HumanoidModel<T>, HumanoidModel<T>>> MODELS = Maps.newHashMap();
    private final EntityModelSet modelLoader;

    public CustomArmorFeatureRenderer(RenderLayerParent<T, M> context, EntityModelSet modelSet) {
        super(context);
        this.modelLoader = modelSet;
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, T livingEntity, float f, float g, float h, float j, float k, float l) {
        this.renderArmorPiece(poseStack, multiBufferSource, livingEntity, EquipmentSlot.CHEST, i, this.getArmorModel(livingEntity, EquipmentSlot.CHEST));
        this.renderArmorPiece(poseStack, multiBufferSource, livingEntity, EquipmentSlot.LEGS, i, this.getArmorModel(livingEntity, EquipmentSlot.LEGS));
        this.renderArmorPiece(poseStack, multiBufferSource, livingEntity, EquipmentSlot.FEET, i, this.getArmorModel(livingEntity, EquipmentSlot.FEET));
    }

    private void renderArmorPiece(PoseStack poseStack, MultiBufferSource multiBufferSource, T livingEntity, EquipmentSlot equipmentSlot, int i, FullCustomArmor armor) {
        ItemStack itemStack = livingEntity.m_6844_(equipmentSlot);
        Item item = itemStack.m_41720_();
        if (!(item instanceof ArmorItem)) {
            return;
        }
        ArmorItem armorItem = (ArmorItem)item;
        if (armorItem.m_40402_() != equipmentSlot) {
            return;
        }
        if (armor == null) {
            return;
        }
        Pair<HumanoidModel<T>, HumanoidModel<T>> humanoidModels = this.MODELS.get(armor);
        HumanoidModel humanoidModel = this.usesInnerModel(equipmentSlot) ? (HumanoidModel)humanoidModels.getSecond() : (HumanoidModel)humanoidModels.getFirst();
        ((HumanoidModel)this.m_117386_()).m_102872_(humanoidModel);
        this.setPartVisibility(humanoidModel, equipmentSlot);
        boolean bl = this.usesInnerModel(equipmentSlot);
        boolean bl2 = itemStack.m_41790_();
        if (armorItem instanceof DyeableArmorItem) {
            int j = ((DyeableArmorItem)armorItem).m_41121_(itemStack);
            float f = (float)(j >> 16 & 0xFF) / 255.0f;
            float g = (float)(j >> 8 & 0xFF) / 255.0f;
            float h = (float)(j & 0xFF) / 255.0f;
            this.renderModel(poseStack, multiBufferSource, i, armor, bl2, humanoidModel, f, g, h);
        } else {
            this.renderModel(poseStack, multiBufferSource, i, armor, bl2, humanoidModel, 1.0f, 1.0f, 1.0f);
        }
    }

    private void setPartVisibility(HumanoidModel<T> humanoidModel, EquipmentSlot equipmentSlot) {
        humanoidModel.m_8009_(false);
        switch (equipmentSlot) {
            case HEAD: {
                humanoidModel.f_102808_.f_104207_ = true;
                humanoidModel.f_102809_.f_104207_ = true;
                break;
            }
            case CHEST: {
                humanoidModel.f_102810_.f_104207_ = true;
                humanoidModel.f_102811_.f_104207_ = true;
                humanoidModel.f_102812_.f_104207_ = true;
                break;
            }
            case LEGS: {
                humanoidModel.f_102810_.f_104207_ = true;
                humanoidModel.f_102813_.f_104207_ = true;
                humanoidModel.f_102814_.f_104207_ = true;
                break;
            }
            case FEET: {
                humanoidModel.f_102813_.f_104207_ = true;
                humanoidModel.f_102814_.f_104207_ = true;
            }
        }
    }

    private void renderModel(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, FullCustomArmor armor, boolean bl, HumanoidModel<T> humanoidModel, float f, float g, float h) {
        VertexConsumer vertexConsumer = ItemRenderer.m_115184_((MultiBufferSource)multiBufferSource, (RenderType)RenderType.m_110431_((ResourceLocation)armor.texture), (boolean)false, (boolean)bl);
        humanoidModel.m_7695_(poseStack, vertexConsumer, i, OverlayTexture.f_118083_, f, g, h, 1.0f);
    }

    public void addModels(FullCustomArmor armor, HumanoidModel<T> outerModel, HumanoidModel<T> innerModel) {
        this.MODELS.put(armor, new Pair(outerModel, innerModel));
    }

    private FullCustomArmor getArmorModel(T entity, EquipmentSlot slot) {
        CustomArmorItem hatItem = this.getArmorItem(entity, slot);
        if (hatItem != null) {
            if (this.MODELS.isEmpty()) {
                List<DoApiAPI> apis = Util.getApis(DoApiAPI.class, "doapi", DoApiPlugin.class);
                for (DoApiAPI api : apis) {
                    api.registerArmor(this.MODELS, this.modelLoader);
                }
            }
            for (FullCustomArmor armor : this.MODELS.keySet()) {
                if (!armor.set.contains((Object)hatItem)) continue;
                return armor;
            }
        }
        return null;
    }

    private CustomArmorItem getArmorItem(T entity, EquipmentSlot slot) {
        ItemStack armorSlot = entity.m_6844_(slot);
        Item item = armorSlot.m_41720_();
        if (item instanceof CustomArmorItem) {
            CustomArmorItem hat = (CustomArmorItem)item;
            if (!armorSlot.m_41619_()) {
                return hat;
            }
        }
        return null;
    }

    private boolean usesInnerModel(EquipmentSlot equipmentSlot) {
        return equipmentSlot == EquipmentSlot.LEGS;
    }
}

