/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.client.recipebook.screen.widgets;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.cristelknight.doapi.DoApiRL;
import de.cristelknight.doapi.client.recipebook.IRecipeBookGroup;
import de.cristelknight.doapi.client.recipebook.PrivateRecipeBookGhostSlots;
import de.cristelknight.doapi.client.recipebook.handler.AbstractPrivateRecipeScreenHandler;
import de.cristelknight.doapi.client.recipebook.screen.PrivateRecipeBookRecipeArea;
import de.cristelknight.doapi.client.recipebook.screen.widgets.PrivateRecipeGroupButtonWidget;
import de.cristelknight.doapi.config.builtin.RBConfig;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.StateSwitchingButton;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.recipebook.RecipeShownListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.recipebook.PlaceRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public abstract class PrivateRecipeBookWidget
extends GuiComponent
implements PlaceRecipe<Ingredient>,
Widget,
GuiEventListener,
RecipeShownListener {
    public static final ResourceLocation TEXTURE = new DoApiRL("textures/gui/recipe_book.png");
    private static final Component SEARCH_HINT_TEXT = Component.m_237115_((String)"gui.recipebook.search_hint").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY);
    private static final Component TOGGLE_CRAFTABLE_RECIPES_TEXT = Component.m_237115_((String)"gui.recipebook.toggleRecipes.craftable");
    private static final Component TOGGLE_ALL_RECIPES_TEXT = Component.m_237115_((String)"gui.recipebook.toggleRecipes.all");
    protected final PrivateRecipeBookGhostSlots ghostSlots = new PrivateRecipeBookGhostSlots();
    private final List<PrivateRecipeGroupButtonWidget> tabButtons = Lists.newArrayList();
    @Nullable
    private PrivateRecipeGroupButtonWidget currentTab;
    protected StateSwitchingButton toggleCraftableButton;
    protected AbstractPrivateRecipeScreenHandler screenHandler;
    @Nullable
    private EditBox searchField;
    private int leftOffset;
    private int parentWidth;
    private int parentHeight;
    protected Minecraft client;
    private String searchText = "";
    private final PrivateRecipeBookRecipeArea recipesArea = new PrivateRecipeBookRecipeArea();
    private final StackedContents recipeFinder = new StackedContents();
    private int cachedInvChangeCount;
    private boolean searching;
    private boolean open;
    private boolean narrow;

    protected abstract RecipeType<? extends Recipe<Container>> getRecipeType();

    public abstract void insertRecipe(Recipe<?> var1, List<Slot> var2);

    public abstract void showGhostRecipe(Recipe<?> var1, List<Slot> var2);

    public void initialize(int parentWidth, int parentHeight, Minecraft client, boolean narrow, AbstractPrivateRecipeScreenHandler craftingScreenHandler) {
        this.client = client;
        this.parentWidth = parentWidth;
        this.parentHeight = parentHeight;
        this.screenHandler = craftingScreenHandler;
        this.narrow = narrow;
        assert (client.f_91074_ != null);
        client.f_91074_.f_36096_ = craftingScreenHandler;
        this.cachedInvChangeCount = client.f_91074_.m_150109_().m_36072_();
        this.open = this.isGuiOpen();
        if (this.open) {
            this.reset();
        }
        client.f_91068_.m_90926_(true);
    }

    protected void setOpen(boolean opened) {
        if (opened) {
            this.reset();
        }
        this.open = opened;
        RBConfig.setRecipeBookOpenToggle(opened);
        if (!opened) {
            this.recipesArea.hideAlternates();
        }
    }

    public boolean isOpen() {
        return this.open;
    }

    private boolean isGuiOpen() {
        return ((RBConfig)RBConfig.DEFAULT.getConfig()).recipeBookOpen();
    }

    public void toggleOpen() {
        this.setOpen(!this.isOpen());
    }

    public void close() {
        this.client.f_91068_.m_90926_(false);
    }

    private boolean toggleFilteringCraftable() {
        boolean bl = !((RBConfig)RBConfig.DEFAULT.getConfig()).craftableToggle();
        RBConfig.setCraftableToggle(bl);
        return bl;
    }

    public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
        if (this.isOpen()) {
            matrices.m_85836_();
            matrices.m_85837_(0.0, 0.0, 100.0);
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int i = (this.parentWidth - 147) / 2 - this.leftOffset;
            int j = (this.parentHeight - 166) / 2;
            this.m_93228_(matrices, i, j, 1, 1, 147, 166);
            if (!this.searchField.m_93696_() && this.searchField.m_94155_().isEmpty()) {
                PrivateRecipeBookWidget.m_93243_((PoseStack)matrices, (Font)this.client.f_91062_, (Component)SEARCH_HINT_TEXT, (int)(i + 25), (int)(j + 14), (int)-1);
            } else {
                this.searchField.m_6305_(matrices, mouseX, mouseY, delta);
            }
            for (PrivateRecipeGroupButtonWidget recipeGroupButtonWidget : this.tabButtons) {
                recipeGroupButtonWidget.m_6305_(matrices, mouseX, mouseY, delta);
            }
            this.toggleCraftableButton.m_6305_(matrices, mouseX, mouseY, delta);
            this.recipesArea.draw(matrices, i, j, mouseX, mouseY, delta);
            matrices.m_85849_();
        }
    }

    public void drawGhostSlots(PoseStack matrices, int x, int y, boolean bl, float delta) {
        this.ghostSlots.draw(matrices, this.client, x, y, bl, delta);
    }

    public void drawTooltip(PoseStack matrices, int x, int y, int mouseX, int mouseY) {
        if (this.isOpen()) {
            this.recipesArea.drawTooltip(matrices, mouseX, mouseY);
            if (this.toggleCraftableButton.m_198029_()) {
                Component text = this.getCraftableButtonText();
                if (this.client.f_91080_ != null) {
                    this.client.f_91080_.m_96602_(matrices, text, mouseX, mouseY);
                }
            }
            this.drawGhostSlotTooltip(matrices, x, y, mouseX, mouseY);
        }
    }

    private void drawGhostSlotTooltip(PoseStack matrices, int x, int y, int mouseX, int mouseY) {
        ItemStack itemStack = null;
        for (int i = 0; i < this.ghostSlots.getSlotCount(); ++i) {
            PrivateRecipeBookGhostSlots.PrivateGhostInputSlot ghostInputSlot = this.ghostSlots.getSlot(i);
            int j = ghostInputSlot.getX() + x;
            int k = ghostInputSlot.getY() + y;
            if (mouseX < j || mouseY < k || mouseX >= j + 16 || mouseY >= k + 16) continue;
            itemStack = ghostInputSlot.getCurrentItemStack();
        }
        if (itemStack != null && this.client.f_91080_ != null) {
            this.client.f_91080_.m_96597_(matrices, this.client.f_91080_.m_96555_(itemStack), mouseX, mouseY);
        }
    }

    public void update() {
        boolean bl = this.isGuiOpen();
        if (this.isOpen() != bl) {
            this.setOpen(bl);
        }
        if (this.isOpen()) {
            if (this.cachedInvChangeCount != this.client.f_91074_.m_150109_().m_36072_()) {
                this.refreshInputs();
                this.cachedInvChangeCount = this.client.f_91074_.m_150109_().m_36072_();
            }
            this.searchField.m_94120_();
        }
    }

    private void refreshResults(boolean resetCurrentPage) {
        if (this.currentTab == null) {
            return;
        }
        if (this.searchField == null) {
            return;
        }
        List recipes = this.getResultsForGroup(this.currentTab.getGroup(), this.client.f_91073_.m_7465_().m_44013_(this.getRecipeType()));
        String string = this.searchField.m_94155_();
        if (!string.isEmpty()) {
            recipes.removeIf(recipe -> !recipe.m_8043_().m_41786_().getString().toLowerCase(Locale.ROOT).contains(string.toLowerCase(Locale.ROOT)));
        }
        if (((RBConfig)RBConfig.DEFAULT.getConfig()).craftableToggle()) {
            recipes.removeIf(recipe -> !this.screenHandler.hasIngredient((Recipe<?>)recipe));
        }
        this.recipesArea.setResults(recipes, resetCurrentPage);
    }

    private <T extends Recipe<Container>> List<T> getResultsForGroup(IRecipeBookGroup group, List<T> recipes) {
        ArrayList results = Lists.newArrayList();
        for (Recipe recipe : recipes) {
            if (!group.fitRecipe((Recipe<? extends Container>)recipe)) continue;
            results.add(recipe);
        }
        return results;
    }

    private void refreshTabButtons() {
        int i = (this.parentWidth - 147) / 2 - this.leftOffset - 30;
        int j = (this.parentHeight - 166) / 2 + 3;
        int l = 0;
        for (PrivateRecipeGroupButtonWidget recipeGroupButtonWidget : this.tabButtons) {
            recipeGroupButtonWidget.f_93624_ = true;
            recipeGroupButtonWidget.m_94621_(i, j + 27 * l++);
        }
    }

    private void refreshInputs() {
        this.recipeFinder.m_36453_();
        this.client.f_91074_.m_150109_().m_36010_(this.recipeFinder);
        this.refreshResults(false);
    }

    public void reset() {
        this.leftOffset = this.narrow ? 0 : 86;
        int i = (this.parentWidth - 147) / 2 - this.leftOffset;
        int j = (this.parentHeight - 166) / 2;
        this.recipeFinder.m_36453_();
        this.client.f_91074_.m_150109_().m_36010_(this.recipeFinder);
        String string = this.searchField != null ? this.searchField.m_94155_() : "";
        Font var10003 = this.client.f_91062_;
        int var10004 = i + 25;
        int var10005 = j + 14;
        Objects.requireNonNull(this.client.f_91062_);
        this.searchField = new EditBox(var10003, var10004, var10005, 80, 14, (Component)Component.m_237115_((String)"itemGroup.search"));
        this.searchField.m_94199_(50);
        this.searchField.m_94182_(false);
        this.searchField.m_94194_(true);
        this.searchField.m_94202_(0xFFFFFF);
        this.searchField.m_94144_(string);
        this.recipesArea.initialize(this.client, i, j, this.screenHandler);
        this.toggleCraftableButton = new StateSwitchingButton(i + 110, j + 12, 26, 16, ((RBConfig)RBConfig.DEFAULT.getConfig()).craftableToggle());
        this.setCraftableButtonTexture();
        this.tabButtons.clear();
        for (IRecipeBookGroup recipeBookGroup : this.screenHandler.getGroups()) {
            this.tabButtons.add(new PrivateRecipeGroupButtonWidget(recipeBookGroup));
        }
        if (this.currentTab != null) {
            this.currentTab = this.tabButtons.stream().filter(button -> button.getGroup().equals(this.currentTab.getGroup())).findFirst().orElse(null);
        }
        if (this.currentTab == null) {
            this.currentTab = this.tabButtons.get(0);
        }
        this.currentTab.m_94635_(true);
        this.refreshResults(false);
        this.refreshTabButtons();
    }

    public void slotClicked(@Nullable Slot slot) {
        if (slot != null && slot.f_40219_ < this.screenHandler.getCraftingSlotCount()) {
            this.ghostSlots.reset();
            if (this.isOpen()) {
                this.refreshInputs();
            }
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.open && !this.client.f_91074_.m_5833_()) {
            PrivateRecipeGroupButtonWidget vineryRecipeGroupButtonWidget;
            if (this.recipesArea.mouseClicked(mouseX, mouseY, button, (this.parentWidth - 147) / 2 - this.leftOffset, (this.parentHeight - 166) / 2, 147, 166)) {
                Recipe<?> recipe = this.recipesArea.getLastClickedRecipe();
                Recipe<?> recipeBookRecipe = this.recipesArea.getLastClickedRecipe();
                if (recipe != null) {
                    if (this.currentTab == null) {
                        return false;
                    }
                    this.ghostSlots.reset();
                    assert (recipeBookRecipe != null);
                    if (!this.screenHandler.hasIngredient(recipe)) {
                        this.showGhostRecipe(recipe, (List<Slot>)this.screenHandler.f_38839_);
                        return false;
                    }
                    this.ghostSlots.reset();
                    this.insertRecipe(recipe, (List<Slot>)this.screenHandler.f_38839_);
                    this.refreshResults(false);
                }
                return true;
            }
            assert (this.searchField != null);
            if (this.searchField.m_6375_(mouseX, mouseY, button)) {
                return true;
            }
            if (this.toggleCraftableButton.m_6375_(mouseX, mouseY, button)) {
                boolean bl = this.toggleFilteringCraftable();
                this.toggleCraftableButton.m_94635_(bl);
                RBConfig.setCraftableToggle(bl);
                this.refreshResults(false);
                return true;
            }
            Iterator<PrivateRecipeGroupButtonWidget> var6 = this.tabButtons.iterator();
            do {
                if (var6.hasNext()) continue;
                return false;
            } while (!(vineryRecipeGroupButtonWidget = var6.next()).m_6375_(mouseX, mouseY, button));
            if (this.currentTab != vineryRecipeGroupButtonWidget) {
                if (this.currentTab != null) {
                    this.currentTab.m_94635_(false);
                }
                this.currentTab = vineryRecipeGroupButtonWidget;
                this.currentTab.m_94635_(true);
                this.refreshResults(true);
            }
            return false;
        }
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        this.searching = false;
        if (this.isOpen() && !this.client.f_91074_.m_5833_()) {
            if (keyCode == 256 && !this.isWide()) {
                this.setOpen(false);
                return true;
            }
            if (this.searchField.m_7933_(keyCode, scanCode, modifiers)) {
                this.refreshSearchResults();
                return true;
            }
            if (this.searchField.m_93696_() && this.searchField.m_94213_() && keyCode != 256) {
                return true;
            }
            if (this.client.f_91066_.f_92098_.m_90832_(keyCode, scanCode) && !this.searchField.m_93696_()) {
                this.searching = true;
                this.searchField.m_94178_(true);
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        this.searching = false;
        return false;
    }

    public boolean m_5534_(char chr, int modifiers) {
        if (this.searching) {
            return false;
        }
        if (this.isOpen() && !this.client.f_91074_.m_5833_() && this.searchField.m_5534_(chr, modifiers)) {
            this.refreshSearchResults();
            return true;
        }
        return false;
    }

    private void refreshSearchResults() {
        assert (this.searchField != null);
        String string = this.searchField.m_94155_().toLowerCase(Locale.ROOT);
        this.triggerPrivateEasterEgg(string);
        if (!string.equals(this.searchText)) {
            this.refreshResults(false);
            this.searchText = string;
        }
    }

    private void triggerPrivateEasterEgg(String search) {
        String text;
        String name;
        switch (search) {
            case "misslilitu": {
                name = "MissLilitu";
                text = "Boo!";
                break;
            }
            case "satisfy": {
                name = "satisfy";
                text = "Boo!";
                break;
            }
            case "crystalknight": {
                name = "CrystalKnight";
                text = "Boo!";
                break;
            }
            case "bmjo": {
                name = "BaumeisterJO";
                text = "42";
                break;
            }
            default: {
                return;
            }
        }
        LocalPlayer playerEntity = this.client.f_91074_;
        assert (playerEntity != null);
        playerEntity.m_213846_(Component.m_130674_((String)("<" + name + "> " + text)));
        playerEntity.m_5496_(SoundEvents.f_11934_, 0.5f, 1.0f);
    }

    public boolean isClickOutsideBounds(double mouseX, double mouseY, int x, int y, int backgroundWidth, int backgroundHeight) {
        if (!this.isOpen()) {
            return true;
        }
        boolean bl = mouseX < (double)x || mouseY < (double)y || mouseX >= (double)(x + backgroundWidth) || mouseY >= (double)(y + backgroundHeight);
        boolean bl2 = (double)(x - 147) < mouseX && mouseX < (double)x && (double)y < mouseY && mouseY < (double)(y + backgroundHeight);
        return bl && !bl2 && !this.currentTab.m_198029_();
    }

    protected void setCraftableButtonTexture() {
        this.toggleCraftableButton.m_94624_(152, 41, 28, 18, TEXTURE);
    }

    protected Component getToggleCraftableButtonText() {
        return TOGGLE_CRAFTABLE_RECIPES_TEXT;
    }

    private Component getCraftableButtonText() {
        return this.toggleCraftableButton.m_94620_() ? this.getToggleCraftableButtonText() : TOGGLE_ALL_RECIPES_TEXT;
    }

    public int findLeftEdge(int width, int backgroundWidth) {
        int i = this.isOpen() && !this.narrow ? 177 + (width - backgroundWidth - 200) / 2 : (width - backgroundWidth) / 2;
        return i;
    }

    private boolean isWide() {
        return this.leftOffset == 86;
    }

    public void m_5817_(Iterator<Ingredient> inputs, int slot, int amount, int gridX, int gridY) {
    }

    public void m_7262_(List<Recipe<?>> recipes) {
    }
}

