/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi.client.recipebook.screen;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import de.cristelknight.doapi.client.recipebook.handler.AbstractPrivateRecipeScreenHandler;
import de.cristelknight.doapi.client.recipebook.screen.widgets.PrivateAnimatedResultButton;
import de.cristelknight.doapi.client.recipebook.screen.widgets.PrivateRecipeAlternativesWidget;
import de.cristelknight.doapi.client.recipebook.screen.widgets.PrivateRecipeBookWidget;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.StateSwitchingButton;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class PrivateRecipeBookRecipeArea {
    private final List<PrivateAnimatedResultButton> resultButtons = Lists.newArrayListWithCapacity((int)20);
    @Nullable
    private PrivateAnimatedResultButton hoveredResultButton;
    private final PrivateRecipeAlternativesWidget alternatesWidget = new PrivateRecipeAlternativesWidget();
    private Minecraft client;
    private List<? extends Recipe<Container>> resultCollections = ImmutableList.of();
    private StateSwitchingButton nextPageButton;
    private StateSwitchingButton prevPageButton;
    private int pageCount;
    private int currentPage;
    @Nullable
    private Recipe<?> lastClickedRecipe;
    private AbstractPrivateRecipeScreenHandler cookingPanScreenHandler;

    public PrivateRecipeBookRecipeArea() {
        for (int i = 0; i < 20; ++i) {
            this.resultButtons.add(new PrivateAnimatedResultButton());
        }
    }

    public void initialize(Minecraft client, int parentLeft, int parentTop, AbstractPrivateRecipeScreenHandler cookingPanScreenHandler) {
        this.client = client;
        this.cookingPanScreenHandler = cookingPanScreenHandler;
        for (int i = 0; i < this.resultButtons.size(); ++i) {
            this.resultButtons.get(i).setPos(parentLeft + 11 + 25 * (i % 5), parentTop + 31 + 25 * (i / 5));
        }
        this.nextPageButton = new StateSwitchingButton(parentLeft + 93, parentTop + 137, 12, 17, false);
        this.nextPageButton.m_94624_(1, 208, 13, 18, PrivateRecipeBookWidget.TEXTURE);
        this.prevPageButton = new StateSwitchingButton(parentLeft + 38, parentTop + 137, 12, 17, true);
        this.prevPageButton.m_94624_(1, 208, 13, 18, PrivateRecipeBookWidget.TEXTURE);
    }

    public void setResults(List<? extends Recipe<Container>> resultCollections, boolean resetCurrentPage) {
        this.resultCollections = resultCollections;
        this.pageCount = (int)Math.ceil((double)resultCollections.size() / 20.0);
        if (this.pageCount <= this.currentPage || resetCurrentPage) {
            this.currentPage = 0;
        }
        this.refreshResultButtons();
    }

    private void refreshResultButtons() {
        int i = 20 * this.currentPage;
        for (int j = 0; j < this.resultButtons.size(); ++j) {
            PrivateAnimatedResultButton animatedResultButton = this.resultButtons.get(j);
            if (i + j < this.resultCollections.size()) {
                Recipe<Container> recipe = this.resultCollections.get(i + j);
                animatedResultButton.showResultCollection(recipe, this.cookingPanScreenHandler);
                animatedResultButton.f_93624_ = true;
                continue;
            }
            animatedResultButton.f_93624_ = false;
        }
        this.hideShowPageButtons();
    }

    private void hideShowPageButtons() {
        this.nextPageButton.f_93624_ = this.pageCount > 1 && this.currentPage < this.pageCount - 1;
        this.prevPageButton.f_93624_ = this.pageCount > 1 && this.currentPage > 0;
    }

    public void draw(PoseStack matrices, int x, int y, int mouseX, int mouseY, float delta) {
        if (this.pageCount > 1) {
            int var10000 = this.currentPage + 1;
            String string = var10000 + "/" + this.pageCount;
            int i = this.client.f_91062_.m_92895_(string);
            this.client.f_91062_.m_92883_(matrices, string, (float)(x - i / 2 + 73), (float)(y + 141), -1);
        }
        this.hoveredResultButton = null;
        for (PrivateAnimatedResultButton animatedResultButton : this.resultButtons) {
            animatedResultButton.m_6305_(matrices, mouseX, mouseY, delta);
            if (!animatedResultButton.f_93624_ || !animatedResultButton.m_198029_()) continue;
            this.hoveredResultButton = animatedResultButton;
        }
        this.prevPageButton.m_6305_(matrices, mouseX, mouseY, delta);
        this.nextPageButton.m_6305_(matrices, mouseX, mouseY, delta);
        this.alternatesWidget.m_6305_(matrices, mouseX, mouseY, delta);
    }

    public void drawTooltip(PoseStack matrices, int x, int y) {
        if (this.client.f_91080_ != null && this.hoveredResultButton != null && !this.alternatesWidget.isVisible()) {
            this.client.f_91080_.m_96597_(matrices, this.hoveredResultButton.getTooltip(this.client.f_91080_), x, y);
        }
    }

    @Nullable
    public Recipe<?> getLastClickedRecipe() {
        return this.lastClickedRecipe;
    }

    public void hideAlternates() {
        this.alternatesWidget.setVisible(false);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button, int areaLeft, int areaTop, int areaWidth, int areaHeight) {
        PrivateAnimatedResultButton animatedResultButton;
        this.lastClickedRecipe = null;
        if (this.alternatesWidget.isVisible()) {
            if (this.alternatesWidget.m_6375_(mouseX, mouseY, button)) {
                this.lastClickedRecipe = this.alternatesWidget.getLastClickedRecipe();
            } else {
                this.alternatesWidget.setVisible(false);
            }
            return true;
        }
        if (this.nextPageButton.m_6375_(mouseX, mouseY, button)) {
            ++this.currentPage;
            this.refreshResultButtons();
            return true;
        }
        if (this.prevPageButton.m_6375_(mouseX, mouseY, button)) {
            --this.currentPage;
            this.refreshResultButtons();
            return true;
        }
        Iterator<PrivateAnimatedResultButton> var10 = this.resultButtons.iterator();
        do {
            if (var10.hasNext()) continue;
            return false;
        } while (!(animatedResultButton = var10.next()).m_6375_(mouseX, mouseY, button));
        if (button == 0) {
            this.lastClickedRecipe = animatedResultButton.currentRecipe();
        }
        if (button != 1 || this.alternatesWidget.isVisible() || animatedResultButton.hasResult()) {
            // empty if block
        }
        return true;
    }

    public Minecraft getClient() {
        return this.client;
    }
}

