/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight.doapi;

import com.mojang.datafixers.util.Pair;
import de.cristelknight.doapi.DoApiExpectPlatform;
import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Util {
    public static <T> List<T> getApis(Class<T> returnClazz, String name, Class<?> annotationClazz) {
        ArrayList<Object> apis = new ArrayList<Object>();
        for (Pair<List<String>, T> apiPair : DoApiExpectPlatform.findAPIs(returnClazz, name, annotationClazz)) {
            apis.add(apiPair.getSecond());
        }
        return apis;
    }

    public static <T extends Block> RegistrySupplier<T> registerWithItem(DeferredRegister<Block> registerB, Registrar<Block> registrarB, DeferredRegister<Item> registerI, Registrar<Item> registrarI, ResourceLocation name, Supplier<T> block, @Nullable CreativeModeTab tab) {
        RegistrySupplier toReturn = Util.registerWithoutItem(registerB, registrarB, name, block);
        Item.Properties properties = new Item.Properties();
        if (tab != null) {
            properties.m_41491_(tab);
        }
        Util.registerItem(registerI, registrarI, name, () -> new BlockItem((Block)toReturn.get(), properties));
        return toReturn;
    }

    public static <T extends Block> RegistrySupplier<T> registerWithoutItem(DeferredRegister<Block> register, Registrar<Block> registrar, ResourceLocation path, Supplier<T> block) {
        if (Platform.isForge()) {
            return register.register(path.m_135815_(), block);
        }
        return registrar.register(path, block);
    }

    public static <T extends Item> RegistrySupplier<T> registerItem(DeferredRegister<Item> register, Registrar<Item> registrar, ResourceLocation path, Supplier<T> itemSupplier) {
        if (Platform.isForge()) {
            return register.register(path.m_135815_(), itemSupplier);
        }
        return registrar.register(path, itemSupplier);
    }

    public static Collection<ServerPlayer> tracking(ServerLevel world, BlockPos pos) {
        Objects.requireNonNull(pos, "BlockPos cannot be null");
        return Util.tracking(world, new ChunkPos(pos));
    }

    public static Collection<ServerPlayer> tracking(ServerLevel world, ChunkPos pos) {
        Objects.requireNonNull(world, "The world cannot be null");
        Objects.requireNonNull(pos, "The chunk pos cannot be null");
        return world.m_7726_().f_8325_.m_183262_(pos, false);
    }

    public static Optional<Tuple<Float, Float>> getRelativeHitCoordinatesForBlockFace(BlockHitResult blockHitResult, Direction direction, Direction[] unAllowedDirections) {
        Direction direction2 = blockHitResult.m_82434_();
        if (Arrays.stream(unAllowedDirections).toList().contains(direction2)) {
            return Optional.empty();
        }
        if (direction != direction2 && direction2 != Direction.UP && direction2 != Direction.DOWN) {
            return Optional.empty();
        }
        BlockPos blockPos = blockHitResult.m_82425_().m_121945_(direction2);
        Vec3 vec3 = blockHitResult.m_82450_().m_82492_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
        float d = (float)vec3.m_7096_();
        float f = (float)vec3.m_7094_();
        float y = (float)vec3.m_7098_();
        if (direction2 == Direction.UP || direction2 == Direction.DOWN) {
            direction2 = direction;
        }
        return switch (direction2) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> Optional.of(new Tuple((Object)Float.valueOf((float)(1.0 - (double)d)), (Object)Float.valueOf(y)));
            case Direction.SOUTH -> Optional.of(new Tuple((Object)Float.valueOf(d), (Object)Float.valueOf(y)));
            case Direction.WEST -> Optional.of(new Tuple((Object)Float.valueOf(f), (Object)Float.valueOf(y)));
            case Direction.EAST -> Optional.of(new Tuple((Object)Float.valueOf((float)(1.0 - (double)f)), (Object)Float.valueOf(y)));
            case Direction.DOWN, Direction.UP -> Optional.empty();
        };
    }
}

