/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.registrate.builder;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.tterrag.registrate.builders.BuilderCallback;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.providers.loot.RegistrateBlockLootTables;
import com.tterrag.registrate.providers.loot.RegistrateLootTableProvider;
import com.tterrag.registrate.util.OneTimeEventReceiver;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import xyz.apex.forge.apexcore.registrate.CoreRegistrate;
import xyz.apex.forge.apexcore.registrate.builder.AbstractBuilder;
import xyz.apex.forge.apexcore.registrate.builder.BlockEntityBuilder;
import xyz.apex.forge.apexcore.registrate.builder.ItemBuilder;
import xyz.apex.forge.apexcore.registrate.builder.factory.BlockEntityFactory;
import xyz.apex.forge.apexcore.registrate.builder.factory.BlockFactory;
import xyz.apex.forge.apexcore.registrate.builder.factory.BlockItemFactory;
import xyz.apex.forge.apexcore.registrate.entry.BlockEntry;
import xyz.apex.forge.apexcore.registrate.holder.BlockEntityHolder;
import xyz.apex.forge.apexcore.registrate.holder.ItemHolder;

public final class BlockBuilder<OWNER extends CoreRegistrate<OWNER>, BLOCK extends Block, PARENT>
extends AbstractBuilder<OWNER, Block, BLOCK, PARENT, BlockBuilder<OWNER, BLOCK, PARENT>, BlockEntry<BLOCK>> {
    private final BlockFactory<BLOCK> blockFactory;
    private final List<Supplier<Supplier<RenderType>>> renderTypes = Lists.newArrayListWithExpectedSize((int)1);
    private NonNullSupplier<BlockBehaviour.Properties> initialProperties = () -> BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50069_);
    private NonNullFunction<BlockBehaviour.Properties, BlockBehaviour.Properties> propertiesModifier = NonNullUnaryOperator.identity();
    private NonNullSupplier<Supplier<BlockColor>> colorHandler = () -> () -> null;

    public BlockBuilder(OWNER owner, PARENT parent, String name, BuilderCallback callback, BlockFactory<BLOCK> blockFactory) {
        super(owner, parent, name, callback, ForgeRegistries.Keys.BLOCKS, (x$0, x$1) -> new BlockEntry((CoreRegistrate<?>)((CoreRegistrate)x$0), x$1), BlockEntry::cast);
        this.blockFactory = blockFactory;
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> this.onRegister(block -> {
            OneTimeEventReceiver.addModListener(RegisterColorHandlersEvent.Block.class, event -> {
                BlockColor colorHandler = (BlockColor)((Supplier)this.colorHandler.get()).get();
                if (colorHandler != null) {
                    event.register(colorHandler, new Block[]{block});
                }
            });
            OneTimeEventReceiver.addModListener(FMLClientSetupEvent.class, event -> {
                int size = this.renderTypes.size();
                if (size == 1) {
                    RenderType renderType = this.renderTypes.get(0).get().get();
                    ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)renderType);
                } else if (size > 1) {
                    ImmutableSet renderTypes = (ImmutableSet)this.renderTypes.stream().map(Supplier::get).map(Supplier::get).collect(ImmutableSet.toImmutableSet());
                    ItemBlockRenderTypes.setRenderLayer((Block)block, arg_0 -> ((ImmutableSet)renderTypes).contains(arg_0));
                }
            });
        }));
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> properties(NonNullUnaryOperator<BlockBehaviour.Properties> propertiesModifier) {
        this.propertiesModifier = this.propertiesModifier.andThen(propertiesModifier);
        return this;
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> initialProperties(Material material) {
        this.initialProperties = () -> BlockBehaviour.Properties.m_60939_((Material)material);
        return this;
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> initialProperties(Material material, DyeColor dyeColor) {
        this.initialProperties = () -> BlockBehaviour.Properties.m_60941_((Material)material, (DyeColor)dyeColor);
        return this;
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> initialProperties(Material material, MaterialColor materialColor) {
        this.initialProperties = () -> BlockBehaviour.Properties.m_60944_((Material)material, (MaterialColor)materialColor);
        return this;
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> initialProperties(Material material, Function<BlockState, MaterialColor> materialColorFunction) {
        this.initialProperties = () -> BlockBehaviour.Properties.m_60947_((Material)material, (Function)materialColorFunction);
        return this;
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> initialProperties(NonNullSupplier<? extends BlockBehaviour> block) {
        this.initialProperties = () -> BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)block.get()));
        return this;
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> renderType(Supplier<Supplier<RenderType>> renderType) {
        this.renderTypes.add(renderType);
        return this;
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> simpleItem() {
        return (BlockBuilder)this.item().build();
    }

    public <ITEM extends Item> ItemBuilder<OWNER, ITEM, BlockBuilder<OWNER, BLOCK, PARENT>> item(BlockItemFactory<BLOCK, ITEM> blockItemFactory) {
        return (ItemBuilder)((ItemHolder)((Object)this.owner)).item((BlockBuilder)this.self, this.name, properties -> blockItemFactory.create((Block)this.getEntry(), properties)).transform(ItemBuilder::applyBlockItemDefaults);
    }

    public ItemBuilder<OWNER, Item, BlockBuilder<OWNER, BLOCK, PARENT>> item() {
        return this.item(BlockItemFactory.blockItem());
    }

    public <BLOCK_ENTITY extends BlockEntity> BlockBuilder<OWNER, BLOCK, PARENT> simpleBlockEntity(BlockEntityFactory<BLOCK_ENTITY> factory) {
        return (BlockBuilder)this.blockEntity(factory).build();
    }

    public <BLOCK_ENTITY extends BlockEntity> BlockEntityBuilder<OWNER, BLOCK_ENTITY, BlockBuilder<OWNER, BLOCK, PARENT>> blockEntity(BlockEntityFactory<BLOCK_ENTITY> factory) {
        return ((BlockEntityHolder)((Object)this.owner)).blockEntity(this, this.name, factory).validBlock((NonNullSupplier<? extends Block>)((NonNullSupplier<Block>)this.asSupplier()));
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> color(NonNullSupplier<Supplier<BlockColor>> colorHandler) {
        this.colorHandler = colorHandler;
        return this;
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> defaultBlockState() {
        return this.blockState((ctx, provider) -> provider.simpleBlock((Block)ctx.get()));
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> blockState(NonNullBiConsumer<DataGenContext<Block, BLOCK>, RegistrateBlockstateProvider> consumer) {
        return (BlockBuilder)this.setData(ProviderType.BLOCKSTATE, (NonNullBiConsumer)consumer);
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> defaultLang() {
        return (BlockBuilder)this.lang(Block::m_7705_);
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> lang(String name) {
        return (BlockBuilder)this.lang(Block::m_7705_, name);
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> defaultLoot() {
        return this.loot(BlockLoot::m_124288_);
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> loot(NonNullBiConsumer<RegistrateBlockLootTables, BLOCK> consumer) {
        return (BlockBuilder)this.setData(ProviderType.LOOT, (ctx, provider) -> provider.addLootAction(RegistrateLootTableProvider.LootType.BLOCK, lootTables -> {
            if (!((Block)ctx.get()).m_60589_().equals((Object)BuiltInLootTables.f_78712_)) {
                consumer.accept(lootTables, (Object)((Block)ctx.get()));
            }
        }));
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> recipe(NonNullBiConsumer<DataGenContext<Block, BLOCK>, RegistrateRecipeProvider> consumer) {
        return (BlockBuilder)this.setData(ProviderType.RECIPE, (NonNullBiConsumer)consumer);
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> noCollission() {
        return this.properties((NonNullUnaryOperator<BlockBehaviour.Properties>)((NonNullUnaryOperator)BlockBehaviour.Properties::m_60910_));
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> noOcclusion() {
        return this.properties((NonNullUnaryOperator<BlockBehaviour.Properties>)((NonNullUnaryOperator)BlockBehaviour.Properties::m_60955_));
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> friction(float friction) {
        return this.properties((NonNullUnaryOperator<BlockBehaviour.Properties>)((NonNullUnaryOperator)properties -> properties.m_60911_(friction)));
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> speedFactor(float speedFactor) {
        return this.properties((NonNullUnaryOperator<BlockBehaviour.Properties>)((NonNullUnaryOperator)properties -> properties.m_60956_(speedFactor)));
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> jumpFactor(float jumpFactor) {
        return this.properties((NonNullUnaryOperator<BlockBehaviour.Properties>)((NonNullUnaryOperator)properties -> properties.m_60967_(jumpFactor)));
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> sound(SoundType soundType) {
        return this.properties((NonNullUnaryOperator<BlockBehaviour.Properties>)((NonNullUnaryOperator)properties -> properties.m_60918_(soundType)));
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> lightLevel(ToIntFunction<BlockState> lightEmission) {
        return this.properties((NonNullUnaryOperator<BlockBehaviour.Properties>)((NonNullUnaryOperator)properties -> properties.m_60953_(lightEmission)));
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> strength(float destroyTime, float explosionResistance) {
        return this.properties((NonNullUnaryOperator<BlockBehaviour.Properties>)((NonNullUnaryOperator)properties -> properties.m_60913_(destroyTime, explosionResistance)));
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> instabreak() {
        return this.properties((NonNullUnaryOperator<BlockBehaviour.Properties>)((NonNullUnaryOperator)BlockBehaviour.Properties::m_60966_));
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> strength(float strength) {
        return this.properties((NonNullUnaryOperator<BlockBehaviour.Properties>)((NonNullUnaryOperator)properties -> properties.m_60978_(strength)));
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> randomTicks() {
        return this.properties((NonNullUnaryOperator<BlockBehaviour.Properties>)((NonNullUnaryOperator)BlockBehaviour.Properties::m_60977_));
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> dynamicShape() {
        return this.properties((NonNullUnaryOperator<BlockBehaviour.Properties>)((NonNullUnaryOperator)BlockBehaviour.Properties::m_60988_));
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> noLootTable() {
        return this.properties((NonNullUnaryOperator<BlockBehaviour.Properties>)((NonNullUnaryOperator)BlockBehaviour.Properties::m_222994_));
    }

    @Deprecated
    public BlockBuilder<OWNER, BLOCK, PARENT> dropsLike(Block block) {
        return this.properties((NonNullUnaryOperator<BlockBehaviour.Properties>)((NonNullUnaryOperator)properties -> properties.m_60916_(block)));
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> lootFrom(Supplier<? extends Block> block) {
        return this.properties((NonNullUnaryOperator<BlockBehaviour.Properties>)((NonNullUnaryOperator)properties -> properties.lootFrom(block)));
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> air() {
        return this.properties((NonNullUnaryOperator<BlockBehaviour.Properties>)((NonNullUnaryOperator)BlockBehaviour.Properties::m_60996_));
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> isValidSpawn(BlockBehaviour.StateArgumentPredicate<EntityType<?>> predicate) {
        return this.properties((NonNullUnaryOperator<BlockBehaviour.Properties>)((NonNullUnaryOperator)properties -> properties.m_60922_(predicate)));
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> isRedstoneConductor(BlockBehaviour.StatePredicate predicate) {
        return this.properties((NonNullUnaryOperator<BlockBehaviour.Properties>)((NonNullUnaryOperator)properties -> properties.m_60924_(predicate)));
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> isSuffocating(BlockBehaviour.StatePredicate predicate) {
        return this.properties((NonNullUnaryOperator<BlockBehaviour.Properties>)((NonNullUnaryOperator)properties -> properties.m_60960_(predicate)));
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> isViewBlocking(BlockBehaviour.StatePredicate predicate) {
        return this.properties((NonNullUnaryOperator<BlockBehaviour.Properties>)((NonNullUnaryOperator)properties -> properties.m_60971_(predicate)));
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> hasPostProcess(BlockBehaviour.StatePredicate predicate) {
        return this.properties((NonNullUnaryOperator<BlockBehaviour.Properties>)((NonNullUnaryOperator)properties -> properties.m_60982_(predicate)));
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> emissiveRendering(BlockBehaviour.StatePredicate predicate) {
        return this.properties((NonNullUnaryOperator<BlockBehaviour.Properties>)((NonNullUnaryOperator)properties -> properties.m_60991_(predicate)));
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> requiresCorrectToolForDrops() {
        return this.properties((NonNullUnaryOperator<BlockBehaviour.Properties>)((NonNullUnaryOperator)BlockBehaviour.Properties::m_60999_));
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> color(MaterialColor materialColor) {
        return this.properties((NonNullUnaryOperator<BlockBehaviour.Properties>)((NonNullUnaryOperator)properties -> properties.m_155949_(materialColor)));
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> destroyTime(float destroyTime) {
        return this.properties((NonNullUnaryOperator<BlockBehaviour.Properties>)((NonNullUnaryOperator)properties -> properties.m_155954_(destroyTime)));
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> explosionResistance(float explosionResistance) {
        return this.properties((NonNullUnaryOperator<BlockBehaviour.Properties>)((NonNullUnaryOperator)properties -> properties.m_155956_(explosionResistance)));
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> offsetType(BlockBehaviour.OffsetType offsetType) {
        return this.properties((NonNullUnaryOperator<BlockBehaviour.Properties>)((NonNullUnaryOperator)properties -> properties.m_222979_(offsetType)));
    }

    public BlockBuilder<OWNER, BLOCK, PARENT> offsetType(Function<BlockState, BlockBehaviour.OffsetType> offsetFunction) {
        return this.properties((NonNullUnaryOperator<BlockBehaviour.Properties>)((NonNullUnaryOperator)properties -> properties.m_222989_(offsetFunction)));
    }

    @SafeVarargs
    public final BlockBuilder<OWNER, BLOCK, PARENT> tag(TagKey<Block> ... tags) {
        return (BlockBuilder)this.tag(ProviderType.BLOCK_TAGS, tags);
    }

    @SafeVarargs
    public final BlockBuilder<OWNER, BLOCK, PARENT> removeTag(TagKey<Block> ... tags) {
        return (BlockBuilder)this.removeTag(ProviderType.BLOCK_TAGS, tags);
    }

    @Override
    protected BLOCK createEntry() {
        BlockBehaviour.Properties properties = (BlockBehaviour.Properties)this.propertiesModifier.apply((Object)((BlockBehaviour.Properties)this.initialProperties.get()));
        return this.blockFactory.create(properties);
    }

    public static <OWNER extends CoreRegistrate<OWNER>, BLOCK extends Block, PARENT> BlockBuilder<OWNER, BLOCK, PARENT> applyDefaults(BlockBuilder<OWNER, BLOCK, PARENT> builder) {
        return builder.defaultBlockState().defaultLoot().defaultLang();
    }
}

