/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.lib.util;

import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.tags.ITagManager;

public final class RegistryHelper {
    public static <T> ITagManager<T> getTags(IForgeRegistry<T> registry) {
        return Objects.requireNonNull(registry.tags());
    }

    public static <T, R extends T> boolean hasTag(IForgeRegistry<T> registry, TagKey<T> tag, R value) {
        ITagManager tags = Objects.requireNonNull(registry.tags());
        return tags.getTag(tag).contains(value);
    }

    public static <T, R extends T> ResourceLocation getRegistryName(IForgeRegistry<T> registry, R value) {
        return Objects.requireNonNull(registry.getKey(value));
    }

    public static <T> ITagManager<T> getTags(Supplier<IForgeRegistry<T>> registrySupplier) {
        IForgeRegistry<T> registry = Objects.requireNonNull(registrySupplier.get());
        return RegistryHelper.getTags(registry);
    }

    public static <T, R extends T> boolean hasTag(Supplier<IForgeRegistry<T>> registrySupplier, TagKey<T> tag, R value) {
        IForgeRegistry<T> registry = Objects.requireNonNull(registrySupplier.get());
        return RegistryHelper.hasTag(registry, tag, value);
    }

    public static <T, R extends T> ResourceLocation getRegistryName(Supplier<IForgeRegistry<T>> registrySupplier, R value) {
        IForgeRegistry<T> registry = Objects.requireNonNull(registrySupplier.get());
        return RegistryHelper.getRegistryName(registry, value);
    }
}

