/*
 * Decompiled with CFR 0.152.
 */
package xyz.apex.forge.apexcore.lib.block;

import io.netty.buffer.Unpooled;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.Nullable;
import xyz.apex.forge.apexcore.lib.block.IMultiBlock;
import xyz.apex.forge.apexcore.lib.util.ContainerHelper;
import xyz.apex.forge.apexcore.lib.util.NameableMutable;
import xyz.apex.forge.commonality.tags.FluidTags;

public class BaseBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING_4_WAY = BlockStateProperties.f_61374_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public BaseBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.blockConstructor();
    }

    @MustBeInvokedByOverriders
    protected void registerProperties(Consumer<Property<?>> consumer) {
    }

    @MustBeInvokedByOverriders
    protected void preBlockConstructor() {
    }

    private void postBlockConstructor() {
        StateDefinition.Builder builder = new StateDefinition.Builder((Object)this);
        this.registerProperties(xva$0 -> builder.m_61104_(new Property[]{xva$0}));
        StateDefinition stateDefinition = builder.m_61101_(Block::m_49966_, BlockState::new);
        BlockState defaultBlockState = (BlockState)stateDefinition.m_61090_();
        defaultBlockState = BaseBlock.setFacing(defaultBlockState, Direction.NORTH);
        defaultBlockState = BaseBlock.setWaterLogged(defaultBlockState, false);
        this.m_49959_(defaultBlockState);
        ObfuscationReflectionHelper.setPrivateValue(Block.class, (Object)((Object)this), (Object)stateDefinition, (String)"f_49792_");
    }

    private void blockConstructor() {
        this.preBlockConstructor();
        this.postBlockConstructor();
    }

    public final BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState blockState = this.m_49966_();
        Level level = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        if (BaseBlock.supportsWaterLogging(blockState)) {
            FluidState fluidState = level.m_6425_(pos);
            boolean waterLogged = fluidState.m_205070_(FluidTags.Vanilla.WATER) && fluidState.m_76170_();
            blockState = BaseBlock.setWaterLogged(blockState, waterLogged);
        }
        if (BaseBlock.supportsFacing(blockState)) {
            Direction facing = this.getFourWayFacing(ctx);
            facing = facing == null ? BaseBlock.getFacing(this.m_49966_()) : facing;
            blockState = BaseBlock.setFacing(blockState, facing);
        }
        return this.modifyPlacementState(blockState, ctx);
    }

    @MustBeInvokedByOverriders
    public BlockState m_7417_(BlockState blockState, Direction facing, BlockState facingBlockState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (BaseBlock.isWaterLogged(blockState)) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(blockState, facing, facingBlockState, level, pos, facingPos);
    }

    protected final void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        this.registerProperties(xva$0 -> builder.m_61104_(new Property[]{xva$0}));
    }

    public final BlockState m_6843_(BlockState blockState, Rotation rotation) {
        BlockState rotatedBlockState = blockState;
        if (BaseBlock.supportsFacing(blockState)) {
            rotatedBlockState = BaseBlock.setFacing(blockState, rotation.m_55954_(BaseBlock.getFacing(blockState)));
        }
        return this.modifyRotation(rotatedBlockState, rotation);
    }

    public final BlockState m_6943_(BlockState blockState, Mirror mirror) {
        BlockState mirroredBlockState = blockState;
        if (BaseBlock.supportsFacing(blockState)) {
            mirroredBlockState = blockState.m_60717_(mirror.m_54846_(BaseBlock.getFacing(blockState)));
        }
        return this.modifyMirror(mirroredBlockState, mirror);
    }

    public PushReaction m_5537_(BlockState blockState) {
        if (blockState.m_155947_()) {
            return PushReaction.IGNORE;
        }
        return this instanceof IMultiBlock ? PushReaction.DESTROY : super.m_5537_(blockState);
    }

    @Nullable
    @MustBeInvokedByOverriders
    protected BlockState modifyPlacementState(BlockState placementBlockState, BlockPlaceContext ctx) {
        return placementBlockState;
    }

    @MustBeInvokedByOverriders
    protected BlockState modifyRotation(BlockState blockState, Rotation rotation) {
        return blockState;
    }

    @MustBeInvokedByOverriders
    protected BlockState modifyMirror(BlockState blockState, Mirror mirror) {
        return blockState;
    }

    public boolean m_7420_(BlockState blockState, BlockGetter level, BlockPos pos) {
        if (BaseBlock.supportsWaterLogging(blockState)) {
            return !BaseBlock.isWaterLogged(blockState);
        }
        return super.m_7420_(blockState, level, pos);
    }

    public final FluidState m_5888_(BlockState blockState) {
        return BaseBlock.isWaterLogged(blockState) ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    public final boolean m_6044_(BlockGetter level, BlockPos pos, BlockState blockState, Fluid fluid) {
        return BaseBlock.supportsWaterLogging(blockState) && super.m_6044_(level, pos, blockState, fluid);
    }

    public final boolean m_7361_(LevelAccessor level, BlockPos pos, BlockState blockState, FluidState fluidState) {
        return BaseBlock.supportsWaterLogging(blockState) && super.m_7361_(level, pos, blockState, fluidState);
    }

    public final ItemStack m_142598_(LevelAccessor level, BlockPos pos, BlockState blockState) {
        return BaseBlock.supportsWaterLogging(blockState) ? super.m_142598_(level, pos, blockState) : ItemStack.f_41583_;
    }

    public static boolean supportsWaterLogging(BlockState blockState) {
        return blockState.m_61138_((Property)WATERLOGGED);
    }

    public static boolean isWaterLogged(BlockState blockState) {
        return blockState.m_61145_((Property)WATERLOGGED).orElse(false);
    }

    public static BlockState setWaterLogged(BlockState blockState, boolean waterLogged) {
        return BaseBlock.supportsWaterLogging(blockState) ? (BlockState)blockState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterLogged)) : blockState;
    }

    @Nullable
    public Direction getFourWayFacing(BlockPlaceContext ctx) {
        return ctx.m_8125_().m_122424_();
    }

    public static boolean supportsFacing(BlockState blockState) {
        return blockState.m_61138_((Property)FACING_4_WAY);
    }

    public static Direction getFacing(BlockState blockState) {
        return blockState.m_61145_((Property)FACING_4_WAY).orElse(Direction.NORTH);
    }

    public static BlockState setFacing(BlockState blockState, Direction facing) {
        return BaseBlock.supportsFacing(blockState) ? (BlockState)blockState.m_61124_((Property)FACING_4_WAY, (Comparable)facing) : blockState;
    }

    public static abstract class WithContainer<BLOCK_ENTITY extends BlockEntity, CONTAINER extends AbstractContainerMenu>
    extends WithBlockEntity<BLOCK_ENTITY> {
        public WithContainer(BlockBehaviour.Properties properties) {
            super(properties);
        }

        protected abstract MenuType<CONTAINER> getContainerType();

        protected final InteractionResult tryOpenContainerScreen(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
            MenuProvider provider = this.m_7246_(blockState, level, pos);
            if (provider != null) {
                if (level.f_46443_) {
                    return InteractionResult.SUCCESS;
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)provider, buffer -> {
                        BlockPos blockEntityPos = this.getBlockEntityPos(blockState, pos);
                        buffer.m_130064_(blockEntityPos);
                    });
                    return InteractionResult.CONSUME;
                }
            }
            return InteractionResult.PASS;
        }

        public final boolean m_7278_(BlockState blockState) {
            return true;
        }

        public final int m_6782_(BlockState blockState, Level level, BlockPos pos) {
            BlockPos blockEntityPos = this.getBlockEntityPos(blockState, pos);
            return ContainerHelper.getRedstoneSignalFromContainer((LevelAccessor)level, blockEntityPos);
        }

        public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rayTraceResult) {
            return this.tryOpenContainerScreen(blockState, level, pos, player, hand, rayTraceResult);
        }

        @MustBeInvokedByOverriders
        public void m_6810_(BlockState blockState, Level level, BlockPos pos, BlockState newBlockState, boolean isMoving) {
            Object blockEntity;
            if (!blockState.m_60713_(newBlockState.m_60734_()) && (blockEntity = this.getBlockEntity(blockState, (BlockGetter)level, pos)) != null) {
                blockEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(itemHandler -> {
                    BlockPos blockEntityPos = this.getBlockEntityPos(blockState, pos);
                    for (int i = 0; i < itemHandler.getSlots(); ++i) {
                        ItemStack stack = itemHandler.getStackInSlot(i);
                        Containers.m_18992_((Level)level, (double)blockEntityPos.m_123341_(), (double)blockEntityPos.m_123342_(), (double)blockEntityPos.m_123343_(), (ItemStack)stack);
                    }
                });
            }
            super.m_6810_(blockState, level, pos, newBlockState, isMoving);
        }

        @Override
        @Nullable
        public final MenuProvider m_7246_(BlockState blockState, Level level, BlockPos pos) {
            Object blockEntity = this.getBlockEntity(blockState, (BlockGetter)level, pos);
            if (blockEntity != null) {
                MutableComponent containerName = Component.m_237115_((String)this.m_7705_());
                if (blockEntity instanceof Nameable) {
                    Nameable nameable = (Nameable)blockEntity;
                    containerName = nameable.m_5446_();
                }
                return new SimpleMenuProvider((windowId, playerInventory, player) -> {
                    FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
                    BlockPos blockEntityPos = this.getBlockEntityPos(blockState, pos);
                    buffer.m_130064_(blockEntityPos);
                    return this.getContainerType().create(windowId, playerInventory, buffer);
                }, (Component)containerName);
            }
            return super.m_7246_(blockState, level, pos);
        }
    }

    public static abstract class WithBlockEntity<BLOCK_ENTITY extends BlockEntity>
    extends BaseBlock
    implements EntityBlock {
        public WithBlockEntity(BlockBehaviour.Properties properties) {
            super(properties);
        }

        protected abstract BlockEntityType<BLOCK_ENTITY> getBlockEntityType();

        @Nullable
        protected BlockEntityTicker<BLOCK_ENTITY> getBlockEntityTicker(boolean clientSide) {
            return null;
        }

        protected final BlockPos getBlockEntityPos(BlockState blockState, BlockPos pos) {
            WithBlockEntity withBlockEntity = this;
            if (withBlockEntity instanceof IMultiBlock) {
                IMultiBlock multiBlock = (IMultiBlock)((Object)withBlockEntity);
                return multiBlock.getMultiBlockOriginPos(blockState, pos);
            }
            return pos;
        }

        @Nullable
        protected final BLOCK_ENTITY getBlockEntity(BlockState blockState, BlockGetter level, BlockPos pos) {
            BlockPos blockEntityPos = this.getBlockEntityPos(blockState, pos);
            return (BLOCK_ENTITY)this.getBlockEntityType().m_58949_(level, blockEntityPos);
        }

        public final boolean m_8133_(BlockState blockState, Level level, BlockPos pos, int event, int param) {
            BLOCK_ENTITY blockEntity = this.getBlockEntity(blockState, (BlockGetter)level, pos);
            return blockEntity != null && blockEntity.m_7531_(event, param);
        }

        @Nullable
        public final BlockEntity m_142194_(BlockPos pos, BlockState blockState) {
            IMultiBlock multiBlock;
            BlockPos origin;
            WithBlockEntity withBlockEntity = this;
            if (withBlockEntity instanceof IMultiBlock && !(origin = (multiBlock = (IMultiBlock)((Object)withBlockEntity)).getMultiBlockOriginPos(blockState, pos)).equals((Object)pos)) {
                return null;
            }
            return this.getBlockEntityType().m_155264_(pos, blockState);
        }

        @Nullable
        public final <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
            BlockEntityTicker<BLOCK_ENTITY> blockEntityTicker = this.getBlockEntityTicker(level.f_46443_);
            return blockEntityTicker != null ? WithBlockEntity.createTickerHelper(blockEntityType, this.getBlockEntityType(), blockEntityTicker) : null;
        }

        @Nullable
        public final <T extends BlockEntity> GameEventListener m_214009_(ServerLevel level, T blockEntity) {
            GameEventListener gameEventListener;
            return blockEntity instanceof GameEventListener ? (gameEventListener = (GameEventListener)blockEntity) : null;
        }

        @Nullable
        public MenuProvider m_7246_(BlockState blockState, Level level, BlockPos pos) {
            BLOCK_ENTITY blockEntity = this.getBlockEntity(blockState, (BlockGetter)level, pos);
            if (blockEntity instanceof MenuProvider) {
                MenuProvider menuProvider = (MenuProvider)blockEntity;
                return menuProvider;
            }
            if (blockEntity instanceof MenuConstructor) {
                MenuConstructor menuConstructor = (MenuConstructor)blockEntity;
                MutableComponent containerName = Component.m_237115_((String)this.m_7705_());
                if (blockEntity instanceof Nameable) {
                    Nameable nameable = (Nameable)blockEntity;
                    containerName = nameable.m_5446_();
                }
                return new SimpleMenuProvider(menuConstructor, (Component)containerName);
            }
            return null;
        }

        public void m_6402_(Level level, BlockPos pos, BlockState blockState, @Nullable LivingEntity placer, ItemStack stack) {
            BLOCK_ENTITY blockEntity = this.getBlockEntity(blockState, (BlockGetter)level, pos);
            if (blockEntity instanceof NameableMutable) {
                NameableMutable nameable = (NameableMutable)blockEntity;
                if (stack.m_41788_()) {
                    Component customName = stack.m_41786_();
                    nameable.setCustomName(customName);
                }
            }
        }

        @Nullable
        protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> blockEntityType, BlockEntityType<E> otherBlockEntityType, BlockEntityTicker<? super E> blockEntityTicker) {
            return otherBlockEntityType == blockEntityType ? blockEntityTicker : null;
        }
    }
}

