/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.darkhax.bookshelf.api.serialization.ISerializer;
import net.darkhax.bookshelf.api.serialization.NBTParseException;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;

public class SerializerItemStack
implements ISerializer<ItemStack> {
    public static final ISerializer<ItemStack> SERIALIZER = new SerializerItemStack();

    private SerializerItemStack() {
    }

    @Override
    public ItemStack fromJSON(JsonElement json) {
        if (json.isJsonObject()) {
            return ShapedRecipe.m_151274_((JsonObject)json.getAsJsonObject());
        }
        if (json.isJsonPrimitive()) {
            return new ItemStack((ItemLike)Serializers.ITEM.fromJSON(json));
        }
        throw new JsonParseException("Expected JSON object, got " + GsonHelper.m_13883_((JsonElement)json));
    }

    @Override
    public JsonElement toJSON(ItemStack toWrite) {
        JsonObject json = new JsonObject();
        json.add("item", Serializers.ITEM.toJSON(toWrite.m_41720_()));
        json.addProperty("count", (Number)toWrite.m_41613_());
        if (toWrite.m_41782_()) {
            json.add("nbt", Serializers.COMPOUND_TAG.toJSON(toWrite.m_41783_()));
        }
        return json;
    }

    @Override
    public ItemStack fromByteBuf(FriendlyByteBuf buffer) {
        return buffer.m_130267_();
    }

    @Override
    public void toByteBuf(FriendlyByteBuf buffer, ItemStack toWrite) {
        buffer.m_130055_(toWrite);
    }

    @Override
    public Tag toNBT(ItemStack toWrite) {
        return toWrite.m_41739_(new CompoundTag());
    }

    @Override
    public ItemStack fromNBT(Tag nbt) {
        if (nbt instanceof CompoundTag) {
            CompoundTag compound = (CompoundTag)nbt;
            return ItemStack.m_41712_((CompoundTag)compound);
        }
        if (nbt instanceof StringTag) {
            StringTag string = (StringTag)nbt;
            return new ItemStack((ItemLike)Serializers.ITEM.fromNBT((Tag)string));
        }
        throw new NBTParseException("Expected NBT to be a compound tag or string. Class was " + nbt.getClass() + " with ID " + nbt.m_7060_() + " instead.");
    }
}

