/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.api.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import net.darkhax.bookshelf.api.serialization.ISerializer;
import net.darkhax.bookshelf.api.serialization.NBTParseException;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public final class SerializerFloat
implements ISerializer<Float> {
    public static final ISerializer<Float> SERIALIZER = new SerializerFloat();

    private SerializerFloat() {
    }

    @Override
    public Float fromJSON(JsonElement json) {
        return Float.valueOf(json.getAsFloat());
    }

    @Override
    public JsonElement toJSON(Float toWrite) {
        return new JsonPrimitive((Number)toWrite);
    }

    @Override
    public Float fromByteBuf(FriendlyByteBuf buffer) {
        return Float.valueOf(buffer.readFloat());
    }

    @Override
    public void toByteBuf(FriendlyByteBuf buffer, Float toWrite) {
        buffer.writeFloat(toWrite.floatValue());
    }

    @Override
    public Tag toNBT(Float toWrite) {
        return FloatTag.m_128566_((float)toWrite.floatValue());
    }

    @Override
    public Float fromNBT(Tag nbt) {
        if (nbt instanceof NumericTag) {
            NumericTag floatTag = (NumericTag)nbt;
            return Float.valueOf(floatTag.m_7057_());
        }
        throw new NBTParseException("Expected NBT to be a number tag. Class was " + nbt.getClass() + " with ID " + nbt.m_7060_() + " instead.");
    }
}

