/*
 * Decompiled with CFR 0.152.
 */
package fuzs.betteranimationscollection.client.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import fuzs.betteranimationscollection.client.element.PlayfulDoggyElement;
import fuzs.betteranimationscollection.mixin.client.accessor.LayerDefinitionAccessor;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.client.model.WolfModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.Wolf;

public class PlayfulDoggyModel<T extends Wolf>
extends WolfModel<T> {
    public static final int WOLF_TAIL_LENGTH = 7;
    private final ModelPart head;
    private final ModelPart realHead;
    private final ModelPart body;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart tail;
    private final ModelPart realTail;
    private final ModelPart[] realTailParts;
    private final ModelPart fluffyTail;
    private final ModelPart realFluffyTail;
    private final ModelPart[] realFluffyTailParts;
    private final ModelPart upperBody;
    private boolean isInSittingPose;
    private float rollOverAmount;
    private float tickDelta;

    public PlayfulDoggyModel(ModelPart modelPart) {
        super(modelPart);
        this.head = modelPart.m_171324_("head");
        this.realHead = this.head.m_171324_("real_head");
        this.body = modelPart.m_171324_("body");
        this.upperBody = modelPart.m_171324_("upper_body");
        this.rightHindLeg = modelPart.m_171324_("right_hind_leg");
        this.leftHindLeg = modelPart.m_171324_("left_hind_leg");
        this.rightFrontLeg = modelPart.m_171324_("right_front_leg");
        this.leftFrontLeg = modelPart.m_171324_("left_front_leg");
        this.tail = modelPart.m_171324_("tail");
        this.fluffyTail = modelPart.m_171324_("fluffy_tail");
        ModelPart modelPart1 = this.realTail = this.tail.m_171324_("real_tail");
        this.realTailParts = new ModelPart[7];
        for (int i = 0; i < this.realTailParts.length; ++i) {
            this.realTailParts[i] = modelPart1 = modelPart1.m_171324_("real_tail" + i);
        }
        ModelPart modelPart2 = this.realFluffyTail = this.fluffyTail.m_171324_("real_fluffy_tail");
        this.realFluffyTailParts = new ModelPart[7];
        for (int i = 0; i < this.realFluffyTailParts.length; ++i) {
            this.realFluffyTailParts[i] = modelPart2 = modelPart2.m_171324_("real_fluffy_tail" + i);
        }
    }

    public static LayerDefinition createAnimatedBodyLayer() {
        LayerDefinition layerDefinition = WolfModel.m_171088_();
        MeshDefinition meshDefinition = ((LayerDefinitionAccessor)layerDefinition).getMesh();
        PartDefinition partDefinition = meshDefinition.m_171576_();
        PartDefinition partDefinition1 = partDefinition.m_171597_("tail");
        PartDefinition partDefinition3 = partDefinition.m_171599_("fluffy_tail", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-1.0f, (float)12.0f, (float)8.0f, (float)0.62831855f, (float)0.0f, (float)0.0f));
        CubeListBuilder cubeListBuilder = CubeListBuilder.m_171558_().m_171514_(9, 18).m_171481_(0.0f, 0.0f, -1.0f, 2.0f, 1.0f, 2.0f);
        PartDefinition partDefinition2 = partDefinition1.m_171599_("real_tail", cubeListBuilder, PartPose.f_171404_);
        PartDefinition partDefinition4 = partDefinition3.m_171599_("real_fluffy_tail", cubeListBuilder, PartPose.f_171404_);
        for (int i = 0; i < 7; ++i) {
            partDefinition2 = partDefinition2.m_171599_("real_tail" + i, CubeListBuilder.m_171558_().m_171514_(9, Math.min(19 + i, 25)).m_171481_(0.0f, 0.0f, -1.0f, 2.0f, 1.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)0.0f));
            partDefinition4 = partDefinition4.m_171599_("real_fluffy_tail" + i, CubeListBuilder.m_171558_().m_171514_(9, Math.min(19 + i, 25)).m_171488_(0.0f, 0.0f, -1.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(PlayfulDoggyModel.getTailFluffiness(i))), PartPose.m_171419_((float)0.0f, (float)(1.0f + PlayfulDoggyModel.getTailFluffiness(i)), (float)0.0f));
        }
        return layerDefinition;
    }

    private static float getTailFluffiness(int index) {
        if (index < 5) {
            return 0.1f + 0.1f * (float)index;
        }
        if (index == 5) {
            return 0.4f;
        }
        return 0.15f;
    }

    protected Iterable<ModelPart> m_5608_() {
        return (Iterable)Stream.concat(StreamSupport.stream(super.m_5608_().spliterator(), false), Stream.of(this.fluffyTail)).collect(ImmutableList.toImmutableList());
    }

    public void m_7695_(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        if (!this.isInSittingPose || !PlayfulDoggyElement.sittingBehaviour.rollOver() || PlayfulDoggyElement.sittingBehaviour.begForMeat() && (double)this.rollOverAmount < 1.0E-4) {
            super.m_7695_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
            return;
        }
        float rollOverAmount = PlayfulDoggyElement.sittingBehaviour.begForMeat() ? this.rollOverAmount : 0.47123888f;
        matrixStackIn.m_85836_();
        matrixStackIn.m_85837_(0.0, 1.25, 0.0);
        matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(180.0f * rollOverAmount));
        matrixStackIn.m_85837_(0.0, -1.25, 0.0);
        this.rightHindLeg.f_104203_ += rollOverAmount * 1.5f;
        this.leftHindLeg.f_104203_ += rollOverAmount * 1.5f;
        this.rightFrontLeg.f_104203_ += rollOverAmount * 1.5f;
        this.leftFrontLeg.f_104203_ += rollOverAmount * 1.5f;
        this.rightHindLeg.f_104201_ -= rollOverAmount * 1.75f;
        this.leftHindLeg.f_104201_ -= rollOverAmount * 1.75f;
        this.rightFrontLeg.f_104201_ -= rollOverAmount * 1.75f;
        this.leftFrontLeg.f_104201_ -= rollOverAmount * 1.75f;
        this.realHead.f_104205_ = -rollOverAmount * 1.5f;
        super.m_7695_(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        matrixStackIn.m_85849_();
    }

    public void m_6839_(T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.tickDelta = partialTickTime;
        super.m_6839_(entitylivingbaseIn, limbSwing, limbSwingAmount, partialTickTime);
        if (entitylivingbaseIn.m_21825_()) {
            if (PlayfulDoggyElement.sittingBehaviour.lieDown()) {
                this.upperBody.m_104227_(-1.0f, 17.5f, -3.0f);
                this.upperBody.f_104203_ = 1.5707964f;
                this.upperBody.f_104204_ = 0.0f;
                this.body.m_104227_(0.0f, 17.5f, 0.0f);
                this.body.f_104203_ = 1.3463969f;
                this.tail.m_104227_(-1.0f, 19.0f, 6.0f);
                this.rightHindLeg.m_104227_(-2.5f, 22.0f, 5.25f);
                this.rightHindLeg.f_104203_ = 4.712389f;
                this.rightHindLeg.f_104204_ = 0.4f;
                this.leftHindLeg.m_104227_(0.5f, 22.0f, 5.25f);
                this.leftHindLeg.f_104203_ = 4.712389f;
                this.leftHindLeg.f_104204_ = -0.4f;
                this.rightFrontLeg.f_104203_ = 4.712389f;
                this.rightFrontLeg.m_104227_(-2.49f, 21.5f, -2.0f);
                this.rightFrontLeg.f_104204_ = 0.15f;
                this.leftFrontLeg.f_104203_ = 4.712389f;
                this.leftFrontLeg.m_104227_(0.51f, 21.5f, -2.0f);
                this.leftFrontLeg.f_104204_ = -0.15f;
                this.head.f_104201_ = this.f_102610_ ? 15.5f : 17.0f;
            } else {
                this.upperBody.m_104227_(-1.0f, 16.0f, -3.0f);
                this.upperBody.f_104203_ = 1.2566371f;
                this.upperBody.f_104204_ = 0.0f;
                this.tail.m_104227_(-1.0f, 21.0f, 6.0f);
            }
        } else {
            this.upperBody.m_104227_(-1.0f, 14.0f, -3.0f);
            this.upperBody.f_104203_ = this.body.f_104203_;
            this.tail.m_104227_(-1.0f, 12.0f, 8.0f);
            this.head.f_104201_ = 13.5f;
            this.leftFrontLeg.f_104204_ = 0.0f;
            this.rightFrontLeg.f_104204_ = 0.0f;
            this.leftHindLeg.f_104204_ = 0.0f;
            this.rightHindLeg.f_104204_ = 0.0f;
        }
        this.upperBody.f_104205_ = entitylivingbaseIn.m_30432_(partialTickTime, -0.08f);
        this.realTail.f_104205_ = entitylivingbaseIn.m_30432_(partialTickTime, -0.2f);
    }

    public void m_6973_(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.m_6973_(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.isInSittingPose = entityIn.m_21825_();
        this.rollOverAmount = entityIn.m_30448_(1.0f) + entityIn.m_30432_(1.0f, 0.0f);
        this.setupAnimTail(entityIn, limbSwing, limbSwingAmount, this.tickDelta);
    }

    private void setupAnimTail(T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTickTime) {
        float progress = ((float)((Wolf)entitylivingbaseIn).f_19797_ + partialTickTime) / 3.978873f;
        float magnitude = (0.5f + Math.max(limbSwingAmount, entitylivingbaseIn.m_30448_(partialTickTime) * 1.5f)) * 0.25f;
        float amplitude = limbSwing * 0.6662f + progress * 0.6662f;
        if (!entitylivingbaseIn.m_21824_()) {
            this.tail.f_104203_ += Mth.m_14031_((float)amplitude) * magnitude;
            this.tail.f_104204_ = 0.0f;
            for (int i = 0; i < this.realTailParts.length; ++i) {
                this.realTailParts[i].f_104205_ = 0.0f;
                this.realTailParts[i].f_104203_ = Mth.m_14031_((float)(amplitude - (float)(i + 1) * (float)PlayfulDoggyElement.animationSpeed * 0.15f)) * magnitude;
            }
        } else {
            this.tail.f_104204_ = Mth.m_14031_((float)amplitude) * magnitude;
            for (int i = 0; i < this.realTailParts.length; ++i) {
                this.realTailParts[i].f_104203_ = 0.0f;
                this.realTailParts[i].f_104205_ = Mth.m_14031_((float)(amplitude - (float)(i + 1) * (float)PlayfulDoggyElement.animationSpeed * 0.15f)) * magnitude;
            }
        }
        this.copyAllTailParts();
        this.setModelPartVisibilities();
    }

    private void copyAllTailParts() {
        this.fluffyTail.m_104315_(this.tail);
        this.realFluffyTail.m_104315_(this.realTail);
        for (int i = 0; i < this.realTailParts.length; ++i) {
            this.realFluffyTailParts[i].m_104315_(this.realTailParts[i]);
        }
    }

    private void setModelPartVisibilities() {
        this.tail.f_104207_ = !PlayfulDoggyElement.fluffyTail;
        this.fluffyTail.f_104207_ = PlayfulDoggyElement.fluffyTail;
    }
}

